/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.apiary.client.container;

import growthcraft.apiary.client.container.slot.BeeBoxInputSlot;
import growthcraft.apiary.client.container.slot.BeeBoxOutputSlot;
import growthcraft.apiary.common.tileentity.BeeBoxTileEntity;
import growthcraft.apiary.init.GrowthcraftApiaryContainers;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BeeBoxContainer
extends Container {
    private final BeeBoxTileEntity beeBoxTileEntity;
    private final IWorldPosCallable worldPosCallable;

    public BeeBoxContainer(int windowID, PlayerInventory playerInventory, BeeBoxTileEntity tileEntity) {
        super((ContainerType)GrowthcraftApiaryContainers.BEE_BOX_CONTAINER.get(), windowID);
        Slot slot;
        this.beeBoxTileEntity = tileEntity;
        this.worldPosCallable = IWorldPosCallable.func_221488_a((World)tileEntity.func_145831_w(), (BlockPos)tileEntity.func_174877_v());
        int index = 0;
        int itemSlotWidth = 18;
        this.func_75146_a(new BeeBoxInputSlot((IInventory)this.beeBoxTileEntity, index, 80, 18));
        ++index;
        int outputSlotBaseY = 50;
        int outputSlotBaseX = 8;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int slotIndex = 9 + row * 9 + column;
                slot = new BeeBoxOutputSlot((IInventory)this.beeBoxTileEntity, index, outputSlotBaseX + column * itemSlotWidth, outputSlotBaseY + row * itemSlotWidth);
                this.func_75146_a(slot);
                ++index;
            }
        }
        int hotbarBaseY = 176;
        int hotbarBaseX = 8;
        for (int column = 0; column < 9; ++column) {
            slot = new Slot((IInventory)playerInventory, column, hotbarBaseX + column * itemSlotWidth, hotbarBaseY);
            this.func_75146_a(slot);
            ++index;
        }
        int playerInvBaseY = 118;
        int playerInvBaseX = 8;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int slotIndex = 9 + row * 9 + column;
                Slot slot2 = new Slot((IInventory)playerInventory, slotIndex, playerInvBaseX + column * itemSlotWidth, playerInvBaseY + row * itemSlotWidth);
                this.func_75146_a(slot2);
            }
        }
    }

    public BeeBoxContainer(int windowID, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(windowID, playerInventory, BeeBoxContainer.getTileEntity(playerInventory, packetBuffer));
    }

    private static BeeBoxTileEntity getTileEntity(PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        Objects.requireNonNull(playerInventory, "Player inventory cannot be null!");
        Objects.requireNonNull(packetBuffer, "Packet buffer cannot be null!");
        TileEntity tileEntity = playerInventory.field_70458_d.field_70170_p.func_175625_s(packetBuffer.func_179259_c());
        if (tileEntity instanceof BeeBoxTileEntity) {
            return (BeeBoxTileEntity)tileEntity;
        }
        throw new IllegalStateException("BeeBoxContainer found invalid TileEntity: " + tileEntity);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.beeBoxTileEntity.func_213904_e(playerIn);
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack returnStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            returnStack = slotStack.func_77946_l();
            int containerSlots = this.field_75151_b.size() - player.field_71071_by.field_70462_a.size();
            if (index < containerSlots ? !this.func_75135_a(slotStack, containerSlots, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, containerSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == returnStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slotStack);
        }
        return returnStack;
    }
}

