/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import growthcraft.cellar.client.container.FruitPressContainer;
import growthcraft.lib.util.ClientUtils;
import growthcraft.lib.util.TextureHelper;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class FruitPressScreen
extends ContainerScreen<FruitPressContainer> {
    private static final ResourceLocation TEXTURE = TextureHelper.getTextureGui("growthcraft_cellar", "fruit_press");

    public FruitPressScreen(FruitPressContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_147003_i = 0;
        this.field_147009_r = 0;
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    private static TextureAtlasSprite getStillFluidSprite(FluidStack fluidStack) {
        Minecraft minecraft = Minecraft.func_71410_x();
        Fluid fluid = fluidStack.getFluid();
        FluidAttributes attributes = fluid.getAttributes();
        ResourceLocation fluidStill = attributes.getStillTexture(fluidStack);
        return (TextureAtlasSprite)minecraft.func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidStill);
    }

    private int getScaledFluid(float amount, float capacity, int maxPixelSize) {
        float ratio = amount / capacity;
        float scaled = (float)maxPixelSize * ratio;
        return (int)scaled;
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        matrixStack.func_227860_a_();
        IRenderTypeBuffer.Impl renderTypeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        boolean baseX = false;
        boolean baseY = false;
        int maxX = 256;
        int maxY = 256;
        FruitPressScreen.func_238463_a_((MatrixStack)matrixStack, (int)this.field_147003_i, (int)this.field_147009_r, (float)((float)baseX), (float)((float)baseY), (int)this.field_146999_f, (int)this.field_147000_g, (int)maxX, (int)maxY);
        int guiProgressX = this.field_147003_i + 56;
        int guiProgressY = this.field_147009_r + 20;
        this.func_238474_b_(matrixStack, guiProgressX, guiProgressY, 176, 0, 9, ((FruitPressContainer)this.field_147002_h).getProcessingTimeScaled(28));
        int guiInputFluidTankX = this.field_147003_i + 72;
        int guiInputFluidTankY = this.field_147009_r + 17;
        int guiInputFluidTankHeight = 52;
        if (((FruitPressContainer)this.field_147002_h).getTileEntityFluidTank(0).getFluidAmount() > 0) {
            FluidStack fluidStack = ((FruitPressContainer)this.field_147002_h).getTileEntityFluidTank(0).getFluid();
            int scaledFluidHeight = this.getScaledFluid(fluidStack.getAmount(), ((FruitPressContainer)this.field_147002_h).getTileEntityFluidTank(0).getCapacity(), guiInputFluidTankHeight);
            ClientUtils.drawRepeatedFluidSpriteGui((IRenderTypeBuffer)renderTypeBuffer, matrixStack, fluidStack, guiInputFluidTankX, guiInputFluidTankY + (guiInputFluidTankHeight - scaledFluidHeight), 50.0f, scaledFluidHeight);
        }
        renderTypeBuffer.func_228461_a_();
    }

    @ParametersAreNonnullByDefault
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
    }

    @ParametersAreNonnullByDefault
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        int guiInputTankX = this.field_147003_i + 64;
        int guiInputTankY = this.field_147009_r + 17;
        int guiInputTankHeight = 54;
        if (mouseX > guiInputTankX && mouseX < guiInputTankX + 57 && mouseY > guiInputTankY && mouseY < guiInputTankY + guiInputTankHeight) {
            String fluidTankTooltip = "Empty";
            FluidStack fluidStack = ((FruitPressContainer)this.field_147002_h).getTileEntityFluidTank(0).getFluid();
            if (!((FruitPressContainer)this.field_147002_h).getTileEntityFluidTank(0).isEmpty()) {
                fluidTankTooltip = String.format("%s %dmb", fluidStack.getDisplayName().getString(), fluidStack.getAmount());
            }
            StringTextComponent stringTextComponent = new StringTextComponent(fluidTankTooltip);
            this.func_238652_a_(matrixStack, (ITextComponent)stringTextComponent, mouseX, mouseY);
        }
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }
}

