/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.client.ter;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import growthcraft.cellar.common.tileentity.BrewKettleTileEntity;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class BrewKettleTileEntityRenderer
extends TileEntityRenderer<BrewKettleTileEntity> {
    private final Minecraft minecraft = Minecraft.func_71410_x();

    public BrewKettleTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(BrewKettleTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int lightLevel, int overlay) {
        if (tileEntity.getFluidTank(0).isEmpty() && tileEntity.getFluidTank(1).isEmpty()) {
            return;
        }
        FluidStack inputFluidStack = tileEntity.getFluidTank(0).getFluid();
        FluidStack outputFluidStack = tileEntity.getFluidTank(1).getFluid();
        float baseOffset = 0.25f;
        float maxFluidHeight = 0.9375f;
        float inputFluidHeight = baseOffset + (maxFluidHeight - baseOffset) * (float)inputFluidStack.getAmount() / (float)tileEntity.getFluidTank(0).getCapacity();
        float outputFluidHeight = baseOffset + (maxFluidHeight - baseOffset) * (float)outputFluidStack.getAmount() / (float)tileEntity.getFluidTank(0).getCapacity();
        this.renderFluid(inputFluidStack, inputFluidHeight, buffer, matrixStack, lightLevel, overlay);
        this.renderFluid(outputFluidStack, outputFluidHeight, buffer, matrixStack, lightLevel, overlay);
    }

    public void renderIcon(MatrixStack matrixStack, IVertexBuilder builder, TextureAtlasSprite sprite, Color color, float alpha, int overlay, int light) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        Matrix4f mat = matrixStack.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(mat, 0.0f, 16.0f, 0.0f).func_225586_a_(red, green, blue, (int)(alpha * 255.0f)).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(mat, 16.0f, 16.0f, 0.0f).func_225586_a_(red, green, blue, (int)(alpha * 255.0f)).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(mat, 16.0f, 0.0f, 0.0f).func_225586_a_(red, green, blue, (int)(alpha * 255.0f)).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(mat, 1.0f, 0.0f, 1.0f).func_225586_a_(red, green, blue, (int)(alpha * 255.0f)).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
    }

    private void renderFluid(FluidStack fluidStack, float height, IRenderTypeBuffer buffer, MatrixStack matrixStack, int lightLevel, int overlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, (double)height, 0.5);
        float s = 0.05859375f;
        float v = 0.19375f;
        float w = -v * 2.5f;
        float alpha = 2.0f;
        matrixStack.func_227861_a_((double)w, 0.0, (double)w);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227862_a_(s, s, s);
        FluidAttributes fluidAttributes = fluidStack.getFluid().getAttributes();
        Color color = new Color(fluidAttributes.getColor(fluidStack));
        TextureAtlasSprite sprite = (TextureAtlasSprite)this.minecraft.func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidAttributes.getStillTexture(fluidStack));
        IVertexBuilder builder = buffer.getBuffer(Atlases.func_228785_j_());
        this.renderIcon(matrixStack, builder, sprite, color, alpha, overlay, lightLevel);
        matrixStack.func_227865_b_();
    }
}

