/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.block;

import growthcraft.cellar.common.tileentity.RoasterTileEntity;
import growthcraft.cellar.init.GrowthcraftCellarTileEntities;
import growthcraft.cellar.init.config.GrowthcraftCellarConfig;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class RoasterBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty LIT = BooleanProperty.func_177716_a((String)"lit");

    public RoasterBlock() {
        super(RoasterBlock.getInitProperties());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    private static AbstractBlock.Properties getInitProperties() {
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150460_al);
        properties.func_200943_b(1.5f);
        properties.func_226896_b_();
        return properties;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING, LIT});
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)direction.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tile;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (stack.func_82837_s() && (tile = worldIn.func_175625_s(pos)) instanceof RoasterTileEntity) {
            ((RoasterTileEntity)tile).func_213903_a(stack.func_200301_q());
        }
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)LIT) != false && GrowthcraftCellarConfig.getBrewKettleLitLightLevel() >= 0 ? GrowthcraftCellarConfig.getBrewKettleLitLightLevel() : super.getLightValue(state, world, pos);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)GrowthcraftCellarTileEntities.roaster_tileentity.get()).func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileEntity;
        if (!worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) instanceof RoasterTileEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((RoasterTileEntity)tileEntity), (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof RoasterTileEntity && state.func_177230_c() != newState.func_177230_c()) {
            RoasterTileEntity roasterTileEntity = (RoasterTileEntity)tileEntity;
            InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, roasterTileEntity.func_190576_q());
        }
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
            worldIn.func_175713_t(pos);
        }
    }
}

