/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.block.crop;

import growthcraft.cellar.common.tileentity.GrapeVineTileEntity;
import growthcraft.cellar.init.GrowthcraftCellarTileEntities;
import growthcraft.cellar.init.config.GrowthcraftCellarConfig;
import growthcraft.lib.common.block.GrowthcraftCropsRopeBlock;
import growthcraft.lib.util.WorldUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class GrapeCrop
extends GrowthcraftCropsRopeBlock {
    protected static final VoxelShape[] CUSTOM_SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)};
    private static final int FRUIT_MAX = GrowthcraftCellarConfig.getGrapeVineMaxFruitYield();
    private static final int FRUIT_MIN = GrowthcraftCellarConfig.getGrapeVineMinFruitYield();

    public GrapeCrop() {
        super(GrapeCrop.getInitProperties());
    }

    public static AbstractBlock.Properties getInitProperties() {
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k);
        properties.func_200948_a(0.2f, 0.2f);
        properties.harvestTool(ToolType.HOE);
        properties.func_200944_c();
        properties.func_200947_a(SoundType.field_185850_c);
        properties.func_200942_a();
        properties.func_226896_b_();
        return properties;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)GrowthcraftCellarTileEntities.grape_vine_tileentity.get()).func_200968_a();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public BlockState getActualBlockStateWithAge(World world, BlockPos blockPos, int age) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(age));
    }

    @Override
    public boolean canBeConnectedTo(BlockState state, IBlockReader world, BlockPos pos, Direction facing) {
        return false;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return CUSTOM_SHAPE_BY_AGE[(Integer)state.func_177229_b((Property)this.getAgeProperty())];
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.func_201670_d() && ((Integer)state.func_177229_b((Property)AGE)).intValue() == this.getMaxAge()) {
            worldIn.func_184133_a(player, pos, SoundEvents.field_219693_lB, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        if (!worldIn.func_201670_d() && ((Integer)state.func_177229_b((Property)AGE)).intValue() == this.getMaxAge()) {
            GrapeVineTileEntity grapeVineTileEntity = (GrapeVineTileEntity)worldIn.func_175625_s(pos);
            ItemStack itemStack = grapeVineTileEntity.getInventory().getStackInSlot(1);
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemStack);
            grapeVineTileEntity.getInventory().setStackInSlot(1, ItemStack.field_190927_a);
            worldIn.func_180501_a(pos, this.getActualBlockStateWithAge(worldIn, pos, 4), 2);
        }
        return ActionResultType.PASS;
    }

    @Override
    public void doMaxAge(World worldIn, BlockPos pos, BlockState state) {
        GrapeVineTileEntity grapeVineTileEntity = (GrapeVineTileEntity)worldIn.func_175625_s(pos);
        ItemStack itemStack = grapeVineTileEntity.getFruitItemStack();
        itemStack.func_190920_e(this.RANDOM.nextInt(FRUIT_MAX - FRUIT_MIN) + FRUIT_MIN);
        grapeVineTileEntity.getInventory().setStackInSlot(1, itemStack);
        WorldUtils.notifyBlockUpdate(worldIn, pos);
    }
}

