/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.block.crop;

import growthcraft.cellar.common.block.crop.GrapeVineLeavesCrop;
import growthcraft.cellar.common.tileentity.GrapeVineTileEntity;
import growthcraft.cellar.init.GrowthcraftCellarBlocks;
import growthcraft.cellar.init.GrowthcraftCellarTileEntities;
import growthcraft.core.Growthcraft;
import growthcraft.lib.common.block.GrowthcraftCropsRopeBlock;
import growthcraft.lib.util.BlockStateUtils;
import growthcraft.lib.util.WorldUtils;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class GrapeVineCrop
extends GrowthcraftCropsRopeBlock {
    protected static final VoxelShape[] CUSTOM_SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)5.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)5.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0)};

    public GrapeVineCrop() {
        super(GrapeVineCrop.getInitProperties());
    }

    public static AbstractBlock.Properties getInitProperties() {
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k);
        properties.func_200944_c();
        properties.func_200948_a(0.2f, 0.2f);
        properties.harvestTool(ToolType.HOE);
        properties.func_200947_a(SoundType.field_185850_c);
        properties.func_226896_b_();
        return properties;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)GrowthcraftCellarTileEntities.grape_vine_tileentity.get()).func_200968_a();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public void doMaxAge(World worldIn, BlockPos pos, BlockState state) {
        GrapeVineTileEntity grapeVineLeavesTileEntity = (GrapeVineTileEntity)worldIn.func_175625_s(pos);
        if (grapeVineLeavesTileEntity == null) {
            return;
        }
        ItemStack fruitItemStack = grapeVineLeavesTileEntity.getFruitItemStack();
        if (worldIn.func_175623_d(pos.func_177984_a())) {
            worldIn.func_175656_a(pos.func_177984_a(), this.getActualBlockStateWithAge(worldIn, pos.func_177984_a(), 0));
        } else if (BlockStateUtils.isRopeBlock(worldIn.func_180495_p(pos.func_177984_a()).func_177230_c())) {
            worldIn.func_175656_a(pos.func_177984_a(), ((GrapeVineLeavesCrop)GrowthcraftCellarBlocks.GRAPE_VINE_LEAVES.get()).getActualBlockStateWithAge(worldIn, pos.func_177984_a(), 0));
        }
        GrapeVineTileEntity newTileEntity = (GrapeVineTileEntity)worldIn.func_175625_s(pos.func_177984_a());
        if (newTileEntity != null) {
            newTileEntity.setFruitItemStack(fruitItemStack);
        } else {
            Growthcraft.LOGGER.error(String.format("BlockPos [%s] does not have a GrapeVineTileEntity!", pos.func_177984_a()));
        }
        WorldUtils.notifyBlockUpdate(worldIn, pos.func_177984_a());
    }

    @Override
    public boolean canBeConnectedTo(BlockState state, IBlockReader world, BlockPos pos, Direction facing) {
        return BlockStateUtils.isRopeBlock(state.func_177230_c());
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape ropeVoxel = super.func_220053_a(state, worldIn, pos, context);
        ArrayList<VoxelShape> voxelShapeArrayList = new ArrayList<VoxelShape>();
        Map<String, Block> blockMap = BlockStateUtils.getSurroundingBlocks(worldIn, pos);
        if (BlockStateUtils.isRopeBlock(blockMap.get("north"))) {
            voxelShapeArrayList.add(NORTH_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("east"))) {
            voxelShapeArrayList.add(EAST_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("south"))) {
            voxelShapeArrayList.add(SOUTH_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("west"))) {
            voxelShapeArrayList.add(WEST_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("up"))) {
            voxelShapeArrayList.add(UP_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("down"))) {
            voxelShapeArrayList.add(DOWN_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeConnected(worldIn, pos)) {
            voxelShapeArrayList.add(ropeVoxel);
        }
        voxelShapeArrayList.add(CUSTOM_SHAPE_BY_AGE[(Integer)state.func_177229_b((Property)this.getAgeProperty())]);
        VoxelShape[] voxelShapes = new VoxelShape[voxelShapeArrayList.size()];
        voxelShapes = voxelShapeArrayList.toArray(voxelShapes);
        return VoxelShapes.func_216384_a((VoxelShape)CUSTOM_SHAPE_BY_AGE[(Integer)state.func_177229_b((Property)this.getAgeProperty())], (VoxelShape[])voxelShapes);
    }
}

