/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.block.crop;

import growthcraft.cellar.init.GrowthcraftCellarItems;
import growthcraft.cellar.init.config.GrowthcraftCellarConfig;
import growthcraft.lib.common.block.GrowthcraftCropsRopeBlock;
import growthcraft.lib.util.BlockStateUtils;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class HopsCrop
extends GrowthcraftCropsRopeBlock {
    protected static final VoxelShape[] CUSTOM_SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)};
    private static final int fruitMax = GrowthcraftCellarConfig.getHopsCropMaxFruitYield();
    private static final int fruitMin = GrowthcraftCellarConfig.getHopsCropMinFruitYield();

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape ropeVoxel = super.func_220053_a(state, worldIn, pos, context);
        ArrayList<VoxelShape> voxelShapeArrayList = new ArrayList<VoxelShape>();
        Map<String, Block> blockMap = BlockStateUtils.getSurroundingBlocks(worldIn, pos);
        if (BlockStateUtils.isRopeBlock(blockMap.get("north"))) {
            voxelShapeArrayList.add(NORTH_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("east"))) {
            voxelShapeArrayList.add(EAST_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("south"))) {
            voxelShapeArrayList.add(SOUTH_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("west"))) {
            voxelShapeArrayList.add(WEST_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("up"))) {
            voxelShapeArrayList.add(UP_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("down"))) {
            voxelShapeArrayList.add(DOWN_BOUNDING_BOX);
        }
        voxelShapeArrayList.add(ropeVoxel);
        VoxelShape[] voxelShapes = new VoxelShape[voxelShapeArrayList.size()];
        voxelShapes = voxelShapeArrayList.toArray(voxelShapes);
        return VoxelShapes.func_216384_a((VoxelShape)KNOT_BOUNDING_BOX, (VoxelShape[])voxelShapes);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K && (Integer)state.func_177229_b((Property)AGE) == 7) {
            int count = this.RANDOM.nextInt(fruitMax - fruitMin) + fruitMin;
            ItemStack itemStack = new ItemStack((IItemProvider)GrowthcraftCellarItems.HOPS.get(), count);
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemStack);
            worldIn.func_180501_a(pos, this.getActualBlockStateWithAge(worldIn, pos, 4), 2);
        } else if (worldIn.field_72995_K && (Integer)state.func_177229_b((Property)AGE) == 7) {
            worldIn.func_184133_a(player, pos, SoundEvents.field_219693_lB, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return ActionResultType.PASS;
    }
}

