/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.recipe;

import com.google.gson.JsonObject;
import growthcraft.cellar.GrowthcraftCellar;
import growthcraft.cellar.common.recipe.BrewKettleRecipe;
import growthcraft.lib.util.CraftingUtils;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BrewKettleRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<BrewKettleRecipe> {
    public BrewKettleRecipe read(ResourceLocation recipeId, JsonObject json) {
        boolean requireHeat = JSONUtils.func_151209_a((JsonObject)json, (String)"requires_heat", (boolean)false);
        boolean requireLid = JSONUtils.func_151209_a((JsonObject)json, (String)"requires_lid", (boolean)false);
        FluidStack inputFluid = CraftingUtils.getFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)"input_fluid"));
        ItemStack inputItem = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"input_item"), (boolean)false);
        FluidStack outputFluid = CraftingUtils.getFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)"output_fluid"));
        ItemStack byProduct = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"by_product"), (boolean)false);
        int byProductChance = JSONUtils.func_151208_a((JsonObject)json, (String)"by_product_chance", (int)25);
        return new BrewKettleRecipe(recipeId, inputFluid, inputItem, outputFluid, byProduct, requireLid, requireHeat, byProductChance);
    }

    @Nullable
    public BrewKettleRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            ItemStack inputItem = buffer.func_150791_c();
            FluidStack inputFluid = buffer.readFluidStack();
            FluidStack outputFluid = buffer.readFluidStack();
            ItemStack byProduct = buffer.func_150791_c();
            boolean lid = buffer.readBoolean();
            boolean heat = buffer.readBoolean();
            int byProductChance = buffer.func_150792_a();
            return new BrewKettleRecipe(recipeId, inputFluid, inputItem, outputFluid, byProduct, lid, heat, byProductChance);
        }
        catch (Exception ex) {
            GrowthcraftCellar.LOGGER.error("Unable to read recipe from network buffer!");
            throw ex;
        }
    }

    public void write(PacketBuffer buffer, BrewKettleRecipe recipe) {
        try {
            buffer.func_150788_a(recipe.getInputItemStack());
            buffer.writeFluidStack(recipe.getInputFluidStack());
            buffer.writeFluidStack(recipe.getOutputFluidStack());
            buffer.func_150788_a(recipe.getByProduct());
            buffer.writeBoolean(recipe.getLidRequired());
            buffer.writeBoolean(recipe.isHeatRequired());
            buffer.func_150787_b(recipe.getByProductChance());
        }
        catch (Exception ex) {
            GrowthcraftCellar.LOGGER.error("Unable to read recipe from network buffer!");
            throw ex;
        }
    }
}

