/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.recipe;

import growthcraft.cellar.init.GrowthcraftCellarRecipes;
import java.awt.Color;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class FermentBarrelRecipe
implements IRecipe<IInventory> {
    private final ResourceLocation recipeId;
    private final FluidStack inputFluidStack;
    private final FluidStack outputFluidStack;
    private final ItemStack inputItemStack;
    private final int processingTime;
    private final Color color;
    private final ItemStack potionItemStack;

    public FermentBarrelRecipe(ResourceLocation recipeId, FluidStack inputFluidStack, ItemStack inputItemStack, FluidStack outputFluidStack, int processingTime, ItemStack bottle, Color color) {
        this.recipeId = recipeId;
        this.inputFluidStack = inputFluidStack;
        this.outputFluidStack = outputFluidStack;
        this.inputItemStack = inputItemStack;
        this.processingTime = processingTime;
        this.potionItemStack = bottle;
        this.color = color;
        this.potionItemStack.func_200302_a((ITextComponent)this.potionItemStack.func_200301_q().func_230531_f_().func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent(this.outputFluidStack.getTranslationKey())));
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return false;
    }

    public boolean matches(ItemStack matchInputItemStack, FluidStack matchInputFluidStack) {
        boolean inputItemMatches = this.inputItemStack.func_77973_b() == matchInputItemStack.func_77973_b() && this.inputItemStack.func_190916_E() <= matchInputItemStack.func_190916_E();
        boolean inputFluidMatches = this.inputFluidStack.getFluid() == matchInputFluidStack.getFluid() && this.inputFluidStack.getAmount() <= matchInputFluidStack.getAmount();
        return inputItemMatches && inputFluidMatches;
    }

    public boolean matches(FluidStack fluidStack) {
        return this.outputFluidStack.getFluid() == fluidStack.getFluid();
    }

    public boolean matches(ItemStack inputItemStack, FluidStack inputFluidStack, FluidStack outputFluidStack) {
        boolean inputMatches = this.matches(inputItemStack, inputFluidStack);
        boolean outputMatches = this.outputFluidStack.getFluid() == outputFluidStack.getFluid();
        return inputMatches && outputMatches;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.outputFluidStack.getFluid().func_204524_b().func_190903_i();
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return this.outputFluidStack.getFluid().func_204524_b().func_190903_i();
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)GrowthcraftCellarRecipes.FERMENT_BARREL_SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return GrowthcraftCellarRecipes.FERMENT_BARREL_RECIPE_TYPE;
    }

    public String func_193358_e() {
        return "growthcraft";
    }

    public FluidStack getIngredientFluidStack() {
        return this.inputFluidStack;
    }

    public ItemStack getIngredientItemStack() {
        return this.inputItemStack;
    }

    public FluidStack getResultingFluid() {
        return this.outputFluidStack;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public boolean hasEffects() {
        return this.potionItemStack.func_77973_b().func_77636_d(this.potionItemStack);
    }

    public Color getColor() {
        return this.color;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.inputItemStack})});
    }

    public ItemStack getBottleItemStack() {
        return this.potionItemStack;
    }
}

