/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.recipe;

import com.google.gson.JsonObject;
import growthcraft.cellar.GrowthcraftCellar;
import growthcraft.cellar.common.recipe.FruitPressRecipe;
import growthcraft.lib.util.CraftingUtils;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FruitPressRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<FruitPressRecipe> {
    public FruitPressRecipe read(ResourceLocation recipeId, JsonObject json) {
        int processingTime = JSONUtils.func_151203_m((JsonObject)json, (String)"processing_time");
        ItemStack inputItemStack = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"input_item"), (boolean)false);
        FluidStack outputFluid = CraftingUtils.getFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)"output_fluid"));
        ItemStack itemByProduct = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"by_product"), (boolean)false);
        return new FruitPressRecipe(recipeId, inputItemStack, outputFluid, itemByProduct, processingTime);
    }

    @Nullable
    public FruitPressRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            ItemStack inputItemStack = buffer.func_150791_c();
            FluidStack outputFluidStack = buffer.readFluidStack();
            ItemStack byProductItemStack = buffer.func_150791_c();
            int processingTime = buffer.func_150792_a();
            return new FruitPressRecipe(recipeId, inputItemStack, outputFluidStack, byProductItemStack, processingTime);
        }
        catch (Exception ex) {
            GrowthcraftCellar.LOGGER.error("Unable to read recipe from network buffer!");
            throw ex;
        }
    }

    public void write(PacketBuffer buffer, FruitPressRecipe recipe) {
        try {
            buffer.func_150788_a(recipe.getInputItemStack());
            buffer.writeFluidStack(recipe.getOutputFluidStack());
            buffer.func_150788_a(recipe.getByProduct());
            buffer.func_150787_b(recipe.getProcessingTime());
        }
        catch (Exception ex) {
            GrowthcraftCellar.LOGGER.error("Unable to write recipe from network buffer!");
            throw ex;
        }
    }
}

