/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity;

import growthcraft.cellar.client.container.RoasterContainer;
import growthcraft.cellar.common.block.RoasterBlock;
import growthcraft.cellar.common.recipe.RoasterRecipe;
import growthcraft.cellar.init.GrowthcraftCellarRecipes;
import growthcraft.cellar.init.GrowthcraftCellarTileEntities;
import growthcraft.lib.util.BlockStateUtils;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class RoasterTileEntity
extends LockableLootTileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private int maxProcessingTime;
    private int currentProcessingTicks = 0;
    private ITextComponent customName;
    private ItemStack currentRecipeOutput;
    private final IItemHandlerModifiable items = this.createHandler();
    private LazyOptional<IItemHandlerModifiable> itemHandler = LazyOptional.of(() -> this.items);
    private NonNullList<ItemStack> inventoryItemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private RoasterRecipe currentRecipe;

    public RoasterTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    private IItemHandlerModifiable createHandler() {
        return new InvWrapper((IInventory)this);
    }

    public void func_145836_u() {
        super.func_145836_u();
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
            this.itemHandler = null;
        }
    }

    public IItemHandler getInventory() {
        return this.items;
    }

    public NonNullList<ItemStack> func_190576_q() {
        return this.inventoryItemStacks;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.inventoryItemStacks = itemsIn;
    }

    public RoasterTileEntity() {
        this((TileEntityType)GrowthcraftCellarTileEntities.roaster_tileentity.get());
    }

    public void func_73660_a() {
        boolean dirty = false;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (!this.items.getStackInSlot(0).func_190926_b() && this.isHeated()) {
                RoasterRecipe recipe = this.getRecipe(this.items.getStackInSlot(0), this.items.getStackInSlot(1));
                if (recipe != null && !recipe.equals(this.currentRecipe)) {
                    this.currentRecipe = recipe;
                    this.currentRecipeOutput = recipe.getOutputItem();
                }
                if (recipe != null && recipe.equals(this.currentRecipe) && this.items.getStackInSlot(2).func_190916_E() < 64 && this.items.isItemValid(2, recipe.getOutputItem())) {
                    this.maxProcessingTime = recipe.getProcessingTime();
                    ++this.currentProcessingTicks;
                    dirty = true;
                } else if (this.currentRecipe == null && recipe != null) {
                    this.maxProcessingTime = recipe.getProcessingTime();
                    this.currentProcessingTicks = 0;
                    this.currentRecipe = recipe;
                    dirty = true;
                }
                if (this.currentRecipe != null && this.currentProcessingTicks > this.maxProcessingTime && (this.items.getStackInSlot(2).func_77973_b().equals(recipe.getOutputItem().func_77973_b()) || this.items.getStackInSlot(2).func_77973_b().equals(Items.field_190931_a))) {
                    this.items.getStackInSlot(0).func_190918_g(recipe.getInputItemStack().func_190916_E());
                    this.items.insertItem(2, recipe.getOutputItem(), false);
                    this.currentProcessingTicks = 0;
                    this.maxProcessingTime = 0;
                    dirty = true;
                }
            } else {
                this.currentProcessingTicks = 0;
                this.maxProcessingTime = 0;
            }
        }
        if (dirty) {
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_() != null ? this.func_200200_C_() : this.func_213907_g();
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.func_213907_g();
    }

    protected ITextComponent func_213907_g() {
        String translationKey = String.format("container.%s.%s", "growthcraft_cellar", "roaster");
        return new TranslationTextComponent(translationKey);
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new RoasterContainer(windowId, playerInventory, this);
    }

    protected Container func_213906_a(int windowId, PlayerInventory playerInventory) {
        return new RoasterContainer(windowId, playerInventory, this);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
        this.inventoryItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.inventoryItemStacks);
        }
        this.currentProcessingTicks = compound.func_74762_e("CurrentProcessingTicks");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventoryItemStacks);
        compound.func_74768_a("CurrentProcessingTicks", this.currentProcessingTicks);
        return super.func_189515_b(compound);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    public boolean isHeated() {
        Map<String, Block> blockMap = BlockStateUtils.getSurroundingBlocks(this.field_145850_b, this.field_174879_c);
        boolean heated = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("growthcraft", "heatsources")).func_230235_a_((Object)blockMap.get("down"));
        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)RoasterBlock.LIT, (Comparable)Boolean.valueOf(heated)));
        return heated;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return super.getCapability(cap, side);
    }

    public int func_70302_i_() {
        return this.inventoryItemStacks.size();
    }

    @Nullable
    private RoasterRecipe getRecipe(ItemStack inputItemStack, ItemStack redstoneTimerItemStack) {
        List recipes = this.field_145850_b.func_199532_z().func_241447_a_(GrowthcraftCellarRecipes.ROASTER_RECIPE_TYPE);
        for (RoasterRecipe recipe : recipes) {
            if (!recipe.matches(inputItemStack, redstoneTimerItemStack)) continue;
            return recipe;
        }
        return null;
    }

    public int getCurrentProcessingTime() {
        return this.currentProcessingTicks;
    }

    public void setCurrentProcessingTime(int ticks) {
        this.currentProcessingTicks = ticks;
    }

    public int getMaxProcessingTime() {
        return this.maxProcessingTime;
    }

    public void setMaxProcessingTime(int i) {
        this.maxProcessingTime = i;
    }
}

