/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.client.ter;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import growthcraft.core.common.tileentity.RopeTileEntity;
import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class RopeTileEntityRenderer
extends TileEntityRenderer<RopeTileEntity> {
    private final Minecraft minecraft = Minecraft.func_71410_x();

    public RopeTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(RopeTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int lightLevel, int overlay) {
        if (tileEntity.getFenceItemStack().equals(ItemStack.field_190927_a)) {
            return;
        }
        ItemStack itemStack = tileEntity.getFenceItemStack();
        ResourceLocation resourceLocation = Blocks.field_180407_aO.getRegistryName();
        Block block = Blocks.field_196662_n;
        BlockState state = block.func_176223_P();
        BlockRendererDispatcher blockRendererDispatcher = this.minecraft.func_175602_ab();
        TextureAtlasSprite sprite = ((BakedQuad)blockRendererDispatcher.func_184389_a(state).func_200117_a(state, Direction.NORTH, new Random(0L)).get(0)).func_187508_a();
        this.renderCubeUsingQuads(tileEntity, partialTicks, matrixStack, buffer, lightLevel, overlay, sprite);
    }

    public void renderCubeUsingQuads(RopeTileEntity ropeTileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int lightLevel, int overlay, TextureAtlasSprite sprite) {
        Vector3d TRANSLATION_OFFSET = new Vector3d(0.0, 0.01, 0.0);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(TRANSLATION_OFFSET.field_72450_a, TRANSLATION_OFFSET.field_72448_b, TRANSLATION_OFFSET.field_72449_c);
        Color color = new Color(156, 107, 34);
        this.drawCubeQuads(matrixStack, renderTypeBuffer, color, lightLevel, sprite);
        matrixStack.func_227865_b_();
    }

    private void drawCubeQuads(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, Color color, int lightLevel, TextureAtlasSprite sprite) {
        IVertexBuilder vertexBuilderBlockQuads = renderTypeBuffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("growthcraft:textures/block/apple_plank.png")));
        Matrix4f matrixPos = matrixStack.func_227866_c_().func_227870_a_();
        Matrix3f matrixNormal = matrixStack.func_227866_c_().func_227872_b_();
        Vector2f bottomLeftUV = new Vector2f(0.0f, 1.0f);
        float uVwidth = 1.0f;
        float uVheight = 1.0f;
        float WIDTH = 0.25f;
        float HEIGHT = 0.25f;
        float inputFluidHeight = 0.5f;
        Vector3d EAST_FACE_MIDPOINT = new Vector3d(0.625, 0.5, 0.5);
        Vector3d WEST_FACE_MIDPOINT = new Vector3d(0.375, 0.5, 0.5);
        Vector3d NORTH_FACE_MIDPOINT = new Vector3d(0.5, 0.5, 0.375);
        Vector3d SOUTH_FACE_MIDPOINT = new Vector3d(0.5, 0.5, 0.625);
        Vector3d UP_FACE_MIDPOINT = new Vector3d(0.5, 0.99, 0.5);
        Vector3d DOWN_FACE_MIDPOINT = new Vector3d(0.5, 0.0, 0.5);
        this.addFace(Direction.EAST, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, EAST_FACE_MIDPOINT, 0.25f, 0.99f, bottomLeftUV, uVwidth, uVheight, lightLevel, sprite);
        this.addFace(Direction.WEST, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, WEST_FACE_MIDPOINT, 0.25f, 0.99f, bottomLeftUV, uVwidth, uVheight, lightLevel, sprite);
        this.addFace(Direction.NORTH, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, NORTH_FACE_MIDPOINT, 0.25f, 0.99f, bottomLeftUV, uVwidth, uVheight, lightLevel, sprite);
        this.addFace(Direction.SOUTH, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, SOUTH_FACE_MIDPOINT, 0.25f, 0.99f, bottomLeftUV, uVwidth, uVheight, lightLevel, sprite);
        this.addFace(Direction.UP, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, UP_FACE_MIDPOINT, 0.25f, 0.25f, bottomLeftUV, uVwidth, uVheight, lightLevel, sprite);
        this.addFace(Direction.DOWN, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, DOWN_FACE_MIDPOINT, 0.25f, 0.25f, bottomLeftUV, uVwidth, uVheight, lightLevel, sprite);
    }

    private void addFace(Direction face, Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder vertexBuilderBlockQuads, Color color, Vector3d centrePos, float width, float height, Vector2f bottomLeftUV, float texUwidth, float texVheight, int lightLevel, TextureAtlasSprite sprite) {
        Vector3f bottomToTopDirection;
        Vector3f leftToRightDirection;
        switch (face) {
            case NORTH: {
                leftToRightDirection = new Vector3f(-1.0f, 0.0f, 0.0f);
                bottomToTopDirection = new Vector3f(0.0f, 1.0f, 0.0f);
                break;
            }
            case SOUTH: {
                leftToRightDirection = new Vector3f(1.0f, 0.0f, 0.0f);
                bottomToTopDirection = new Vector3f(0.0f, 1.0f, 0.0f);
                break;
            }
            case EAST: {
                leftToRightDirection = new Vector3f(0.0f, 0.0f, -1.0f);
                bottomToTopDirection = new Vector3f(0.0f, 1.0f, 0.0f);
                break;
            }
            case UP: {
                leftToRightDirection = new Vector3f(-1.0f, 0.0f, 0.0f);
                bottomToTopDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                break;
            }
            case DOWN: {
                leftToRightDirection = new Vector3f(1.0f, 0.0f, 0.0f);
                bottomToTopDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                break;
            }
            default: {
                leftToRightDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                bottomToTopDirection = new Vector3f(0.0f, 1.0f, 0.0f);
            }
        }
        leftToRightDirection.func_195898_a(0.5f * width);
        bottomToTopDirection.func_195898_a(0.5f * height);
        Vector3f bottomLeftPos = new Vector3f(centrePos);
        bottomLeftPos.func_195897_a(leftToRightDirection);
        bottomLeftPos.func_195897_a(bottomToTopDirection);
        Vector3f bottomRightPos = new Vector3f(centrePos);
        bottomRightPos.func_229189_a_(leftToRightDirection);
        bottomRightPos.func_195897_a(bottomToTopDirection);
        Vector3f topRightPos = new Vector3f(centrePos);
        topRightPos.func_229189_a_(leftToRightDirection);
        topRightPos.func_229189_a_(bottomToTopDirection);
        Vector3f topLeftPos = new Vector3f(centrePos);
        topLeftPos.func_195897_a(leftToRightDirection);
        topLeftPos.func_229189_a_(bottomToTopDirection);
        Vector2f bottomLeftUVpos = new Vector2f(bottomLeftUV.field_189982_i, bottomLeftUV.field_189983_j);
        Vector2f bottomRightUVpos = new Vector2f(bottomLeftUV.field_189982_i + texUwidth, bottomLeftUV.field_189983_j);
        Vector2f topLeftUVpos = new Vector2f(bottomLeftUV.field_189982_i + texUwidth, bottomLeftUV.field_189983_j + texVheight);
        Vector2f topRightUVpos = new Vector2f(bottomLeftUV.field_189982_i, bottomLeftUV.field_189983_j + texVheight);
        Vector3f normalVector = face.func_229386_k_();
        this.addQuad(matrixPos, matrixNormal, vertexBuilderBlockQuads, bottomLeftPos, bottomRightPos, topRightPos, topLeftPos, bottomLeftUVpos, bottomRightUVpos, topLeftUVpos, topRightUVpos, normalVector, color, lightLevel, sprite);
    }

    private void addQuad(Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder renderBuffer, Vector3f bottomLeftPos, Vector3f bottomRightPos, Vector3f topRightPos, Vector3f topLeftPos, Vector2f bottomLeftUVpos, Vector2f bottomRightUVpos, Vector2f topLeftUVpos, Vector2f topRightUVpos, Vector3f normalVector, Color color, int lightLevel, TextureAtlasSprite sprite) {
        this.addQuadVertex(matrixPos, matrixNormal, renderBuffer, bottomLeftPos, bottomLeftUVpos, normalVector, color, lightLevel, sprite);
        this.addQuadVertex(matrixPos, matrixNormal, renderBuffer, bottomRightPos, bottomRightUVpos, normalVector, color, lightLevel, sprite);
        this.addQuadVertex(matrixPos, matrixNormal, renderBuffer, topRightPos, topRightUVpos, normalVector, color, lightLevel, sprite);
        this.addQuadVertex(matrixPos, matrixNormal, renderBuffer, topLeftPos, topLeftUVpos, normalVector, color, lightLevel, sprite);
    }

    private void addQuadVertex(Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder renderBuffer, Vector3f pos, Vector2f texUV, Vector3f normalVector, Color color, int lightLevel, TextureAtlasSprite sprite) {
        renderBuffer.func_227888_a_(matrixPos, pos.func_195899_a(), pos.func_195900_b(), pos.func_195902_c()).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), 5).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(lightLevel).func_225584_a_(normalVector.func_195899_a(), normalVector.func_195900_b(), normalVector.func_195902_c()).func_181675_d();
    }
}

