/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.init;

import growthcraft.core.Growthcraft;
import growthcraft.core.common.block.RopeBlock;
import growthcraft.lib.common.block.GrowthcraftBlock;
import java.util.ArrayList;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GrowthcraftBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"growthcraft");
    public static final RegistryObject<RopeBlock> ROPE_LINEN = BLOCKS.register("rope_linen", RopeBlock::new);
    public static final RegistryObject<GrowthcraftBlock> SALT_BLOCK = BLOCKS.register("salt_block", () -> new GrowthcraftBlock(Material.field_151576_e, SoundType.field_185851_d));
    public static final RegistryObject<GrowthcraftBlock> SALT_ORE = BLOCKS.register("salt_ore", () -> new GrowthcraftBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150366_p)));

    private GrowthcraftBlocks() {
    }

    public static void registerBlockItems(IForgeRegistry<Item> itemRegistry, Item.Properties properties) {
        Growthcraft.LOGGER.debug("<Growthcraft-Core> Registration of itemBlocks started ...");
        BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
            BlockItem blockItem = new BlockItem(block, properties);
            if (block.getRegistryName() != null && !GrowthcraftBlocks.excludeBlockItemRegistry(block.getRegistryName())) {
                blockItem.setRegistryName(block.getRegistryName());
                itemRegistry.register((IForgeRegistryEntry)blockItem);
            }
        });
        Growthcraft.LOGGER.debug("<Growthcraft-Core> Registration of itemBlocks finished.");
    }

    private static boolean excludeBlockItemRegistry(ResourceLocation registryName) {
        ArrayList<String> excludeBlocks = new ArrayList<String>();
        excludeBlocks.add("growthcraft:rope_linen");
        return excludeBlocks.contains(registryName.toString());
    }
}

