/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.lib.common.block;

import growthcraft.lib.util.BlockStateUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolType;

public class GrowthcraftCropsRopeBlock
extends BushBlock
implements IGrowable {
    public static IntegerProperty AGE = BlockStateProperties.field_208170_W;
    public static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final VoxelShape KNOT_BOUNDING_BOX = GrowthcraftCropsRopeBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0);
    public static final VoxelShape NORTH_BOUNDING_BOX = GrowthcraftCropsRopeBlock.func_208617_a((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)7.0);
    public static final VoxelShape EAST_BOUNDING_BOX = GrowthcraftCropsRopeBlock.func_208617_a((double)9.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    public static final VoxelShape SOUTH_BOUNDING_BOX = GrowthcraftCropsRopeBlock.func_208617_a((double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0, (double)16.0);
    public static final VoxelShape WEST_BOUNDING_BOX = GrowthcraftCropsRopeBlock.func_208617_a((double)0.0, (double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0);
    public static final VoxelShape UP_BOUNDING_BOX = GrowthcraftCropsRopeBlock.func_208617_a((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    public static final VoxelShape DOWN_BOUNDING_BOX = GrowthcraftCropsRopeBlock.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0);
    private Item seedsItem;

    public GrowthcraftCropsRopeBlock() {
        this(GrowthcraftCropsRopeBlock.getInitProperties());
    }

    public GrowthcraftCropsRopeBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public static AbstractBlock.Properties getInitProperties() {
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k);
        properties.func_200944_c();
        properties.func_200948_a(0.2f, 0.2f);
        properties.harvestTool(ToolType.HOE);
        properties.func_200947_a(SoundType.field_185850_c);
        properties.func_226896_b_();
        return properties;
    }

    protected static float getGrowthChance(Block blockIn, IBlockReader worldIn, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = worldIn.func_180495_p(blockpos.func_177982_a(i, 0, j));
                if (blockstate.canSustainPlant(worldIn, blockpos.func_177982_a(i, 0, j), Direction.UP, (IPlantable)blockIn)) {
                    f1 = 1.0f;
                    if (blockstate.isFertile(worldIn, blockpos.func_177982_a(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177968_d();
        BlockPos blockpos3 = pos.func_177976_e();
        BlockPos blockpos4 = pos.func_177974_f();
        boolean flag = blockIn == worldIn.func_180495_p(blockpos3).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4).func_177230_c();
        boolean bl = flag1 = blockIn == worldIn.func_180495_p(blockpos1).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos2).func_177230_c();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockIn == worldIn.func_180495_p(blockpos3.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177968_d()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos3.func_177968_d()).func_177230_c();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos, this.getActualBlockState(worldIn, pos), 2);
    }

    public void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE, NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public void withSeedsItem(Item seedsItem) {
        this.seedsItem = seedsItem;
    }

    public IItemProvider getSeedsItem() {
        assert (this.seedsItem != null);
        return this.seedsItem;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack(this.getSeedsItem());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        ArrayList<VoxelShape> voxelShapeArrayList = new ArrayList<VoxelShape>();
        Map<String, Block> blockMap = BlockStateUtils.getSurroundingBlocks(worldIn, pos);
        if (BlockStateUtils.isRopeBlock(blockMap.get("north"))) {
            voxelShapeArrayList.add(NORTH_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("east"))) {
            voxelShapeArrayList.add(EAST_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("south"))) {
            voxelShapeArrayList.add(SOUTH_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("west"))) {
            voxelShapeArrayList.add(WEST_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("up"))) {
            voxelShapeArrayList.add(UP_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("down"))) {
            voxelShapeArrayList.add(DOWN_BOUNDING_BOX);
        }
        VoxelShape[] voxelShapes = new VoxelShape[voxelShapeArrayList.size()];
        voxelShapes = voxelShapeArrayList.toArray(voxelShapes);
        return VoxelShapes.func_216384_a((VoxelShape)KNOT_BOUNDING_BOX, (VoxelShape[])voxelShapes);
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public int getMaxAge() {
        return 7;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty());
    }

    public BlockState withAge(int age) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_177230_c() == Blocks.field_150458_ak || state.func_177230_c() instanceof GrowthcraftCropsRopeBlock;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150458_ak || state.func_177230_c() instanceof GrowthcraftCropsRopeBlock;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        float f;
        int i;
        super.func_225534_a_(state, worldIn, pos, rand);
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_226659_b_(pos, 0) >= 9 && (i = this.getAge(state)) < this.getMaxAge() && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt((int)(25.0f / (f = GrowthcraftCropsRopeBlock.getGrowthChance((Block)this, (IBlockReader)worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            this.func_225535_a_(worldIn, rand, pos, state);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        this.grow((World)worldIn, pos, state);
    }

    public void grow(World worldIn, BlockPos pos, BlockState state) {
        int j;
        int i = this.getAge(state) + this.getBonemealAgeIncrease(worldIn);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        worldIn.func_180501_a(pos, this.getActualBlockStateWithAge(worldIn, pos, i), 2);
        if (i == this.getMaxAge()) {
            this.doMaxAge(worldIn, pos, state);
        }
    }

    public void doMaxAge(World worldIn, BlockPos pos, BlockState state) {
        if (BlockStateUtils.isRopeBlock(worldIn.func_180495_p(pos.func_177984_a()).func_177230_c()) && !(worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof GrowthcraftCropsRopeBlock)) {
            worldIn.func_175656_a(pos.func_177984_a(), this.getActualBlockStateWithAge(worldIn, pos.func_177984_a(), 0));
        }
    }

    protected int getBonemealAgeIncrease(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)1, (int)3);
    }

    public BlockState getActualBlockStateWithAge(World world, BlockPos blockPos, int age) {
        Map<String, Block> blockMap = BlockStateUtils.getSurroundingBlocks(world, blockPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(BlockStateUtils.isRopeBlock(blockMap.get("north"))))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(BlockStateUtils.isRopeBlock(blockMap.get("east"))))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(BlockStateUtils.isRopeBlock(blockMap.get("south"))))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(BlockStateUtils.isRopeBlock(blockMap.get("west"))))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(BlockStateUtils.isRopeBlock(blockMap.get("up"))))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(BlockStateUtils.isRopeBlock(blockMap.get("down"))))).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(age));
    }

    public BlockState getActualBlockState(World world, BlockPos blockPos) {
        return this.getActualBlockStateWithAge(world, blockPos, (Integer)world.func_180495_p(blockPos).func_177229_b((Property)this.getAgeProperty()));
    }

    public boolean canBeConnectedTo(BlockState state, IBlockReader world, BlockPos pos, Direction facing) {
        return BlockStateUtils.isRopeBlock(state.func_177230_c());
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        worldIn.func_180501_a(pos, this.getActualBlockStateWithAge(worldIn, pos, (Integer)worldIn.func_180495_p(pos).func_177229_b((Property)this.getAgeProperty())), 3);
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }
}

