/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.lib.util;

import growthcraft.core.common.block.RopeBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockStateUtils {
    public static Map<String, Block> getSurroundingBlocks(IBlockReader world, BlockPos pos) {
        HashMap<String, Block> blockMap = new HashMap<String, Block>();
        blockMap.put("north", world.func_180495_p(pos.func_177978_c()).func_177230_c());
        blockMap.put("east", world.func_180495_p(pos.func_177974_f()).func_177230_c());
        blockMap.put("south", world.func_180495_p(pos.func_177968_d()).func_177230_c());
        blockMap.put("west", world.func_180495_p(pos.func_177976_e()).func_177230_c());
        blockMap.put("up", world.func_180495_p(pos.func_177984_a()).func_177230_c());
        blockMap.put("down", world.func_180495_p(pos.func_177977_b()).func_177230_c());
        return blockMap;
    }

    public static Map<String, Block> getSurroundingBlocks(World world, BlockPos pos) {
        HashMap<String, Block> blockMap = new HashMap<String, Block>();
        blockMap.put("north", world.func_180495_p(pos.func_177978_c()).func_177230_c());
        blockMap.put("east", world.func_180495_p(pos.func_177974_f()).func_177230_c());
        blockMap.put("south", world.func_180495_p(pos.func_177968_d()).func_177230_c());
        blockMap.put("west", world.func_180495_p(pos.func_177976_e()).func_177230_c());
        blockMap.put("up", world.func_180495_p(pos.func_177984_a()).func_177230_c());
        blockMap.put("down", world.func_180495_p(pos.func_177977_b()).func_177230_c());
        return blockMap;
    }

    public static Map<BlockPos, BlockState> getSurroundingBlockPos(World world, BlockPos pos) {
        HashMap<BlockPos, BlockState> blockMap = new HashMap<BlockPos, BlockState>();
        blockMap.put(pos.func_177978_c(), world.func_180495_p(pos.func_177978_c()));
        blockMap.put(pos.func_177974_f(), world.func_180495_p(pos.func_177974_f()));
        blockMap.put(pos.func_177968_d(), world.func_180495_p(pos.func_177968_d()));
        blockMap.put(pos.func_177976_e(), world.func_180495_p(pos.func_177976_e()));
        blockMap.put(pos.func_177984_a(), world.func_180495_p(pos.func_177984_a()));
        blockMap.put(pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()));
        return blockMap;
    }

    public static Map<String, Block> getHorizontalBlocks(World world, BlockPos pos) {
        HashMap<String, Block> blockMap = new HashMap<String, Block>();
        blockMap.put("north", world.func_180495_p(pos.func_177978_c()).func_177230_c());
        blockMap.put("east", world.func_180495_p(pos.func_177974_f()).func_177230_c());
        blockMap.put("south", world.func_180495_p(pos.func_177968_d()).func_177230_c());
        blockMap.put("west", world.func_180495_p(pos.func_177976_e()).func_177230_c());
        return blockMap;
    }

    public static Map<BlockPos, BlockState> getHorizontalBlockPos(World world, BlockPos pos) {
        HashMap<BlockPos, BlockState> blockMap = new HashMap<BlockPos, BlockState>();
        blockMap.put(pos.func_177978_c(), world.func_180495_p(pos.func_177978_c()));
        blockMap.put(pos.func_177974_f(), world.func_180495_p(pos.func_177974_f()));
        blockMap.put(pos.func_177968_d(), world.func_180495_p(pos.func_177968_d()));
        blockMap.put(pos.func_177976_e(), world.func_180495_p(pos.func_177976_e()));
        return blockMap;
    }

    public static Map<BlockPos, BlockState> getVerticalBlockPos(World world, BlockPos pos) {
        HashMap<BlockPos, BlockState> blockMap = new HashMap<BlockPos, BlockState>();
        blockMap.put(pos.func_177984_a(), world.func_180495_p(pos.func_177984_a()));
        blockMap.put(pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()));
        return blockMap;
    }

    public static Map<String, BlockState> getSurroundingBlockStates(World world, BlockPos pos) {
        HashMap<String, BlockState> blockMap = new HashMap<String, BlockState>();
        blockMap.put("north", world.func_180495_p(pos.func_177978_c()));
        blockMap.put("east", world.func_180495_p(pos.func_177974_f()));
        blockMap.put("south", world.func_180495_p(pos.func_177968_d()));
        blockMap.put("west", world.func_180495_p(pos.func_177976_e()));
        blockMap.put("up", world.func_180495_p(pos.func_177984_a()));
        blockMap.put("down", world.func_180495_p(pos.func_177977_b()));
        return blockMap;
    }

    public static Direction getFacingFromEntity(BlockPos clickedBlock, LivingEntity placer) {
        return Direction.func_176737_a((float)((float)(placer.func_226277_ct_() - (double)clickedBlock.func_177958_n())), (float)((float)(placer.func_226278_cu_() - (double)clickedBlock.func_177956_o())), (float)((float)(placer.func_226281_cx_() - (double)clickedBlock.func_177952_p())));
    }

    public static boolean isRopeBlock(Block block) {
        try {
            ITag.INamedTag tagRope = BlockTags.func_199894_a((String)new ResourceLocation("growthcraft", "rope").toString());
            return block.func_203417_a((ITag)tagRope) || block instanceof RopeBlock;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isRopeConnected(IBlockReader world, BlockPos pos) {
        Map<String, Block> blockMap = BlockStateUtils.getSurroundingBlocks(world, pos);
        if (BlockStateUtils.isRopeBlock(blockMap.get("north"))) {
            return true;
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("east"))) {
            return true;
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("south"))) {
            return true;
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("west"))) {
            return true;
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("up"))) {
            return true;
        }
        return BlockStateUtils.isRopeBlock(blockMap.get("down"));
    }
}

