/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.lib.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.fluids.FluidStack;

public class ClientUtils {
    public static void drawRepeatedFluidSpriteGui(IRenderTypeBuffer buffer, MatrixStack transform, FluidStack fluid, float x, float y, float w, float h) {
        RenderType renderType = ClientUtils.getGui(PlayerContainer.field_226615_c_);
        IVertexBuilder builder = buffer.getBuffer(renderType);
        ClientUtils.drawRepeatedFluidSprite(builder, transform, fluid, x, y, w, h);
    }

    public static void drawRepeatedFluidSprite(IVertexBuilder builder, MatrixStack transform, FluidStack fluid, float x, float y, float w, float h) {
        TextureAtlasSprite sprite = ClientUtils.getSprite(fluid.getFluid().getAttributes().getStillTexture(fluid));
        int col = fluid.getFluid().getAttributes().getColor(fluid);
        int iW = sprite.func_94211_a();
        int iH = sprite.func_94216_b();
        if (iW > 0 && iH > 0) {
            ClientUtils.drawRepeatedSprite(builder, transform, x, y, w, h, iW, iH, sprite.func_94209_e(), sprite.func_94212_f(), sprite.func_94206_g(), sprite.func_94210_h(), (float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f, 1.0f);
        }
    }

    public static void drawRepeatedSprite(IVertexBuilder builder, MatrixStack transform, float x, float y, float w, float h, int iconWidth, int iconHeight, float uMin, float uMax, float vMin, float vMax, float r, float g, float b, float alpha) {
        int iterMaxW = (int)(w / (float)iconWidth);
        int iterMaxH = (int)(h / (float)iconHeight);
        float leftoverW = w % (float)iconWidth;
        float leftoverH = h % (float)iconHeight;
        float leftoverWf = leftoverW / (float)iconWidth;
        float leftoverHf = leftoverH / (float)iconHeight;
        float iconUDif = uMax - uMin;
        float iconVDif = vMax - vMin;
        for (int ww = 0; ww < iterMaxW; ++ww) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                ClientUtils.drawTexturedRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(hh * iconHeight), iconWidth, iconHeight, r, g, b, alpha, uMin, uMax, vMin, vMax);
            }
            ClientUtils.drawTexturedRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(iterMaxH * iconHeight), iconWidth, leftoverH, r, g, b, alpha, uMin, uMax, vMin, vMin + iconVDif * leftoverHf);
        }
        if (leftoverW > 0.0f) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                ClientUtils.drawTexturedRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(hh * iconHeight), leftoverW, iconHeight, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMax);
            }
            ClientUtils.drawTexturedRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(iterMaxH * iconHeight), leftoverW, leftoverH, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMin + iconVDif * leftoverHf);
        }
    }

    public static void drawTexturedRect(IVertexBuilder builder, MatrixStack transform, float x, float y, float w, float h, float r, float g, float b, float alpha, float u0, float u1, float v0, float v1) {
        Matrix4f mat = transform.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(mat, x, y + h, 0.0f).func_227885_a_(r, g, b, alpha).func_225583_a_(u0, v1).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_225584_a_(1.0f, 1.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(mat, x + w, y + h, 0.0f).func_227885_a_(r, g, b, alpha).func_225583_a_(u1, v1).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_225584_a_(1.0f, 1.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(mat, x + w, y, 0.0f).func_227885_a_(r, g, b, alpha).func_225583_a_(u1, v0).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_225584_a_(1.0f, 1.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(mat, x, y, 0.0f).func_227885_a_(r, g, b, alpha).func_225583_a_(u0, v0).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_225584_a_(1.0f, 1.0f, 1.0f).func_181675_d();
    }

    public static void drawTexturedRect(IVertexBuilder builder, MatrixStack transform, int x, int y, int w, int h, float picSize, int u0, int u1, int v0, int v1) {
        ClientUtils.drawTexturedRect(builder, transform, x, y, w, h, 1.0f, 1.0f, 1.0f, 1.0f, (float)u0 / picSize, (float)u1 / picSize, (float)v0 / picSize, (float)v1 / picSize);
    }

    public static RenderType getGui(ResourceLocation texture) {
        return RenderType.func_228632_a_((String)("gui_" + texture), (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228713_a_(new RenderState.AlphaState(0.5f)).func_228728_a_(false));
    }

    public static TextureAtlasSprite getSprite(ResourceLocation rl) {
        return Minecraft.func_71410_x().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(rl);
    }
}

