/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import growthcraft.lib.util.ClientUtils;
import growthcraft.lib.util.TextureHelper;
import growthcraft.milk.client.container.ChurnContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class ChurnScreen
extends ContainerScreen<ChurnContainer> {
    private static final ResourceLocation TEXTURE = TextureHelper.getTextureGui("growthcraft_milk", "churn");

    public ChurnScreen(ChurnContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_147003_i = 0;
        this.field_147009_r = 0;
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    private static TextureAtlasSprite getStillFluidSprite(FluidStack fluidStack) {
        Minecraft minecraft = Minecraft.func_71410_x();
        Fluid fluid = fluidStack.getFluid();
        FluidAttributes attributes = fluid.getAttributes();
        ResourceLocation fluidStill = attributes.getStillTexture(fluidStack);
        return (TextureAtlasSprite)minecraft.func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidStill);
    }

    private int getScaledFluid(float amount, float capacity, int maxPixelSize) {
        float ratio = amount / capacity;
        float scaled = (float)maxPixelSize * ratio;
        return (int)scaled;
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        matrixStack.func_227860_a_();
        IRenderTypeBuffer.Impl renderTypeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        boolean baseX = false;
        boolean baseY = false;
        int maxX = 256;
        int maxY = 256;
        ChurnScreen.func_238463_a_((MatrixStack)matrixStack, (int)this.field_147003_i, (int)this.field_147009_r, (float)((float)baseX), (float)((float)baseY), (int)this.field_146999_f, (int)this.field_147000_g, (int)maxX, (int)maxY);
        int guiFluidTankX = this.field_147003_i + 65;
        int guiFluidTankY = this.field_147009_r + 18;
        int guiFluidTankHeight = 52;
        if (((ChurnContainer)this.field_147002_h).getFluidTank().getFluidAmount() > 0) {
            FluidStack fluidStack = ((ChurnContainer)this.field_147002_h).getFluidTank().getFluid();
            int scaledFluidH = this.getScaledFluid(fluidStack.getAmount(), ((ChurnContainer)this.field_147002_h).getFluidTank().getCapacity(), guiFluidTankHeight);
            ClientUtils.drawRepeatedFluidSpriteGui((IRenderTypeBuffer)renderTypeBuffer, matrixStack, fluidStack, guiFluidTankX, guiFluidTankY + (guiFluidTankHeight - scaledFluidH), 16.0f, scaledFluidH);
        }
        renderTypeBuffer.func_228461_a_();
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.field_230712_o_.func_238421_b_(matrixStack, this.field_230704_d_.getString(), 8.0f, 6.0f, 0x404040);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        int guiFluidTankX = this.field_147003_i + 65;
        int guiFluidTankY = this.field_147009_r + 18;
        int guiFluidTankHeight = 52;
        if (mouseX > guiFluidTankX && mouseX < guiFluidTankX + 16 && mouseY > guiFluidTankY && mouseY < guiFluidTankY + guiFluidTankHeight) {
            FluidStack fluidStack = ((ChurnContainer)this.field_147002_h).getFluidTank().getFluid();
            String tooltip = fluidStack.getAmount() > 0 ? String.format("%s %dmb", fluidStack.getDisplayName().getString(), fluidStack.getAmount()) : "Empty";
            StringTextComponent stringTextComponent = new StringTextComponent(tooltip);
            this.func_238652_a_(matrixStack, (ITextComponent)stringTextComponent, mouseX, mouseY);
        }
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }
}

