/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import growthcraft.lib.util.ClientUtils;
import growthcraft.lib.util.TextureHelper;
import growthcraft.milk.client.container.PancheonContainer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class PancheonScreen
extends ContainerScreen<PancheonContainer> {
    private static final ResourceLocation TEXTURE = TextureHelper.getTextureGui("growthcraft_milk", "pancheon");

    public PancheonScreen(PancheonContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_147003_i = 0;
        this.field_147009_r = 0;
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    private static TextureAtlasSprite getStillFluidSprite(FluidStack fluidStack) {
        Minecraft minecraft = Minecraft.func_71410_x();
        Fluid fluid = fluidStack.getFluid();
        FluidAttributes attributes = fluid.getAttributes();
        ResourceLocation fluidStill = attributes.getStillTexture(fluidStack);
        return (TextureAtlasSprite)minecraft.func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidStill);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        matrixStack.func_227860_a_();
        IRenderTypeBuffer.Impl renderTypeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        boolean baseX = false;
        boolean baseY = false;
        int maxX = 256;
        int maxY = 256;
        PancheonScreen.func_238463_a_((MatrixStack)matrixStack, (int)this.field_147003_i, (int)this.field_147009_r, (float)((float)baseX), (float)((float)baseY), (int)this.field_146999_f, (int)this.field_147000_g, (int)maxX, (int)maxY);
        int guiProgressX = this.field_147003_i + 82;
        int guiProgressY = this.field_147009_r + 29;
        this.func_238474_b_(matrixStack, guiProgressX, guiProgressY, 176, 42, 13, ((PancheonContainer)this.field_147002_h).getProgressionScaled(29));
        int guiInputTankX = this.field_147003_i + 62;
        int guiInputTankY = this.field_147009_r + 18;
        int guiInputTankHeight = 52;
        if (((PancheonContainer)this.field_147002_h).getInputFluidTank(0).getFluidAmount() > 0) {
            FluidStack fluidStack = ((PancheonContainer)this.field_147002_h).getInputFluidTank(0).getFluid();
            int scaledFluidH = this.getScaledFluid(fluidStack.getAmount(), ((PancheonContainer)this.field_147002_h).getInputFluidTank(0).getCapacity(), guiInputTankHeight);
            ClientUtils.drawRepeatedFluidSpriteGui((IRenderTypeBuffer)renderTypeBuffer, matrixStack, fluidStack, guiInputTankX, guiInputTankY + (guiInputTankHeight - scaledFluidH), 16.0f, scaledFluidH);
        }
        int guiOutputTank0X = this.field_147003_i + 98;
        int guiOutputTank0Y = this.field_147009_r + 18;
        int guiOutputTank0Height = 23;
        if (((PancheonContainer)this.field_147002_h).getOutputFluidTank(1).getFluidAmount() > 0) {
            FluidStack fluidStack = ((PancheonContainer)this.field_147002_h).getOutputFluidTank(1).getFluid();
            int scaledFluidH = this.getScaledFluid(fluidStack.getAmount(), ((PancheonContainer)this.field_147002_h).getOutputFluidTank(1).getCapacity(), guiOutputTank0Height);
            ClientUtils.drawRepeatedFluidSpriteGui((IRenderTypeBuffer)renderTypeBuffer, matrixStack, fluidStack, guiOutputTank0X, guiOutputTank0Y + (guiOutputTank0Height - scaledFluidH), 16.0f, scaledFluidH);
        }
        int guiOutputTank1X = this.field_147003_i + 98;
        int guiOutputTank1Y = this.field_147009_r + 47;
        int guiOutputTank1Height = 23;
        if (((PancheonContainer)this.field_147002_h).getOutputFluidTank(2).getFluidAmount() > 0) {
            FluidStack fluidStack = ((PancheonContainer)this.field_147002_h).getOutputFluidTank(2).getFluid();
            int scaledFluidH = this.getScaledFluid(fluidStack.getAmount(), ((PancheonContainer)this.field_147002_h).getOutputFluidTank(2).getCapacity(), guiOutputTank1Height);
            ClientUtils.drawRepeatedFluidSpriteGui((IRenderTypeBuffer)renderTypeBuffer, matrixStack, fluidStack, guiOutputTank1X, guiOutputTank1Y + (guiOutputTank1Height - scaledFluidH), 16.0f, scaledFluidH);
        }
        renderTypeBuffer.func_228461_a_();
    }

    private int getScaledFluid(float amount, float capacity, int maxPixelSize) {
        float ratio = amount / capacity;
        float scaled = (float)maxPixelSize * ratio;
        return (int)scaled;
    }

    @ParametersAreNonnullByDefault
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.field_230712_o_.func_238421_b_(matrixStack, this.field_230704_d_.getString(), 8.0f, 6.0f, 0x404040);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        int guiInputTankX = this.field_147003_i + 62;
        int guiInputTankY = this.field_147009_r + 18;
        int guiInputTankHeight = 52;
        if (mouseX > guiInputTankX && mouseX < guiInputTankX + 16 && mouseY > guiInputTankY && mouseY < guiInputTankY + guiInputTankHeight) {
            FluidStack fluidStack = ((PancheonContainer)this.field_147002_h).getInputFluidTank(0).getFluid();
            String tooltip = fluidStack.getAmount() > 0 ? String.format("%s %dmb", fluidStack.getDisplayName().getString(), fluidStack.getAmount()) : "Empty";
            StringTextComponent stringTextComponent = new StringTextComponent(tooltip);
            this.func_238652_a_(matrixStack, (ITextComponent)stringTextComponent, mouseX, mouseY);
        }
        int guiOutputTank0X = this.field_147003_i + 98;
        int guiOutputTank0Y = this.field_147009_r + 18;
        int guiOutputTank0Height = 23;
        if (mouseX > guiOutputTank0X && mouseX < guiOutputTank0X + 16 && mouseY > guiOutputTank0Y && mouseY < guiOutputTank0Y + guiOutputTank0Height) {
            FluidStack fluidStack = ((PancheonContainer)this.field_147002_h).getOutputFluidTank(1).getFluid();
            String tooltip = fluidStack.getAmount() > 0 ? String.format("%s %dmb", fluidStack.getDisplayName().getString(), fluidStack.getAmount()) : "Empty";
            StringTextComponent stringTextComponent = new StringTextComponent(tooltip);
            this.func_238652_a_(matrixStack, (ITextComponent)stringTextComponent, mouseX, mouseY);
        }
        int guiOutputTank1X = this.field_147003_i + 98;
        int guiOutputTank1Y = this.field_147009_r + 47;
        int guiOutputTank1Height = 23;
        if (mouseX > guiOutputTank1X && mouseX < guiOutputTank1X + 16 && mouseY > guiOutputTank1Y && mouseY < guiOutputTank1Y + guiOutputTank1Height) {
            FluidStack fluidStack = ((PancheonContainer)this.field_147002_h).getOutputFluidTank(2).getFluid();
            String tooltip = fluidStack.getAmount() > 0 ? String.format("%s %dmb", fluidStack.getDisplayName().getString(), fluidStack.getAmount()) : "Empty";
            StringTextComponent stringTextComponent = new StringTextComponent(tooltip);
            this.func_238652_a_(matrixStack, (ITextComponent)stringTextComponent, mouseX, mouseY);
        }
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }
}

