/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.block;

import growthcraft.milk.common.tileentity.ChurnTileEntity;
import growthcraft.milk.init.GrowthcraftMilkTileEntities;
import growthcraft.milk.init.config.GrowthcraftMilkConfig;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;

public class ChurnBlock
extends HorizontalBlock {
    public static final VoxelShape LAYER0_BOUNDING_BOX = ChurnBlock.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0);
    public static final VoxelShape LAYER1_BOUNDING_BOX = ChurnBlock.func_208617_a((double)3.0, (double)5.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    public static final VoxelShape LAYER2_BOUNDING_BOX = ChurnBlock.func_208617_a((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final VoxelShape PLUNGER_DOWN_BOUNDING_BOX = ChurnBlock.func_208617_a((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)20.0, (double)9.0);
    public static final VoxelShape PLUNGER_UP_BOUNDING_BOX = ChurnBlock.func_208617_a((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)28.0, (double)9.0);
    public static final BooleanProperty PLUNGED = BooleanProperty.func_177716_a((String)"plunged");

    public ChurnBlock() {
        super(ChurnBlock.getInitProperties());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)PLUNGED, (Comparable)Boolean.valueOf(false)));
    }

    private static AbstractBlock.Properties getInitProperties() {
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196662_n);
        properties.func_200943_b(1.5f);
        properties.func_226896_b_();
        return properties;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)GrowthcraftMilkTileEntities.CHURN_TILE_ENTITY.get()).func_200968_a();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{field_185512_D, PLUNGED});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ChurnTileEntity tileEntity;
        if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (World)worldIn, (BlockPos)pos, (Direction)hit.func_216354_b()) || player.func_184586_b(handIn).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return ActionResultType.SUCCESS;
        }
        if (!worldIn.field_72995_K && (tileEntity = (ChurnTileEntity)worldIn.func_175625_s(pos)) != null) {
            if (player.func_225608_bj_() && GrowthcraftMilkConfig.isChurnGuiEnabled()) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileEntity, (BlockPos)pos);
            } else if (tileEntity.getInventory().getStackInSlot(0).func_190916_E() > 0) {
                ItemStack itemStack = tileEntity.func_70301_a(0);
                if (!player.field_71071_by.func_70441_a(itemStack)) {
                    player.func_71019_a(itemStack, false);
                }
            } else {
                tileEntity.togglePlunger();
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        ArrayList<VoxelShape> voxelShapeArrayList = new ArrayList<VoxelShape>();
        voxelShapeArrayList.add(LAYER0_BOUNDING_BOX);
        voxelShapeArrayList.add(LAYER1_BOUNDING_BOX);
        voxelShapeArrayList.add(LAYER2_BOUNDING_BOX);
        if (Boolean.TRUE.equals(state.func_177229_b((Property)PLUNGED))) {
            voxelShapeArrayList.add(PLUNGER_DOWN_BOUNDING_BOX);
        } else {
            voxelShapeArrayList.add(PLUNGER_UP_BOUNDING_BOX);
        }
        VoxelShape[] voxelShapes = new VoxelShape[voxelShapeArrayList.size()];
        voxelShapes = voxelShapeArrayList.toArray(voxelShapes);
        return VoxelShapes.func_216384_a((VoxelShape)LAYER0_BOUNDING_BOX, (VoxelShape[])voxelShapes);
    }
}

