/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.block;

import growthcraft.milk.GrowthcraftMilk;
import growthcraft.milk.common.tileentity.MixingVatTileEntity;
import growthcraft.milk.init.GrowthcraftMilkTileEntities;
import growthcraft.milk.init.config.GrowthcraftMilkConfig;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.network.NetworkHooks;

public class MixingVatBlock
extends HorizontalBlock {
    public static final VoxelShape BASE_BOUNDING_BOX = MixingVatBlock.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    public static final VoxelShape INSIDE_BOUNDING_BOX = MixingVatBlock.func_208617_a((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);

    public MixingVatBlock() {
        this(MixingVatBlock.getInitProperties());
    }

    public MixingVatBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH));
    }

    private static AbstractBlock.Properties getInitProperties() {
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150348_b);
        properties.func_200943_b(1.5f);
        properties.func_226896_b_();
        return properties;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)GrowthcraftMilkTileEntities.MIXING_VAT_TILE_ENTITY.get()).func_200968_a();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{field_185512_D});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        MixingVatTileEntity tileEntity = (MixingVatTileEntity)worldIn.func_175625_s(pos);
        if (tileEntity == null) {
            GrowthcraftMilk.LOGGER.error("MixingVatTileEntity is NULL at {}", (Object)pos);
            return ActionResultType.FAIL;
        }
        if (handIn.name().equals("MAIN_HAND") && player.func_184586_b(handIn).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            FluidTank inputTank = tileEntity.getInputFluidTank(0);
            FluidTank outputTank = tileEntity.getOutputFluidTank(0);
            if (player.func_184586_b(handIn).func_77973_b() == Items.field_151133_ar) {
                if (outputTank.getFluidAmount() > 0) {
                    FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (World)worldIn, (BlockPos)pos, (Direction)Direction.UP);
                    return ActionResultType.SUCCESS;
                }
                if (inputTank.getFluidAmount() <= 0) return ActionResultType.FAIL;
                FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (World)worldIn, (BlockPos)pos, (Direction)Direction.NORTH);
                return ActionResultType.SUCCESS;
            }
            if (inputTank.getFluidAmount() < 4000) {
                FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (World)worldIn, (BlockPos)pos, (Direction)Direction.NORTH);
                return ActionResultType.SUCCESS;
            }
            if (outputTank.getFluidAmount() >= 1000) return ActionResultType.FAIL;
            FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (World)worldIn, (BlockPos)pos, (Direction)Direction.UP);
            return ActionResultType.SUCCESS;
        }
        if (!handIn.name().equals("MAIN_HAND")) return ActionResultType.PASS;
        if (worldIn.field_72995_K) return ActionResultType.PASS;
        if (player.func_225608_bj_() && GrowthcraftMilkConfig.isMixingVatGuiEnabled()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileEntity, (BlockPos)pos);
            return ActionResultType.PASS;
        }
        if (tileEntity.activateResult(player, player.func_184586_b(handIn))) {
            player.func_184586_b(handIn).func_190918_g(1);
            return ActionResultType.SUCCESS;
        }
        if (!tileEntity.activateRecipe(player.func_184586_b(handIn))) return ActionResultType.PASS;
        if (!GrowthcraftMilkConfig.isConsumeMixingVatActivator()) return ActionResultType.SUCCESS;
        player.func_184586_b(handIn).func_190918_g(1);
        return ActionResultType.SUCCESS;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof MixingVatTileEntity && !world.field_72995_K) {
            ((MixingVatTileEntity)tileEntity).onEntityCollision(entity);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197878_a((VoxelShape)BASE_BOUNDING_BOX, (VoxelShape)INSIDE_BOUNDING_BOX, (IBooleanFunction)IBooleanFunction.field_223234_e_);
    }
}

