/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.recipe;

import com.google.gson.JsonObject;
import growthcraft.lib.util.CraftingUtils;
import growthcraft.milk.GrowthcraftMilk;
import growthcraft.milk.common.recipe.ChurnRecipe;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ChurnRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<ChurnRecipe> {
    public ChurnRecipe read(ResourceLocation recipeId, JsonObject json) {
        FluidStack inputFluid = CraftingUtils.getFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)"input_fluid"));
        FluidStack outputFluid = CraftingUtils.getFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)"output_fluid"));
        ItemStack byProduct = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"by_product"), (boolean)false);
        int plunges = JSONUtils.func_151208_a((JsonObject)json, (String)"plunges", (int)7);
        int byProductChance = JSONUtils.func_151208_a((JsonObject)json, (String)"by_product_chance", (int)100);
        return new ChurnRecipe(recipeId, inputFluid, outputFluid, byProduct, byProductChance, plunges);
    }

    @Nullable
    public ChurnRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            FluidStack a = buffer.readFluidStack();
            FluidStack b = buffer.readFluidStack();
            ItemStack c = buffer.func_150791_c();
            int d = buffer.func_150792_a();
            int e = buffer.func_150792_a();
            return new ChurnRecipe(recipeId, a, b, c, d, e);
        }
        catch (Exception ex) {
            GrowthcraftMilk.LOGGER.error("[Growthcraft-Milk] Unable to read recipe from buffer!");
            throw ex;
        }
    }

    public void write(PacketBuffer buffer, ChurnRecipe recipe) {
        try {
            buffer.writeFluidStack(recipe.getInputFluidStack());
            buffer.writeFluidStack(recipe.getOutputFluidStack());
            buffer.func_150788_a(recipe.func_77571_b());
            buffer.func_150787_b(recipe.getByProductChance());
            buffer.func_150787_b(recipe.getPlungesNeeded());
        }
        catch (Exception ex) {
            GrowthcraftMilk.LOGGER.error("[Growthcraft-Milk] Unable to write recipe to buffer!");
            throw ex;
        }
    }
}

