/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.compat.jei.category;

import com.mojang.blaze3d.matrix.MatrixStack;
import growthcraft.lib.util.TextureHelper;
import growthcraft.milk.GrowthcraftMilk;
import growthcraft.milk.common.recipe.MixingVatFluidRecipe;
import growthcraft.milk.common.recipe.MixingVatItemRecipe;
import growthcraft.milk.common.recipe.MixingVatRecipe;
import growthcraft.milk.init.GrowthcraftMilkBlocks;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.Level;

public class MixingVatRecipeCategory
implements IRecipeCategory<MixingVatRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("growthcraft_milk", "mixing_vat");
    private static final ResourceLocation TEXTURE = TextureHelper.getTextureGui("growthcraft_milk", "mixing_vat");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableStatic overlayHeated;
    private final String title;

    public MixingVatRecipeCategory(IGuiHelper guiHelper) {
        Block block = (Block)GrowthcraftMilkBlocks.MIXING_VAT.get();
        this.background = guiHelper.drawableBuilder(TEXTURE, 10, 10, 160, 70).build();
        this.overlayHeated = guiHelper.createDrawable(TEXTURE, 176, 28, 12, 13);
        this.title = I18n.func_135052_a((String)block.func_149739_a(), (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)block));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ID;
    }

    @Nonnull
    public Class<? extends MixingVatRecipe> getRecipeClass() {
        return MixingVatRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    @ParametersAreNonnullByDefault
    public void setIngredients(MixingVatRecipe recipe, IIngredients ingredients) {
        switch (recipe.getCategory()) {
            case FLUID: {
                MixingVatFluidRecipe fluidRecipe = (MixingVatFluidRecipe)recipe;
                ArrayList<FluidStack> fluidStackInputs = new ArrayList<FluidStack>();
                fluidStackInputs.add(fluidRecipe.getInputFluidStack());
                fluidStackInputs.add(fluidRecipe.getReagentFluidStack());
                ingredients.setInputs(VanillaTypes.FLUID, fluidStackInputs);
                ingredients.setInputs(VanillaTypes.ITEM, recipe.getIngredientList());
                ArrayList<FluidStack> fluidStackOutputs = new ArrayList<FluidStack>();
                fluidStackOutputs.add(0, fluidRecipe.getOutputFluidStack());
                fluidStackOutputs.add(1, fluidRecipe.getWasteFluidStack());
                ingredients.setOutputs(VanillaTypes.FLUID, fluidStackOutputs);
                break;
            }
            case ITEM: {
                MixingVatItemRecipe itemRecipe = (MixingVatItemRecipe)recipe;
                ingredients.setInputs(VanillaTypes.ITEM, itemRecipe.getIngredientList());
                ArrayList<FluidStack> fluidStackIngredients = new ArrayList<FluidStack>();
                fluidStackIngredients.add(recipe.getInputFluidStack());
                ingredients.setInputs(VanillaTypes.FLUID, fluidStackIngredients);
                ArrayList<ItemStack> itemStackOutputs = new ArrayList<ItemStack>();
                itemStackOutputs.add(recipe.func_77571_b());
                ingredients.setOutputs(VanillaTypes.ITEM, itemStackOutputs);
                break;
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void setRecipe(IRecipeLayout layout, MixingVatRecipe recipe, IIngredients ingredients) {
        IGuiFluidStackGroup guiFluidStackGroup = layout.getFluidStacks();
        IGuiItemStackGroup guiItemStackGroup = layout.getItemStacks();
        switch (recipe.getCategory()) {
            case FLUID: {
                guiFluidStackGroup.init(0, true, 39, 22, 16, 38, 4000, false, null);
                guiFluidStackGroup.set(0, (FluidStack)((List)ingredients.getInputs(VanillaTypes.FLUID).get(0)).get(0));
                guiFluidStackGroup.init(1, true, 39, 8, 16, 10, 1000, false, null);
                guiFluidStackGroup.set(1, (FluidStack)((List)ingredients.getInputs(VanillaTypes.FLUID).get(1)).get(0));
                guiItemStackGroup.init(0, true, 60, 7);
                guiItemStackGroup.init(1, true, 60, 24);
                guiItemStackGroup.init(2, true, 60, 40);
                for (int i = 0; i < ingredients.getInputs(VanillaTypes.ITEM).size(); ++i) {
                    guiItemStackGroup.set(i, (List)ingredients.getInputs(VanillaTypes.ITEM).get(i));
                }
                guiFluidStackGroup.init(2, false, 114, 30, 16, 30, 4000, false, null);
                guiFluidStackGroup.set(2, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
                guiFluidStackGroup.init(3, false, 114, 8, 16, 16, 1000, false, null);
                guiFluidStackGroup.set(3, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(1));
                break;
            }
            case ITEM: {
                guiFluidStackGroup.init(0, true, 39, 22, 16, 38, 4000, false, null);
                guiFluidStackGroup.set(0, (FluidStack)((List)ingredients.getInputs(VanillaTypes.FLUID).get(0)).get(0));
                guiItemStackGroup.init(0, true, 60, 7);
                guiItemStackGroup.init(1, true, 60, 25);
                guiItemStackGroup.init(2, true, 60, 43);
                for (int i = 0; i < ingredients.getInputs(VanillaTypes.ITEM).size(); ++i) {
                    guiItemStackGroup.set(i, (List)ingredients.getInputs(VanillaTypes.ITEM).get(i));
                }
                guiItemStackGroup.init(3, false, 113, 7);
                guiItemStackGroup.set(3, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
                break;
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void draw(MixingVatRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        try {
            this.overlayHeated.draw(matrixStack, 89, 47);
        }
        catch (Exception ex) {
            GrowthcraftMilk.LOGGER.log(Level.ERROR, "Failure to draw heat texture for Mixing Vat recipe.");
        }
    }
}

