/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.ias.gui;

import com.github.mrebhan.ingameaccountswitcher.tools.Config;
import com.github.mrebhan.ingameaccountswitcher.tools.Tools;
import com.github.mrebhan.ingameaccountswitcher.tools.alt.AccountData;
import com.github.mrebhan.ingameaccountswitcher.tools.alt.AltDatabase;
import com.github.mrebhan.ingameaccountswitcher.tools.alt.AltManager;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.resources.I18n;
import org.apache.commons.lang3.StringUtils;
import ru.vidtu.iasfork.IASConfigScreen;
import ru.vidtu.iasfork.msauth.Account;
import ru.vidtu.iasfork.msauth.MicrosoftAccount;
import the_fireplace.ias.account.AlreadyLoggedInException;
import the_fireplace.ias.account.ExtendedAccountData;
import the_fireplace.ias.config.ConfigValues;
import the_fireplace.ias.gui.GuiAddAccount;
import the_fireplace.ias.gui.GuiEditAccount;
import the_fireplace.ias.tools.HttpTools;
import the_fireplace.ias.tools.JavaTools;
import the_fireplace.ias.tools.SkinTools;
import the_fireplace.iasencrypt.EncryptionTools;

public class GuiAccountSelector
extends GuiScreen {
    public final GuiScreen prev;
    private int selectedAccountIndex = 0;
    private int prevIndex = 0;
    private Throwable loginfailed;
    private ArrayList<Account> queriedaccounts = this.convertData();
    private List accountsgui;
    private GuiButton login;
    private GuiButton loginoffline;
    private GuiButton delete;
    private GuiButton edit;
    private GuiButton reloadskins;
    private String prevQuery = "";
    private GuiTextField search;

    public GuiAccountSelector(GuiScreen prev) {
        this.prev = prev;
    }

    public void func_73866_w_() {
        this.queriedaccounts = this.convertData();
        this.accountsgui = new List(this.field_146297_k);
        this.field_195124_j.add(this.accountsgui);
        this.reloadskins = new GuiButton(8, 2, 2, 120, 20, I18n.func_135052_a((String)"ias.reloadskins", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiAccountSelector.this.reloadSkins();
            }
        };
        this.func_189646_b(this.reloadskins);
        this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 + 4 + 40, this.field_146295_m - 52, 120, 20, I18n.func_135052_a((String)"ias.addaccount", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiAccountSelector.this.add();
            }
        });
        this.login = new GuiButton(1, this.field_146294_l / 2 - 154 - 10, this.field_146295_m - 52, 120, 20, I18n.func_135052_a((String)"ias.login", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiAccountSelector.this.login(GuiAccountSelector.this.selectedAccountIndex);
            }
        };
        this.func_189646_b(this.login);
        this.edit = new GuiButton(7, this.field_146294_l / 2 - 40, this.field_146295_m - 52, 80, 20, I18n.func_135052_a((String)"ias.edit", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiAccountSelector.this.edit();
            }
        };
        this.func_189646_b(this.edit);
        this.loginoffline = new GuiButton(2, this.field_146294_l / 2 - 154 - 10, this.field_146295_m - 28, 110, 20, I18n.func_135052_a((String)"ias.login", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"ias.offline", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiAccountSelector.this.logino(GuiAccountSelector.this.selectedAccountIndex);
            }
        };
        this.func_189646_b(this.loginoffline);
        this.func_189646_b(new GuiButton(3, this.field_146294_l / 2 + 4 + 50, this.field_146295_m - 28, 110, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiAccountSelector.this.escape();
            }
        });
        this.delete = new GuiButton(4, this.field_146294_l / 2 - 50, this.field_146295_m - 28, 100, 20, I18n.func_135052_a((String)"ias.delete", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiAccountSelector.this.delete();
            }
        };
        this.func_189646_b(this.delete);
        this.search = new GuiTextField(-1, this.field_146289_q, this.field_146294_l / 2 - 80, 14, 160, 16){

            public void func_195608_a(int mouseX, int mouseY, float partialTicks) {
                super.func_195608_a(mouseX, mouseY, partialTicks);
                if (this.func_146179_b().isEmpty() && !this.func_146206_l()) {
                    GuiAccountSelector.this.field_146289_q.func_211126_b(I18n.func_135052_a((String)"ias.search", (Object[])new Object[0]), (float)(this.field_146209_f + 2), (float)(this.field_146210_g + 4), -1);
                }
            }
        };
        this.field_195124_j.add(this.search);
        this.func_189646_b(new GuiButton(999, this.field_146294_l - 52, 2, 50, 20, "Config"){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiAccountSelector.this.field_146297_k.func_147108_a((GuiScreen)new IASConfigScreen(GuiAccountSelector.this));
            }
        });
        this.updateButtons();
        this.updateShownSkin();
    }

    private void updateShownSkin() {
        if (!this.queriedaccounts.isEmpty()) {
            SkinTools.buildSkin(this.queriedaccounts.get(this.selectedAccountIndex).alias());
        }
    }

    public void func_73876_c() {
        this.updateButtons();
        if (this.prevIndex != this.selectedAccountIndex) {
            this.prevIndex = this.selectedAccountIndex;
            this.updateShownSkin();
        }
        if (!this.prevQuery.equals(this.search.func_146179_b())) {
            this.updateQueried();
            this.prevQuery = this.search.func_146179_b();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.accountsgui.mouseClicked(mouseX, mouseY, mouseButton);
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void func_146281_b() {
        Config.save();
        MicrosoftAccount.save(this.field_146297_k);
    }

    public void func_73863_a(int mx, int my, float delta) {
        this.func_146276_q_();
        this.accountsgui.func_148128_a(mx, my, delta);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"ias.selectaccount", (Object[])new Object[0]), this.field_146294_l / 2, 4, -1);
        if (this.loginfailed != null) {
            this.func_73732_a(this.field_146289_q, this.loginfailed.getLocalizedMessage(), this.field_146294_l / 2, this.field_146295_m - 62, 0xFF6464);
        }
        this.search.func_195608_a(mx, my, delta);
        super.func_73863_a(mx, my, delta);
        if (!this.queriedaccounts.isEmpty()) {
            SkinTools.javDrawSkin(8, this.field_146295_m / 2 - 64 - 16, 64, 128);
            Tools.drawBorderedRect(this.field_146294_l - 8 - 64, this.field_146295_m / 2 - 64 - 16, this.field_146294_l - 8, this.field_146295_m / 2 + 64 - 16, 2, -5855578, -13421773);
            if (this.queriedaccounts.get(this.selectedAccountIndex) instanceof ExtendedAccountData) {
                ExtendedAccountData ead = (ExtendedAccountData)this.queriedaccounts.get(this.selectedAccountIndex);
                if (ead.premium != null) {
                    if (ead.premium.booleanValue()) {
                        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"ias.premium", (Object[])new Object[0]), this.field_146294_l - 8 - 61, this.field_146295_m / 2 - 64 - 13, 0x64FF64);
                    } else {
                        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"ias.notpremium", (Object[])new Object[0]), this.field_146294_l - 8 - 61, this.field_146295_m / 2 - 64 - 13, 0xFF6464);
                    }
                }
                this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"ias.timesused", (Object[])new Object[0]), this.field_146294_l - 8 - 61, this.field_146295_m / 2 - 64 - 15 + 12, -1);
                this.func_73731_b(this.field_146289_q, String.valueOf(ead.useCount), this.field_146294_l - 8 - 61, this.field_146295_m / 2 - 64 - 15 + 21, -1);
                if (ead.useCount > 0) {
                    this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"ias.lastused", (Object[])new Object[0]), this.field_146294_l - 8 - 61, this.field_146295_m / 2 - 64 - 15 + 30, -1);
                    this.func_73731_b(this.field_146289_q, JavaTools.getFormattedDate(), this.field_146294_l - 8 - 61, this.field_146295_m / 2 - 64 - 15 + 39, -1);
                }
            } else {
                this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"ias.premium", (Object[])new Object[0]), this.field_146294_l - 8 - 61, this.field_146295_m / 2 - 64 - 13, 0x64FF64);
            }
        }
    }

    private void reloadSkins() {
        Config.save();
        SkinTools.cacheSkins(true);
        this.updateShownSkin();
    }

    private void escape() {
        this.field_146297_k.func_147108_a(this.prev);
    }

    private void delete() {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((b, i) -> {
            if (b) {
                AltDatabase.getInstance().getAlts().remove(this.getCurrentAsEditable());
                if (this.queriedaccounts.get(this.selectedAccountIndex) instanceof MicrosoftAccount) {
                    MicrosoftAccount.msaccounts.remove(this.queriedaccounts.get(this.selectedAccountIndex));
                }
                if (this.selectedAccountIndex > 0) {
                    --this.selectedAccountIndex;
                }
                this.updateQueried();
                this.updateButtons();
            }
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }, I18n.func_135052_a((String)"ias.delete.title", (Object[])new Object[0]), I18n.func_135052_a((String)"ias.delete.text", (Object[])new Object[]{this.queriedaccounts.get(this.selectedAccountIndex).alias()}), 0));
        AltDatabase.getInstance().getAlts().remove(this.getCurrentAsEditable());
        if (this.queriedaccounts.get(this.selectedAccountIndex) instanceof MicrosoftAccount) {
            MicrosoftAccount.msaccounts.remove(this.queriedaccounts.get(this.selectedAccountIndex));
        }
        if (this.selectedAccountIndex > 0) {
            --this.selectedAccountIndex;
        }
        this.updateQueried();
        this.updateButtons();
    }

    private void add() {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiAddAccount(this));
    }

    private void logino(int selected) {
        Account data = this.queriedaccounts.get(selected);
        AltManager.getInstance().setUserOffline(data.alias());
        this.loginfailed = null;
        ExtendedAccountData current = this.getCurrentAsEditable();
        if (current != null) {
            ++current.useCount;
            current.lastused = JavaTools.getDate();
        }
    }

    private void login(int selected) {
        Account data = this.queriedaccounts.get(selected);
        this.loginfailed = data.login();
        if (this.loginfailed == null) {
            ExtendedAccountData current = this.getCurrentAsEditable();
            if (current != null) {
                current.premium = true;
                ++current.useCount;
                current.lastused = JavaTools.getDate();
            }
        } else if (this.loginfailed instanceof AlreadyLoggedInException) {
            this.getCurrentAsEditable().lastused = JavaTools.getDate();
        } else if (HttpTools.ping("http://minecraft.net")) {
            this.getCurrentAsEditable().premium = false;
        }
    }

    private void edit() {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiEditAccount((GuiScreen)this, this.selectedAccountIndex));
    }

    private void updateQueried() {
        this.queriedaccounts = this.convertData();
        if (!this.search.func_146179_b().trim().isEmpty()) {
            for (int i = 0; i < this.queriedaccounts.size(); ++i) {
                if (!this.queriedaccounts.get(i).alias().contains(this.search.func_146179_b()) && ConfigValues.CASESENSITIVE) {
                    this.queriedaccounts.remove(i);
                    --i;
                    continue;
                }
                if (this.queriedaccounts.get(i).alias().toLowerCase().contains(this.search.func_146179_b().toLowerCase()) || ConfigValues.CASESENSITIVE) continue;
                this.queriedaccounts.remove(i);
                --i;
            }
        }
        if (!this.queriedaccounts.isEmpty()) {
            while (this.selectedAccountIndex >= this.queriedaccounts.size()) {
                --this.selectedAccountIndex;
            }
        }
    }

    public boolean keyPressed(int key, int oldkey, int mods) {
        if (key == 265 && !this.queriedaccounts.isEmpty()) {
            if (this.selectedAccountIndex > 0) {
                --this.selectedAccountIndex;
            }
        } else if (key == 264 && !this.queriedaccounts.isEmpty()) {
            if (this.selectedAccountIndex < this.queriedaccounts.size() - 1) {
                ++this.selectedAccountIndex;
            }
        } else {
            if (key == 256) {
                this.escape();
                return true;
            }
            if (key == 261 && this.delete.field_146124_l) {
                this.delete();
            } else if (key == 257 && !this.search.func_146206_l() && (this.login.field_146124_l || this.loginoffline.field_146124_l)) {
                if (GuiScreen.func_146272_n() && this.loginoffline.field_146124_l) {
                    this.logino(this.selectedAccountIndex);
                } else if (this.login.field_146124_l) {
                    this.login(this.selectedAccountIndex);
                }
            } else if (key == 294) {
                this.reloadSkins();
            } else if (this.search.func_146206_l() && key == 257) {
                this.search.func_146195_b(false);
                return true;
            }
        }
        return super.keyPressed(key, oldkey, mods);
    }

    public boolean charTyped(char charT, int mods) {
        if (charT == '+') {
            this.add();
        } else if (charT == '/' && this.edit.field_146124_l) {
            this.edit();
        } else if (!(this.search.func_146206_l() || charT != 'r' && charT != 'R')) {
            this.reloadSkins();
        }
        return super.charTyped(charT, mods);
    }

    private ArrayList<Account> convertData() {
        ArrayList tmp = (ArrayList)AltDatabase.getInstance().getAlts().clone();
        ArrayList<Account> converted = new ArrayList<Account>();
        int index = 0;
        for (AccountData data : tmp) {
            if (data instanceof ExtendedAccountData) {
                converted.add((ExtendedAccountData)data);
            } else {
                converted.add(new ExtendedAccountData(EncryptionTools.decode(data.user), EncryptionTools.decode(data.pass), data.alias));
                AltDatabase.getInstance().getAlts().set(index, new ExtendedAccountData(EncryptionTools.decode(data.user), EncryptionTools.decode(data.pass), data.alias));
            }
            ++index;
        }
        converted.addAll(MicrosoftAccount.msaccounts);
        return converted;
    }

    private ArrayList<AccountData> getAccountList() {
        return AltDatabase.getInstance().getAlts();
    }

    private ExtendedAccountData getCurrentAsEditable() {
        for (AccountData dat : this.getAccountList()) {
            if (!(dat instanceof ExtendedAccountData) || !((ExtendedAccountData)dat).equals(this.queriedaccounts.get(this.selectedAccountIndex))) continue;
            return (ExtendedAccountData)dat;
        }
        return null;
    }

    private void updateButtons() {
        this.login.field_146124_l = !this.queriedaccounts.isEmpty() && (this.queriedaccounts.get(this.selectedAccountIndex) instanceof MicrosoftAccount || !EncryptionTools.decode(((ExtendedAccountData)this.queriedaccounts.get((int)this.selectedAccountIndex)).pass).equals(""));
        this.loginoffline.field_146124_l = !this.queriedaccounts.isEmpty();
        this.delete.field_146124_l = !this.queriedaccounts.isEmpty();
        this.edit.field_146124_l = !this.queriedaccounts.isEmpty() && this.queriedaccounts.get(this.selectedAccountIndex) instanceof ExtendedAccountData;
        this.reloadskins.field_146124_l = !this.queriedaccounts.isEmpty();
    }

    class List
    extends GuiSlot {
        public List(Minecraft mcIn) {
            super(mcIn, GuiAccountSelector.this.field_146294_l, GuiAccountSelector.this.field_146295_m, 32, GuiAccountSelector.this.field_146295_m - 64, 14);
        }

        protected int func_148127_b() {
            return GuiAccountSelector.this.queriedaccounts.size();
        }

        protected boolean func_148131_a(int i) {
            return i == GuiAccountSelector.this.selectedAccountIndex;
        }

        protected void func_148123_a() {
            GuiAccountSelector.this.func_146276_q_();
        }

        protected void func_192637_a(int i1, int i2, int i3, int i4, int i5, int i6, float i7) {
            Account data = (Account)GuiAccountSelector.this.queriedaccounts.get(i1);
            String s = data.alias();
            if (StringUtils.isEmpty((CharSequence)s)) {
                s = I18n.func_135052_a((String)"ias.alt", (Object[])new Object[0]) + " " + (i1 + 1);
            }
            int color = 0xFFFFFF;
            if (Minecraft.func_71410_x().func_110432_I().func_111285_a().equals(data.alias())) {
                color = 65280;
            }
            GuiAccountSelector.this.func_73731_b(GuiAccountSelector.this.field_146289_q, s, i2 + 2, i3 + 1, color);
        }

        protected int func_148138_e() {
            return GuiAccountSelector.this.queriedaccounts.size() * 14;
        }

        public void func_195080_b(int i) {
            GuiAccountSelector.this.selectedAccountIndex = i;
            GuiAccountSelector.this.updateButtons();
        }
    }
}

