/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.infernalstudios.infernalexp.init.IEEffects;

@OnlyIn(value=Dist.CLIENT)
public class InfectionHeartOverlay
implements IGuiOverlay {
    private static final ResourceLocation INFECTION_HEART_TEXTURE = new ResourceLocation("infernalexp", "textures/gui/infection_gui.png");

    public void render(ForgeGui gui, PoseStack poseStack, float partialTick, int width, int height) {
        if (gui.getMinecraft().f_91074_.m_21023_((MobEffect)IEEffects.INFECTION.get()) && gui.shouldDrawSurvivalElements() && !gui.getMinecraft().f_91066_.f_92062_) {
            InfectionHeartOverlay.drawInfectionOverlay(gui.getMinecraft(), poseStack, gui.getMinecraft().m_91268_().m_85445_() / 2 - 91, gui.getMinecraft().m_91268_().m_85446_() - 39);
        }
    }

    public static void drawInfectionOverlay(Minecraft mc, PoseStack poseStack, int left, int top) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 0.01);
        LocalPlayer player = mc.f_91074_;
        float currentHealth = Mth.m_14167_((float)player.m_21223_());
        int ticks = mc.f_91065_.m_93079_();
        Random rand = new Random();
        rand.setSeed((long)ticks * 312871L);
        float absorb = Mth.m_14167_((float)player.m_6103_());
        boolean highlight = mc.f_91065_.f_92976_ > (long)ticks && (mc.f_91065_.f_92976_ - (long)ticks) / 3L % 2L == 1L;
        int healthRows = Mth.m_14167_((float)((player.m_21233_() + absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        int regen = -1;
        if (player.m_21023_(MobEffects.f_19605_)) {
            regen = ticks % 25;
        }
        int TOP = 9 * (mc.f_91073_.m_6106_().m_5466_() ? 1 : 0);
        int BACKGROUND = highlight ? 9 : 0;
        float absorbRemaining = absorb;
        RenderSystem.m_157456_((int)0, (ResourceLocation)INFECTION_HEART_TEXTURE);
        RenderSystem.m_69478_();
        for (int i = Mth.m_14167_((float)((player.m_21233_() + absorb) / 2.0f)) - 1; i >= 0; --i) {
            int row = Mth.m_14167_((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * rowHeight;
            if (currentHealth <= 4.0f) {
                y += rand.nextInt(2);
            }
            if (i == regen) {
                y -= 2;
            }
            mc.f_91065_.m_93228_(poseStack, x, y, BACKGROUND, TOP, 9, 9);
            if (highlight) {
                if (i * 2 + 1 < mc.f_91065_.f_92974_) {
                    mc.f_91065_.m_93228_(poseStack, x, y, 54, TOP, 9, 9);
                } else if (i * 2 + 1 == mc.f_91065_.f_92974_) {
                    mc.f_91065_.m_93228_(poseStack, x, y, 63, TOP, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f) {
                if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                    mc.f_91065_.m_93228_(poseStack, x, y, 63, TOP, 9, 9);
                    absorbRemaining -= 1.0f;
                    continue;
                }
                mc.f_91065_.m_93228_(poseStack, x, y, 54, TOP, 9, 9);
                absorbRemaining -= 2.0f;
                continue;
            }
            if ((float)(i * 2 + 1) < currentHealth) {
                mc.f_91065_.m_93228_(poseStack, x, y, 36, TOP, 9, 9);
                continue;
            }
            if ((float)(i * 2 + 1) != currentHealth) continue;
            mc.f_91065_.m_93228_(poseStack, x, y, 45, TOP, 9, 9);
        }
        RenderSystem.m_69461_();
        poseStack.m_85849_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
    }
}

