/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.init.IEEntityTypes;
import org.infernalstudios.infernalexp.init.IESoundEvents;

@MethodsReturnNonnullByDefault
public class ThrowableBrickEntity
extends ThrowableItemProjectile {
    public ThrowableBrickEntity(EntityType<? extends ThrowableItemProjectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public ThrowableBrickEntity(Level world, LivingEntity livingEntity) {
        super((EntityType)IEEntityTypes.THROWABLE_BRICK.get(), livingEntity, world);
    }

    public ThrowableBrickEntity(EntityType<? extends ThrowableItemProjectile> type, LivingEntity livingEntity, Level world) {
        super(type, livingEntity, world);
    }

    protected Item m_7881_() {
        return Items.f_42460_;
    }

    protected double getSpeedMultiplier() {
        return 0.79;
    }

    protected float getDamage() {
        return 2.0f;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @ParametersAreNonnullByDefault
    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (!this.m_20193_().m_5776_()) {
            BlockPos pos = result.m_82425_();
            Block block = this.m_20193_().m_8055_(pos).m_60734_();
            if (block == IEBlocks.QUARTZ_GLASS.get() || block == IEBlocks.QUARTZ_GLASS_PANE.get()) {
                this.m_20193_().m_5594_(null, pos, IESoundEvents.QUARTZ_GLASS_TYPE.m_56778_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if ((block instanceof GlassBlock || block instanceof IronBarsBlock) && block != Blocks.f_50183_ && block != IEBlocks.QUARTZ_GLASS.get() && block != IEBlocks.QUARTZ_GLASS_PANE.get()) {
                this.m_20193_().m_46961_(pos, false);
                this.m_20256_(this.m_20184_().m_82490_(this.getSpeedMultiplier()));
            } else {
                ItemEntity itemEntity = new ItemEntity(this.m_20193_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_7881_().m_7968_());
                this.m_20193_().m_7967_((Entity)itemEntity);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    @ParametersAreNonnullByDefault
    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        if (!this.m_20193_().m_5776_()) {
            Entity target = result.m_82443_();
            target.m_6469_(DamageSource.m_19361_((Entity)this, (Entity)this.m_37282_()), this.getDamage());
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

