/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.init;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import org.infernalstudios.infernalexp.util.NetherTeleportCommandUtil;

public class IECommands {
    private static void netherSpawnCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        String commandString = "setdimensionspawn";
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)commandString).requires(commandSource -> commandSource.m_6761_(2))).executes(command -> {
            ServerPlayer player = ((CommandSourceStack)command.getSource()).m_81375_();
            BlockPos pos = player.m_20183_();
            Level world = player.m_20193_();
            String dimension = world.m_46472_().m_135782_().toString();
            player.m_9158_(world.m_46472_(), pos, 0.0f, true, false);
            ((CommandSourceStack)command.getSource()).m_81354_((Component)Component.m_237110_((String)"infernalexp.commands.setdimensionspawn.success.single", (Object[])new Object[]{player.m_5446_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), Float.valueOf(0.0f), dimension}), true);
            return 1;
        })).then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(command -> {
            Collection players = EntityArgument.m_91477_((CommandContext)command, (String)"players");
            BlockPos pos = ((CommandSourceStack)command.getSource()).m_81375_().m_20183_();
            Level world = ((CommandSourceStack)command.getSource()).m_81375_().m_20193_();
            String dimension = world.m_46472_().m_135782_().toString();
            for (ServerPlayer player : players) {
                player.m_9158_(world.m_46472_(), pos, 0.0f, true, false);
            }
            if (players.size() == 1) {
                ((CommandSourceStack)command.getSource()).m_81354_((Component)Component.m_237110_((String)"infernalexp.commands.setdimensionspawn.success.single", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), Float.valueOf(0.0f), dimension}), true);
            } else {
                ((CommandSourceStack)command.getSource()).m_81354_((Component)Component.m_237110_((String)"infernalexp.commands.setdimensionspawn.success.multiple", (Object[])new Object[]{players.size(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), Float.valueOf(0.0f), dimension}), true);
            }
            return players.size();
        })));
    }

    private static void dimensionTeleportCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        String commandString = "ntp";
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)commandString).requires(commandSource -> commandSource.m_6761_(3))).executes(command -> {
            ServerPlayer player = ((CommandSourceStack)command.getSource()).m_81375_();
            MinecraftServer server = ((CommandSourceStack)command.getSource()).m_81377_();
            ServerLevel targetWorld = player.m_20193_().m_46472_() == Level.f_46429_ ? server.m_129880_(Level.f_46428_) : server.m_129880_(Level.f_46429_);
            WorldBorder worldborder = targetWorld.m_6857_();
            double minX = Math.max(-2.9999872E7, worldborder.m_61955_() + 16.0);
            double minZ = Math.max(-2.9999872E7, worldborder.m_61956_() + 16.0);
            double maxX = Math.min(2.9999872E7, worldborder.m_61957_() - 16.0);
            double maxZ = Math.min(2.9999872E7, worldborder.m_61958_() - 16.0);
            double coordinateDifference = DimensionType.m_63908_((DimensionType)player.f_19853_.m_6042_(), (DimensionType)targetWorld.m_6042_());
            BlockPos baseTeleportLocation = new BlockPos(Mth.m_14008_((double)(player.m_20185_() * coordinateDifference), (double)minX, (double)maxX), player.m_20186_(), Mth.m_14008_((double)(player.m_20189_() * coordinateDifference), (double)minZ, (double)maxZ));
            BlockPos safeTeleportLocation = NetherTeleportCommandUtil.getSafePosition(targetWorld, baseTeleportLocation);
            if (safeTeleportLocation == null) {
                return 0;
            }
            player.m_8999_(targetWorld, (double)safeTeleportLocation.m_123341_(), (double)safeTeleportLocation.m_123342_(), (double)safeTeleportLocation.m_123343_(), player.m_5675_(0.0f), player.m_5686_(0.0f));
            return 1;
        }));
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        IECommands.dimensionTeleportCommand(dispatcher);
        IECommands.netherSpawnCommand(dispatcher);
    }
}

