/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.biome.modifiers;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.infernalstudios.infernalexp.InfernalExpansion;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.data.SpawnrateManager;
import org.infernalstudios.infernalexp.events.MiscEvents;

public record AddConfigurableSpawnsBiomeModifier() implements BiomeModifier
{
    public static final Codec<AddConfigurableSpawnsBiomeModifier> CODEC = Codec.unit(AddConfigurableSpawnsBiomeModifier::new);

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        Optional biomeKey = biome.m_203543_();
        if (phase != BiomeModifier.Phase.ADD || biomeKey.isEmpty()) {
            return;
        }
        this.addSpawns(builder, ((ResourceKey)biomeKey.get()).m_135782_().toString());
    }

    public Codec<? extends BiomeModifier> codec() {
        return CODEC;
    }

    private void addSpawns(ModifiableBiomeInfo.BiomeInfo.Builder builder, String biomeLocation) {
        MiscEvents.getSpawnrateManager().forEach((entity, spawnInfo) -> {
            List<String> spawnableBiomes = Arrays.asList(InfernalExpansionConfig.MobSpawning.getByName(entity.split(":")[1]).getSpawnableBiomes().replace(" ", "").split(","));
            if (!spawnableBiomes.contains(biomeLocation)) {
                return;
            }
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entity));
            if (entityType == null) {
                throw new ResourceLocationException("Invalid EntityType resource location " + entity);
            }
            if (spawnInfo.containsKey(biomeLocation) && spawnableBiomes.contains(biomeLocation)) {
                this.addSpawn(builder, entityType, (SpawnrateManager.SpawnInfo)spawnInfo.get(biomeLocation));
            } else if (spawnInfo.containsKey("default") && spawnableBiomes.contains(biomeLocation)) {
                this.addSpawn(builder, entityType, (SpawnrateManager.SpawnInfo)spawnInfo.get("default"));
            } else {
                InfernalExpansion.LOGGER.error("{} doesn't have a default spawn entry", entity);
            }
        });
    }

    private void addSpawn(ModifiableBiomeInfo.BiomeInfo.Builder builder, EntityType<?> entityType, SpawnrateManager.SpawnInfo spawnInfo) {
        builder.getMobSpawnSettings().m_48376_(entityType.m_20674_(), new MobSpawnSettings.SpawnerData(entityType, spawnInfo.spawnRate(), spawnInfo.minCount(), spawnInfo.maxCount()));
        if (spawnInfo.charge() != 0.0 && spawnInfo.energyBudget() != 0.0) {
            builder.getMobSpawnSettings().m_48370_(entityType, spawnInfo.charge(), spawnInfo.energyBudget());
        } else if (spawnInfo.charge() != 0.0 || spawnInfo.energyBudget() != 0.0) {
            InfernalExpansion.LOGGER.error("EntityType {} has incomplete spawn cost data. When editing spawn costs, make sure to set both \"spawn_cost_per_entity\" and \"max_spawn_cost\"", (Object)entityType.toString());
        }
    }
}

