/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.util.ShapeUtil;
import org.infernalstudios.infernalexp.world.gen.features.IEFeature;

public class HangingGiantBrownMushroomFeature
extends IEFeature<NoneFeatureConfiguration> {
    private static final int minSize = 3;
    private static final int maxSize = 7;
    private static final ResourceLocation enhancedMushroomsBrownStem = new ResourceLocation("enhanced_mushrooms", "brown_mushroom_stem");

    public HangingGiantBrownMushroomFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean placeFeature(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        if (!context.m_159774_().m_46859_(context.m_159777_()) || context.m_159774_().m_8055_(context.m_159777_().m_7494_()) != ((Block)IEBlocks.DULLSTONE.get()).m_49966_()) {
            return false;
        }
        int size = 3 + context.m_225041_().m_188503_(4);
        BlockState enhancedMushroomsBrownStemBlockState = null;
        if (ModList.get().isLoaded("enhanced_mushrooms")) {
            enhancedMushroomsBrownStemBlockState = ((Block)ForgeRegistries.BLOCKS.getValue(enhancedMushroomsBrownStem)).m_49966_();
        }
        for (int y = 0; y <= size; ++y) {
            if (enhancedMushroomsBrownStemBlockState != null) {
                context.m_159774_().m_7731_(context.m_159777_().m_6625_(y), enhancedMushroomsBrownStemBlockState, 2);
                continue;
            }
            context.m_159774_().m_7731_(context.m_159777_().m_6625_(y), Blocks.f_50182_.m_49966_(), 2);
        }
        for (BlockPos point : ShapeUtil.generateSolidCircle((float)(size / 2) + 1.0f)) {
            context.m_159774_().m_7731_(context.m_159777_().m_7918_(point.m_123341_(), point.m_123342_() - size, point.m_123343_()), Blocks.f_50180_.m_49966_(), 2);
        }
        return true;
    }

    @Override
    boolean shouldPlaceOnStructures() {
        return false;
    }
}

