/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.a;
import org.apache.commons.logging.b;
import org.apache.commons.logging.c;
import org.apache.commons.logging.d;
import org.apache.commons.logging.e;
import org.apache.commons.logging.f;

public abstract class LogFactory {
    public static final String PRIORITY_KEY = "priority";
    public static final String TCCL_KEY = "use_tccl";
    public static final String FACTORY_PROPERTY = "org.apache.commons.logging.LogFactory";
    public static final String FACTORY_DEFAULT = "org.apache.commons.logging.impl.LogFactoryImpl";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    protected static final String SERVICE_ID = "META-INF/services/org.apache.commons.logging.LogFactory";
    public static final String DIAGNOSTICS_DEST_PROPERTY = "org.apache.commons.logging.diagnostics.dest";
    private static PrintStream b;
    private static final String c;
    public static final String HASHTABLE_IMPLEMENTATION_PROPERTY = "org.apache.commons.logging.LogFactory.HashtableImpl";
    private static final String d = "org.apache.commons.logging.impl.WeakHashtable";
    private static final ClassLoader e;
    protected static Hashtable factories;
    protected static volatile LogFactory nullClassLoaderFactory;
    static Class a;

    protected LogFactory() {
    }

    public abstract Object getAttribute(String var1);

    public abstract String[] getAttributeNames();

    public abstract Log getInstance(Class var1) throws LogConfigurationException;

    public abstract Log getInstance(String var1) throws LogConfigurationException;

    public abstract void release();

    public abstract void removeAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2);

    private static final Hashtable a() {
        Hashtable hashtable;
        block7: {
            String string;
            hashtable = null;
            try {
                string = LogFactory.a(HASHTABLE_IMPLEMENTATION_PROPERTY, null);
            }
            catch (SecurityException securityException) {
                string = null;
            }
            if (string == null) {
                string = d;
            }
            try {
                Class<?> clazz = Class.forName(string);
                hashtable = (Hashtable)clazz.newInstance();
            }
            catch (Throwable throwable) {
                LogFactory.handleThrowable(throwable);
                if (d.equals(string)) break block7;
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.d("[ERROR] LogFactory: Load of custom hashtable failed");
                }
                System.err.println("[ERROR] LogFactory: Load of custom hashtable failed");
            }
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        return hashtable;
    }

    private static String c(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    protected static void handleThrowable(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        if (throwable instanceof VirtualMachineError) {
            throw (VirtualMachineError)throwable;
        }
    }

    public static LogFactory getFactory() throws LogConfigurationException {
        String string;
        Object object;
        Enumeration<?> enumeration;
        ClassLoader classLoader;
        Properties properties;
        LogFactory logFactory;
        ClassLoader classLoader2;
        block38: {
            classLoader2 = LogFactory.b();
            if (classLoader2 == null && LogFactory.isDiagnosticsEnabled()) {
                LogFactory.d("Context classloader is null.");
            }
            if ((logFactory = LogFactory.a(classLoader2)) != null) {
                return logFactory;
            }
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.d("[LOOKUP] LogFactory implementation requested for the first time for context classloader " + LogFactory.objectId(classLoader2));
                LogFactory.a("[LOOKUP] ", classLoader2);
            }
            properties = LogFactory.c(classLoader2, FACTORY_PROPERTIES);
            classLoader = classLoader2;
            if (properties != null && (enumeration = properties.getProperty(TCCL_KEY)) != null && !Boolean.valueOf((String)((Object)enumeration)).booleanValue()) {
                classLoader = e;
            }
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.d("[LOOKUP] Looking for system property [org.apache.commons.logging.LogFactory] to define the LogFactory subclass to use...");
            }
            try {
                enumeration = LogFactory.a(FACTORY_PROPERTY, null);
                if (enumeration != null) {
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.d("[LOOKUP] Creating an instance of LogFactory class '" + (String)((Object)enumeration) + "' as specified by system property " + FACTORY_PROPERTY);
                    }
                    logFactory = LogFactory.newFactory((String)((Object)enumeration), classLoader, classLoader2);
                } else if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.d("[LOOKUP] No system property [org.apache.commons.logging.LogFactory] defined.");
                }
            }
            catch (SecurityException securityException) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.d("[LOOKUP] A security exception occurred while trying to create an instance of the custom factory class: [" + LogFactory.c(securityException.getMessage()) + "]. Trying alternative implementations...");
                }
            }
            catch (RuntimeException runtimeException) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.d("[LOOKUP] An exception occurred while trying to create an instance of the custom factory class: [" + LogFactory.c(runtimeException.getMessage()) + "] as specified by a system property.");
                }
                throw runtimeException;
            }
            if (logFactory == null) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.d("[LOOKUP] Looking for a resource file of name [META-INF/services/org.apache.commons.logging.LogFactory] to define the LogFactory subclass to use...");
                }
                try {
                    enumeration = LogFactory.a(classLoader2, SERVICE_ID);
                    if (enumeration != null) {
                        try {
                            object = new BufferedReader(new InputStreamReader((InputStream)((Object)enumeration), "UTF-8"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            object = new BufferedReader(new InputStreamReader((InputStream)((Object)enumeration)));
                        }
                        string = ((BufferedReader)object).readLine();
                        ((BufferedReader)object).close();
                        if (string != null && !"".equals(string)) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.d("[LOOKUP]  Creating an instance of LogFactory class " + string + " as specified by file '" + SERVICE_ID + "' which was present in the path of the context classloader.");
                            }
                            logFactory = LogFactory.newFactory(string, classLoader, classLoader2);
                        }
                        break block38;
                    }
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.d("[LOOKUP] No resource file with name 'META-INF/services/org.apache.commons.logging.LogFactory' found.");
                    }
                }
                catch (Exception exception) {
                    if (!LogFactory.isDiagnosticsEnabled()) break block38;
                    LogFactory.d("[LOOKUP] A security exception occurred while trying to create an instance of the custom factory class: [" + LogFactory.c(exception.getMessage()) + "]. Trying alternative implementations...");
                }
            }
        }
        if (logFactory == null) {
            if (properties != null) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.d("[LOOKUP] Looking in properties file for entry with key 'org.apache.commons.logging.LogFactory' to define the LogFactory subclass to use...");
                }
                if ((enumeration = properties.getProperty(FACTORY_PROPERTY)) != null) {
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.d("[LOOKUP] Properties file specifies LogFactory subclass '" + enumeration + "'");
                    }
                    logFactory = LogFactory.newFactory(enumeration, classLoader, classLoader2);
                } else if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.d("[LOOKUP] Properties file has no entry specifying LogFactory subclass.");
                }
            } else if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.d("[LOOKUP] No properties file available to determine LogFactory subclass from..");
            }
        }
        if (logFactory == null) {
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.d("[LOOKUP] Loading the default LogFactory implementation 'org.apache.commons.logging.impl.LogFactoryImpl' via the same classloader that loaded this LogFactory class (ie not looking in the context classloader).");
            }
            logFactory = LogFactory.newFactory(FACTORY_DEFAULT, e, classLoader2);
        }
        if (logFactory != null) {
            LogFactory.a(classLoader2, logFactory);
            if (properties != null) {
                enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    string = properties.getProperty((String)object);
                    logFactory.setAttribute((String)object, string);
                }
            }
        }
        return logFactory;
    }

    public static Log getLog(Class clazz) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String string) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(ClassLoader classLoader) {
        Hashtable hashtable;
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.d("Releasing factory for classloader " + LogFactory.objectId(classLoader));
        }
        Hashtable hashtable2 = hashtable = factories;
        synchronized (hashtable2) {
            if (classLoader == null) {
                if (nullClassLoaderFactory != null) {
                    nullClassLoaderFactory.release();
                    nullClassLoaderFactory = null;
                }
            } else {
                LogFactory logFactory = (LogFactory)hashtable.get(classLoader);
                if (logFactory != null) {
                    logFactory.release();
                    hashtable.remove(classLoader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAll() {
        Hashtable hashtable;
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.d("Releasing factory for all classloaders.");
        }
        Hashtable hashtable2 = hashtable = factories;
        synchronized (hashtable2) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                LogFactory logFactory = (LogFactory)enumeration.nextElement();
                logFactory.release();
            }
            hashtable.clear();
            if (nullClassLoaderFactory != null) {
                nullClassLoaderFactory.release();
                nullClassLoaderFactory = null;
            }
        }
    }

    protected static ClassLoader getClassLoader(Class clazz) {
        try {
            return clazz.getClassLoader();
        }
        catch (SecurityException securityException) {
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.d("Unable to get classloader for class '" + clazz + "' due to security restrictions - " + securityException.getMessage());
            }
            throw securityException;
        }
    }

    protected static ClassLoader getContextClassLoader() throws LogConfigurationException {
        return LogFactory.directGetContextClassLoader();
    }

    private static ClassLoader b() throws LogConfigurationException {
        return (ClassLoader)AccessController.doPrivileged(new a());
    }

    protected static ClassLoader directGetContextClassLoader() throws LogConfigurationException {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return classLoader;
    }

    private static LogFactory a(ClassLoader classLoader) {
        if (classLoader == null) {
            return nullClassLoaderFactory;
        }
        return (LogFactory)factories.get(classLoader);
    }

    private static void a(ClassLoader classLoader, LogFactory logFactory) {
        if (logFactory != null) {
            if (classLoader == null) {
                nullClassLoaderFactory = logFactory;
            } else {
                factories.put(classLoader, logFactory);
            }
        }
    }

    protected static LogFactory newFactory(String string, ClassLoader classLoader, ClassLoader classLoader2) throws LogConfigurationException {
        Object t2 = AccessController.doPrivileged(new b(string, classLoader));
        if (t2 instanceof LogConfigurationException) {
            LogConfigurationException logConfigurationException = (LogConfigurationException)t2;
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.d("An error occurred while loading the factory class:" + logConfigurationException.getMessage());
            }
            throw logConfigurationException;
        }
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.d("Created object " + LogFactory.objectId(t2) + " to manage classloader " + LogFactory.objectId(classLoader2));
        }
        return (LogFactory)t2;
    }

    protected static LogFactory newFactory(String string, ClassLoader classLoader) {
        return LogFactory.newFactory(string, classLoader, null);
    }

    protected static Object createFactory(String string, ClassLoader classLoader) {
        Class<?> clazz = null;
        try {
            block21: {
                if (classLoader != null) {
                    try {
                        clazz = classLoader.loadClass(string);
                        if ((a == null ? (a = LogFactory.a(FACTORY_PROPERTY)) : a).isAssignableFrom(clazz)) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.d("Loaded class " + clazz.getName() + " from classloader " + LogFactory.objectId(classLoader));
                            }
                        } else if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.d("Factory class " + clazz.getName() + " loaded from classloader " + LogFactory.objectId(clazz.getClassLoader()) + " does not extend '" + (a == null ? (a = LogFactory.a(FACTORY_PROPERTY)) : a).getName() + "' as loaded by this classloader.");
                            LogFactory.a("[BAD CL TREE] ", classLoader);
                        }
                        return (LogFactory)clazz.newInstance();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (classLoader == e) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.d("Unable to locate any class called '" + string + "' via classloader " + LogFactory.objectId(classLoader));
                            }
                            throw classNotFoundException;
                        }
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        if (classLoader == e) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.d("Class '" + string + "' cannot be loaded" + " via classloader " + LogFactory.objectId(classLoader) + " - it depends on some other class that cannot be found.");
                            }
                            throw noClassDefFoundError;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        if (classLoader != e) break block21;
                        boolean bl2 = LogFactory.a(clazz);
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("The application has specified that a custom LogFactory implementation ");
                        stringBuffer.append("should be used but Class '");
                        stringBuffer.append(string);
                        stringBuffer.append("' cannot be converted to '");
                        stringBuffer.append((a == null ? (a = LogFactory.a(FACTORY_PROPERTY)) : a).getName());
                        stringBuffer.append("'. ");
                        if (bl2) {
                            stringBuffer.append("The conflict is caused by the presence of multiple LogFactory classes ");
                            stringBuffer.append("in incompatible classloaders. ");
                            stringBuffer.append("Background can be found in http://commons.apache.org/logging/tech.html. ");
                            stringBuffer.append("If you have not explicitly specified a custom LogFactory then it is likely ");
                            stringBuffer.append("that the container has set one without your knowledge. ");
                            stringBuffer.append("In this case, consider using the commons-logging-adapters.jar file or ");
                            stringBuffer.append("specifying the standard LogFactory from the command line. ");
                        } else {
                            stringBuffer.append("Please check the custom implementation. ");
                        }
                        stringBuffer.append("Help can be found @http://commons.apache.org/logging/troubleshooting.html.");
                        if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.d(stringBuffer.toString());
                        }
                        throw new ClassCastException(stringBuffer.toString());
                    }
                }
            }
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.d("Unable to load factory class via classloader " + LogFactory.objectId(classLoader) + " - trying the classloader associated with this LogFactory.");
            }
            clazz = Class.forName(string);
            return (LogFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.d("Unable to create LogFactory instance.");
            }
            if (clazz != null && !(a == null ? (a = LogFactory.a(FACTORY_PROPERTY)) : a).isAssignableFrom(clazz)) {
                return new LogConfigurationException("The chosen LogFactory implementation does not extend LogFactory. Please check your configuration.", exception);
            }
            return new LogConfigurationException(exception);
        }
    }

    private static boolean a(Class clazz) {
        boolean bl2 = false;
        if (clazz != null) {
            try {
                ClassLoader classLoader = clazz.getClassLoader();
                if (classLoader == null) {
                    LogFactory.d("[CUSTOM LOG FACTORY] was loaded by the boot classloader");
                } else {
                    LogFactory.a("[CUSTOM LOG FACTORY] ", classLoader);
                    Class<?> clazz2 = Class.forName(FACTORY_PROPERTY, false, classLoader);
                    bl2 = clazz2.isAssignableFrom(clazz);
                    if (bl2) {
                        LogFactory.d("[CUSTOM LOG FACTORY] " + clazz.getName() + " implements LogFactory but was loaded by an incompatible classloader.");
                    } else {
                        LogFactory.d("[CUSTOM LOG FACTORY] " + clazz.getName() + " does not implement LogFactory.");
                    }
                }
            }
            catch (SecurityException securityException) {
                LogFactory.d("[CUSTOM LOG FACTORY] SecurityException thrown whilst trying to determine whether the compatibility was caused by a classloader conflict: " + securityException.getMessage());
            }
            catch (LinkageError linkageError) {
                LogFactory.d("[CUSTOM LOG FACTORY] LinkageError thrown whilst trying to determine whether the compatibility was caused by a classloader conflict: " + linkageError.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                LogFactory.d("[CUSTOM LOG FACTORY] LogFactory class cannot be loaded by classloader which loaded the custom LogFactory implementation. Is the custom factory in the right classloader?");
            }
        }
        return bl2;
    }

    private static InputStream a(ClassLoader classLoader, String string) {
        return (InputStream)AccessController.doPrivileged(new c(classLoader, string));
    }

    private static Enumeration b(ClassLoader classLoader, String string) {
        d d2 = new d(classLoader, string);
        Object t2 = AccessController.doPrivileged(d2);
        return (Enumeration)t2;
    }

    private static Properties a(URL uRL) {
        e e2 = new e(uRL);
        return (Properties)AccessController.doPrivileged(e2);
    }

    private static final Properties c(ClassLoader classLoader, String string) {
        URL uRL;
        Properties properties;
        block12: {
            properties = null;
            double d2 = 0.0;
            uRL = null;
            try {
                Enumeration enumeration = LogFactory.b(classLoader, string);
                if (enumeration == null) {
                    return null;
                }
                while (enumeration.hasMoreElements()) {
                    String string2;
                    URL uRL2 = (URL)enumeration.nextElement();
                    Properties properties2 = LogFactory.a(uRL2);
                    if (properties2 == null) continue;
                    if (properties == null) {
                        uRL = uRL2;
                        properties = properties2;
                        string2 = properties.getProperty(PRIORITY_KEY);
                        d2 = 0.0;
                        if (string2 != null) {
                            d2 = Double.parseDouble(string2);
                        }
                        if (!LogFactory.isDiagnosticsEnabled()) continue;
                        LogFactory.d("[LOOKUP] Properties file found at '" + uRL2 + "'" + " with priority " + d2);
                        continue;
                    }
                    string2 = properties2.getProperty(PRIORITY_KEY);
                    double d3 = 0.0;
                    if (string2 != null) {
                        d3 = Double.parseDouble(string2);
                    }
                    if (d3 > d2) {
                        if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.d("[LOOKUP] Properties file at '" + uRL2 + "'" + " with priority " + d3 + " overrides file at '" + uRL + "'" + " with priority " + d2);
                        }
                        uRL = uRL2;
                        properties = properties2;
                        d2 = d3;
                        continue;
                    }
                    if (!LogFactory.isDiagnosticsEnabled()) continue;
                    LogFactory.d("[LOOKUP] Properties file at '" + uRL2 + "'" + " with priority " + d3 + " does not override file at '" + uRL + "'" + " with priority " + d2);
                }
            }
            catch (SecurityException securityException) {
                if (!LogFactory.isDiagnosticsEnabled()) break block12;
                LogFactory.d("SecurityException thrown while trying to find/read config files.");
            }
        }
        if (LogFactory.isDiagnosticsEnabled()) {
            if (properties == null) {
                LogFactory.d("[LOOKUP] No properties file of name '" + string + "' found.");
            } else {
                LogFactory.d("[LOOKUP] Properties file of name '" + string + "' found at '" + uRL + '\"');
            }
        }
        return properties;
    }

    private static String a(String string, String string2) throws SecurityException {
        return (String)AccessController.doPrivileged(new f(string, string2));
    }

    private static PrintStream c() {
        String string;
        try {
            string = LogFactory.a(DIAGNOSTICS_DEST_PROPERTY, null);
            if (string == null) {
                return null;
            }
        }
        catch (SecurityException securityException) {
            return null;
        }
        if (string.equals("STDOUT")) {
            return System.out;
        }
        if (string.equals("STDERR")) {
            return System.err;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string, true);
            return new PrintStream(fileOutputStream);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected static boolean isDiagnosticsEnabled() {
        return b != null;
    }

    private static final void d(String string) {
        if (b != null) {
            b.print(c);
            b.println(string);
            b.flush();
        }
    }

    protected static final void logRawDiagnostic(String string) {
        if (b != null) {
            b.println(string);
            b.flush();
        }
    }

    private static void b(Class clazz) {
        ClassLoader classLoader;
        if (!LogFactory.isDiagnosticsEnabled()) {
            return;
        }
        try {
            LogFactory.d("[ENV] Extension directories (java.ext.dir): " + System.getProperty("java.ext.dir"));
            LogFactory.d("[ENV] Application classpath (java.class.path): " + System.getProperty("java.class.path"));
        }
        catch (SecurityException securityException) {
            LogFactory.d("[ENV] Security setting prevent interrogation of system classpaths.");
        }
        String string = clazz.getName();
        try {
            classLoader = LogFactory.getClassLoader(clazz);
        }
        catch (SecurityException securityException) {
            LogFactory.d("[ENV] Security forbids determining the classloader for " + string);
            return;
        }
        LogFactory.d("[ENV] Class " + string + " was loaded via classloader " + LogFactory.objectId(classLoader));
        LogFactory.a("[ENV] Ancestry of classloader which loaded " + string + " is ", classLoader);
    }

    private static void a(String string, ClassLoader classLoader) {
        ClassLoader classLoader2;
        CharSequence charSequence;
        if (!LogFactory.isDiagnosticsEnabled()) {
            return;
        }
        if (classLoader != null) {
            charSequence = classLoader.toString();
            LogFactory.d(string + LogFactory.objectId(classLoader) + " == '" + (String)charSequence + "'");
        }
        try {
            classLoader2 = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
            LogFactory.d(string + "Security forbids determining the system classloader.");
            return;
        }
        if (classLoader != null) {
            block9: {
                charSequence = new StringBuffer(string + "ClassLoader tree:");
                do {
                    ((StringBuffer)charSequence).append(LogFactory.objectId(classLoader));
                    if (classLoader == classLoader2) {
                        ((StringBuffer)charSequence).append(" (SYSTEM) ");
                    }
                    try {
                        classLoader = classLoader.getParent();
                    }
                    catch (SecurityException securityException) {
                        ((StringBuffer)charSequence).append(" --> SECRET");
                        break block9;
                    }
                    ((StringBuffer)charSequence).append(" --> ");
                } while (classLoader != null);
                ((StringBuffer)charSequence).append("BOOT");
            }
            LogFactory.d(((StringBuffer)charSequence).toString());
        }
    }

    public static String objectId(Object object) {
        if (object == null) {
            return "null";
        }
        return object.getClass().getName() + "@" + System.identityHashCode(object);
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static void b(String string) {
        LogFactory.d(string);
    }

    static {
        String string;
        b = null;
        factories = null;
        nullClassLoaderFactory = null;
        e = LogFactory.getClassLoader(a == null ? (a = LogFactory.a(FACTORY_PROPERTY)) : a);
        try {
            ClassLoader classLoader = e;
            string = e == null ? "BOOTLOADER" : LogFactory.objectId(classLoader);
        }
        catch (SecurityException securityException) {
            string = "UNKNOWN";
        }
        c = "[LogFactory from " + string + "] ";
        b = LogFactory.c();
        LogFactory.b(a == null ? (a = LogFactory.a(FACTORY_PROPERTY)) : a);
        factories = LogFactory.a();
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.d("BOOTSTRAP COMPLETED");
        }
    }
}

