/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.abilities;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.abilities.AbilityDamageResistance;
import lucraft.mods.lucraftcore.abilities.AbilityFallResistance;
import lucraft.mods.lucraftcore.abilities.AbilityFireResistance;
import lucraft.mods.lucraftcore.abilities.AbilityHealing;
import lucraft.mods.lucraftcore.abilities.AbilityJumpBoost;
import lucraft.mods.lucraftcore.abilities.AbilityPunch;
import lucraft.mods.lucraftcore.abilities.AbilitySprint;
import lucraft.mods.lucraftcore.abilities.AbilityStepAssist;
import lucraft.mods.lucraftcore.abilities.AbilityStrength;
import lucraft.mods.lucraftcore.suitset.SuitSet;
import lucraft.mods.lucraftcore.superpower.ISuperpowerCapability;
import lucraft.mods.lucraftcore.superpower.Superpower;
import lucraft.mods.lucraftcore.superpower.SuperpowerHandler;
import lucraft.mods.lucraftcore.superpower.SuperpowerPlayerHandler;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Ability
implements INBTSerializable<NBTTagCompound> {
    public static final RegistryNamespaced<ResourceLocation, Class<? extends Ability>> REGISTRY = new RegistryNamespaced();
    private static int id = 0;
    protected final EntityPlayer player;
    private boolean unlocked;
    private boolean enabled;
    private int cooldown;
    private int maxCooldown;
    private AbilityType type;
    protected int ticks;
    private Ability dependendAbility;
    private Superpower superpower;
    private int requiredLevel = -1;
    private boolean isHidden;

    public static void registerAbility(ResourceLocation loc, Class<? extends Ability> clz) {
        REGISTRY.func_177775_a(id++, (Object)loc, clz);
    }

    public static void init() {
        Ability.registerAbility(new ResourceLocation("lucraftcore", "healing"), AbilityHealing.class);
        Ability.registerAbility(new ResourceLocation("lucraftcore", "strength"), AbilityStrength.class);
        Ability.registerAbility(new ResourceLocation("lucraftcore", "punch"), AbilityPunch.class);
        Ability.registerAbility(new ResourceLocation("lucraftcore", "sprint"), AbilitySprint.class);
        Ability.registerAbility(new ResourceLocation("lucraftcore", "jumpBoost"), AbilityJumpBoost.class);
        Ability.registerAbility(new ResourceLocation("lucraftcore", "resistance"), AbilityDamageResistance.class);
        Ability.registerAbility(new ResourceLocation("lucraftcore", "fallResistance"), AbilityFallResistance.class);
        Ability.registerAbility(new ResourceLocation("lucraftcore", "fireResistance"), AbilityFireResistance.class);
        Ability.registerAbility(new ResourceLocation("lucraftcore", "stepAssist"), AbilityStepAssist.class);
    }

    public Ability(EntityPlayer player) {
        this.player = player;
        this.enabled = true;
        this.cooldown = 0;
        this.maxCooldown = 0;
        this.type = AbilityType.ACTION;
        this.ticks = 0;
        if (this.getAbilityType() == AbilityType.ACTION) {
            this.setCooldown(this.getMaxCooldown());
        } else {
            this.setCooldown(0);
        }
    }

    public String getUnlocalizedName() {
        return ((ResourceLocation)REGISTRY.func_177774_c(this.getClass())).func_110623_a();
    }

    public String getModId() {
        return ((ResourceLocation)REGISTRY.func_177774_c(this.getClass())).func_110624_b();
    }

    public String getTranslationName() {
        return this.getModId() + ".abilities." + this.getUnlocalizedName() + ".name";
    }

    public String getTranslationDescription() {
        return this.getModId() + ".abilities." + this.getUnlocalizedName() + ".desc";
    }

    @SideOnly(value=Side.CLIENT)
    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
    }

    public String getDisplayName() {
        return LucraftCoreUtil.translateToLocal(this.getTranslationName());
    }

    public String getDisplayDescription() {
        String level;
        String dependency;
        String superpower;
        String string = this.getDependentSuperpower() != null ? "\n" + (SuperpowerHandler.getSuperpower(this.player) == this.getDependentSuperpower() ? TextFormatting.GREEN : TextFormatting.RED) + LucraftCoreUtil.translateToLocal("lucraftcore.info.requiressuperpower").replace("%SUPERPOWER", this.getDependentSuperpower().getDisplayName()) : (superpower = "");
        String string2 = this.getDependentAbility() == null ? "" : (dependency = "\n" + (this.getDependentAbility().isUnlocked() ? TextFormatting.GREEN : TextFormatting.RED) + LucraftCoreUtil.translateToLocal("lucraftcore.info.requiresability").replace("%ABILITY", this.getDependentAbility().getDisplayName()));
        String string3 = SuperpowerHandler.hasSuperpower(this.player) && SuperpowerHandler.hasSuperpower(this.player, this.getDependentSuperpower()) ? (this.getRequiredLevel() > -1 ? "\n" + (SuperpowerHandler.getSuperpowerPlayerHandler(this.player).getLevel() >= this.getRequiredLevel() ? TextFormatting.GREEN : TextFormatting.RED) + LucraftCoreUtil.translateToLocal("lucraftcore.info.requireslevel").replace("%LEVEL", this.getRequiredLevel() + "") : "") : (level = "");
        if (this.isUnlocked()) {
            superpower = "";
            level = "";
            dependency = "";
        }
        return TextFormatting.UNDERLINE + "" + TextFormatting.BOLD + this.getDisplayName() + "\n" + TextFormatting.RESET + LucraftCoreUtil.translateToLocal(this.getTranslationDescription()) + superpower + dependency + level;
    }

    public boolean isUnlocked() {
        if (this.getDependentSuperpower() != null && SuperpowerHandler.getSuperpower(this.player) != this.getDependentSuperpower()) {
            return false;
        }
        boolean levelUnlocked = true;
        if (this.requiredLevel > 0 && SuperpowerHandler.getSuperpowerPlayerHandler(this.player) != null) {
            boolean bl = levelUnlocked = SuperpowerHandler.getSuperpowerPlayerHandler(this.player).getLevel() >= this.getRequiredLevel();
        }
        return (this.dependendAbility == null ? this.unlocked : this.dependendAbility.isUnlocked() && this.unlocked) && levelUnlocked;
    }

    public Ability setUnlocked(boolean unlocked) {
        this.unlocked = !unlocked || this.dependendAbility == null ? unlocked : (this.dependendAbility != null ? this.dependendAbility.isUnlocked() && unlocked : unlocked);
        LucraftCoreUtil.sendSuperpowerUpdatePacket(this.player);
        return this;
    }

    public Ability getDependentAbility() {
        return this.dependendAbility;
    }

    public Ability setDependentAbility(Ability ability) {
        this.dependendAbility = ability;
        LucraftCoreUtil.sendSuperpowerUpdatePacket(this.player);
        return this;
    }

    public void setDependentSuperpower(Superpower superpower) {
        this.superpower = superpower;
    }

    public Superpower getDependentSuperpower() {
        return this.superpower;
    }

    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    public Ability setRequiredLevel(int requiredLevel) {
        this.requiredLevel = requiredLevel;
        return this;
    }

    public boolean isEnabled() {
        if (this.type == AbilityType.ACTION) {
            return false;
        }
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        LucraftCoreUtil.sendSuperpowerUpdatePacket(this.player);
    }

    public boolean hasCooldown() {
        return false;
    }

    public int getCooldown() {
        return MathHelper.func_76125_a((int)this.cooldown, (int)0, (int)this.getMaxCooldown());
    }

    public void setCooldown(int cooldown) {
        this.cooldown = MathHelper.func_76125_a((int)cooldown, (int)0, (int)this.getMaxCooldown());
        LucraftCoreUtil.sendSuperpowerUpdatePacket(this.player);
    }

    public int getMaxCooldown() {
        return this.maxCooldown;
    }

    public void setMaxCooldown(int maxCooldown) {
        this.maxCooldown = maxCooldown;
        if (this.getAbilityType() == AbilityType.ACTION) {
            this.setCooldown(this.getMaxCooldown());
        } else {
            this.setCooldown(0);
        }
    }

    public boolean isCoolingdown() {
        return this.hasCooldown() && this.getCooldown() > 0 && (this.getAbilityType() != AbilityType.ACTION || !this.isEnabled());
    }

    public AbilityType getAbilityType() {
        return this.type;
    }

    public void setAbilityType(AbilityType type) {
        this.type = type;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public void onUpdate() {
        if (this.unlocked) {
            if (this.getAbilityType() == AbilityType.CONSTANT) {
                ++this.ticks;
                this.updateTick();
            } else if (this.isEnabled()) {
                if (this.ticks == 0) {
                    this.firstTick();
                }
                ++this.ticks;
                this.updateTick();
                if (this.hasCooldown() && this.getAbilityType() != AbilityType.ACTION) {
                    if (this.getCooldown() >= this.getMaxCooldown()) {
                        this.setEnabled(false);
                    } else {
                        this.setCooldown(this.getCooldown() + 1);
                    }
                }
            } else {
                if (this.ticks != 0) {
                    this.lastTick();
                    this.ticks = 0;
                }
                if (this.hasCooldown()) {
                    if (this.getCooldown() > 0) {
                        this.setCooldown(this.getCooldown() - 1);
                    } else if (this.getAbilityType() == AbilityType.ACTION) {
                        this.setEnabled(true);
                    }
                }
            }
        }
    }

    public void firstTick() {
    }

    public void updateTick() {
    }

    public void lastTick() {
    }

    public void action() {
    }

    public boolean checkConditions() {
        return true;
    }

    public boolean showInAbilityBar() {
        return true;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Ability", ((ResourceLocation)REGISTRY.func_177774_c(this.getClass())).toString());
        nbt.func_74757_a("Unlocked", this.unlocked);
        nbt.func_74757_a("Enabled", this.enabled);
        nbt.func_74768_a("Cooldown", this.cooldown);
        nbt.func_74768_a("MaxCooldown", this.maxCooldown);
        nbt.func_74768_a("Ticks", this.ticks);
        nbt.func_74757_a("Hidden", this.isHidden);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.unlocked = nbt.func_74767_n("Unlocked");
        this.enabled = nbt.func_74767_n("Enabled");
        this.cooldown = nbt.func_74762_e("Cooldown");
        this.maxCooldown = nbt.func_74762_e("MaxCooldown");
        this.ticks = nbt.func_74762_e("Ticks");
        this.isHidden = nbt.func_74767_n("Hidden");
    }

    public void onAttacked(LivingAttackEvent e) {
    }

    public void onPlayerHurt(LivingHurtEvent e) {
    }

    public void onHurt(LivingHurtEvent e) {
    }

    public void onAttackEntity(AttackEntityEvent e) {
    }

    public void onBreakSpeed(PlayerEvent.BreakSpeed e) {
    }

    public static <T extends Ability> T getAbilityFromClass(List<Ability> list, Class<T> abilityClass) {
        for (Ability ab : list) {
            if (ab.getClass() != abilityClass) continue;
            return (T)ab;
        }
        return null;
    }

    public static List<Ability> getCurrentPlayerAbilities(EntityPlayer player) {
        ArrayList<Ability> list = new ArrayList<Ability>();
        SuitSet suitSet = SuitSet.getSuitSet((EntityLivingBase)player);
        SuperpowerPlayerHandler handler = SuperpowerHandler.getSuperpowerPlayerHandler(player);
        if (suitSet != null && player.getCapability(LucraftCore.SUPERPOWER_CAP, null) != null && ((ISuperpowerCapability)player.getCapability(LucraftCore.SUPERPOWER_CAP, null)).getSuitAbilities() != null) {
            list.addAll(((ISuperpowerCapability)player.getCapability(LucraftCore.SUPERPOWER_CAP, null)).getSuitAbilities());
        }
        if (handler != null) {
            list.addAll(handler.getAbilities());
        }
        return list;
    }

    public static boolean hasPlayerAbility(EntityPlayer player, Class<? extends Ability> ability) {
        return Ability.getAbilityFromClass(Ability.getCurrentPlayerAbilities(player), ability) != null;
    }

    public static class AbilityComparator
    implements Comparator<Ability> {
        @Override
        public int compare(Ability a1, Ability a2) {
            int id2;
            int id1 = REGISTRY.func_148757_b(a1.getClass());
            if (id1 > (id2 = REGISTRY.func_148757_b(a2.getClass()))) {
                return 1;
            }
            if (id1 < id2) {
                return -1;
            }
            return 0;
        }
    }

    public static enum AbilityType {
        ACTION,
        HELD,
        TOGGLE,
        CONSTANT;

    }
}

