/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.abilities;

import lucraft.mods.lucraftcore.abilities.AbilityConstant;
import lucraft.mods.lucraftcore.util.LCRenderHelper;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AbilityHealing
extends AbilityConstant {
    private int frequency;
    private float amount;
    private boolean fixed = false;

    public AbilityHealing(EntityPlayer player) {
        this(player, 20, 0.0f);
    }

    public AbilityHealing(EntityPlayer player, int frequency, float amount) {
        super(player);
        this.frequency = frequency;
        this.amount = amount;
    }

    public AbilityHealing(EntityPlayer player, int frequency, float amount, boolean fixed) {
        super(player);
        this.frequency = frequency;
        this.amount = amount;
        this.fixed = true;
    }

    @Override
    public String getDisplayDescription() {
        return super.getDisplayDescription() + "\n \n" + TextFormatting.BLUE + LucraftCoreUtil.translateToLocal("lucraftcore.info.interval") + ": " + (float)this.getFrequency() / 20.0f + "\n" + TextFormatting.BLUE + LucraftCoreUtil.translateToLocal("lucraftcore.info.amount") + ": " + this.getAmount() + " " + LucraftCoreUtil.translateToLocal("lucraftcore.info.hearts");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
        LCRenderHelper.drawIcon(mc, gui, x, y, 0, 0);
    }

    @Override
    public boolean showInAbilityBar() {
        return false;
    }

    @Override
    public void updateTick() {
        if (this.frequency != 0 && this.ticks % this.frequency == 0) {
            this.player.func_70691_i(0.5f);
        }
    }

    public int getFrequency() {
        return this.frequency;
    }

    public float getAmount() {
        return this.amount;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        if (!this.fixed) {
            this.frequency = nbt.func_74762_e("Frequency");
            this.amount = nbt.func_74760_g("Amount");
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74768_a("Frequency", this.frequency);
        nbt.func_74776_a("Amount", this.amount);
        return nbt;
    }
}

