/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.access;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lucraft.mods.lucraftcore.LucraftCore;
import org.apache.commons.lang3.tuple.Triple;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.commons.LocalVariablesSorter;
import org.objectweb.asm.util.Printer;
import scala.Tuple4;

public final class ASM {
    public static final Element methodBegin = new MethodBeginElement();
    private static boolean obfuscated = true;
    private static boolean loadedAtAll = false;
    private static final Map<String, ClassPatcher> patchers = new HashMap<String, ClassPatcher>();
    private static String currentTransformer = null;

    private ASM() {
    }

    public static String resolve(String mcpName, String srgName) {
        return obfuscated ? srgName : mcpName;
    }

    public static void check() {
        if (!loadedAtAll) {
            throw new IllegalStateException("Coremod failed!");
        }
    }

    public static void init(Object holder, boolean obf) {
        obfuscated = obf;
        loadedAtAll = true;
        for (Method m : holder.getClass().getMethods()) {
            if (!m.isAnnotationPresent(Transformer.class)) continue;
            try {
                currentTransformer = m.getName();
                m.invoke(holder, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't load transformer '" + m.getName() + "'!", e);
            }
        }
        currentTransformer = null;
    }

    public static byte[] doTransform(String className, byte[] original) {
        ClassPatcher patcher = patchers.get(className);
        if (patcher != null) {
            ClassReader reader = new ClassReader(original);
            ClassWriter writer = new ClassWriter(reader, 2){

                protected String getCommonSuperClass(String type1, String type2) {
                    Class<?> d;
                    Class<?> c;
                    ClassLoader classLoader = LucraftCore.class.getClassLoader();
                    try {
                        c = Class.forName(type1.replace('/', '.'), false, classLoader);
                        d = Class.forName(type2.replace('/', '.'), false, classLoader);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException(e.toString());
                    }
                    if (c.isAssignableFrom(d)) {
                        return type1;
                    }
                    if (d.isAssignableFrom(c)) {
                        return type2;
                    }
                    if (c.isInterface() || d.isInterface()) {
                        return "java/lang/Object";
                    }
                    while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
                    }
                    return c.getName().replace('.', '/');
                }
            };
            ClassPatchVisitor visitor = new ClassPatchVisitor((ClassVisitor)writer, patcher);
            try {
                reader.accept((ClassVisitor)visitor, 4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String cls = className.substring(className.lastIndexOf(46) + 1);
            String stuff = visitor.unusedPatches.stream().filter(patch -> !((MethodPatcher)patch).optional).map(p -> cls + "." + p.getMethodNames()).collect(Collectors.joining("\n    ", "\n    ", ""));
            if (!stuff.equals("\n    ")) {
                throw new IllegalStateException("Coremod failed!");
            }
            stuff = visitor.modifiers.asMap().entrySet().stream().flatMap(entry -> ((Collection)entry.getValue()).stream().filter(mod -> ((Modifier)mod).code == null || !((Modifier)mod).code.succededOnce()).map(mod -> mod + " from " + cls + "." + (String)entry.getKey())).collect(Collectors.joining("\n    ", "\n    ", ""));
            if (!stuff.equals("\n    ")) {
                throw new IllegalStateException("Coremod failed!");
            }
            try {
                return writer.toByteArray();
            }
            catch (Exception e) {
                return original;
            }
        }
        return original;
    }

    public static ClassPatcher inClass(String cls) {
        if (currentTransformer == null) {
            throw new IllegalStateException("Can't use 'inClass' outside transformer method!");
        }
        ClassPatcher patcher = patchers.get(cls);
        if (patcher == null) {
            patcher = new ClassPatcher();
            patchers.put(cls, patcher);
        }
        return patcher;
    }

    public static Element insn(int opcode) {
        return new InsnElement(opcode);
    }

    public static Element ldcInsn(Object cst) {
        return new LdcInsnElement(cst);
    }

    public static Element varInsn(int opcode, int var) {
        return new VarInsnElement(opcode, var);
    }

    public static Element jumpInsn(int opcode) {
        return new JumpInsnElement(opcode);
    }

    public static Element fieldInsn(int opcode, String owner, String mcpName, String srgName, String desc) {
        return new FieldInsnElement(opcode, owner, ASM.resolve(mcpName, srgName), desc);
    }

    public static Element methodInsn(int opcode, String owner, String mcpName, String srgName, String desc) {
        return new MethodInsnElement(opcode, owner, ASM.resolve(mcpName, srgName), desc);
    }

    public static PatchWithLocals patch() {
        return new PatchWithLocals();
    }

    public static class MethodInsnElement
    extends Element {
        private final int opcode;
        private final String owner;
        private final String name;
        private final String desc;

        private MethodInsnElement(int opcode, String owner, String name, String desc) {
            this.opcode = opcode;
            this.owner = owner;
            this.name = name;
            this.desc = desc;
        }

        @Override
        SpecialMethodVisitor apply(final SpecialMethodVisitor parent, final CheckedHook hook, final int type, final int at) {
            return new SpecialMethodVisitor(parent){
                private int n;
                {
                    super(mv);
                    this.n = 0;
                }

                public void visitMethodInsn(int op, String _owner, String _name, String _desc, boolean isInterface) {
                    if (type == 2) {
                        this.mv.visitMethodInsn(op, _owner, _name, _desc, isInterface);
                    }
                    if (op == opcode && _owner.equals(owner) && _name.equals(name) && _desc.equals(desc) && (at == ++this.n || at == -1)) {
                        parent.pass = this.n;
                        hook.accept(parent);
                    } else if (type == 0) {
                        this.mv.visitMethodInsn(op, _owner, _name, _desc, isInterface);
                    }
                    if (type == 1) {
                        this.mv.visitMethodInsn(op, _owner, _name, _desc, isInterface);
                    }
                }
            };
        }

        public String toString() {
            return Printer.OPCODES[this.opcode] + " " + this.owner + "." + this.name + this.desc;
        }
    }

    public static class FieldInsnElement
    extends Element {
        private final int opcode;
        private final String owner;
        private final String name;
        private final String desc;

        private FieldInsnElement(int opcode, String owner, String name, String desc) {
            this.opcode = opcode;
            this.owner = owner;
            this.name = name;
            this.desc = desc;
        }

        @Override
        SpecialMethodVisitor apply(final SpecialMethodVisitor parent, final CheckedHook hook, final int type, final int at) {
            return new SpecialMethodVisitor(parent){
                private int n;
                {
                    super(mv);
                    this.n = 0;
                }

                public void visitFieldInsn(int op, String _owner, String _name, String _desc) {
                    if (type == 2) {
                        this.mv.visitFieldInsn(op, _owner, _name, _desc);
                    }
                    if (op == opcode && _owner.equals(owner) && _name.equals(name) && _desc.equals(desc) && (at == ++this.n || at == -1)) {
                        parent.pass = this.n;
                        hook.accept(parent);
                    } else if (type == 0) {
                        this.mv.visitFieldInsn(op, _owner, _name, _desc);
                    }
                    if (type == 1) {
                        this.mv.visitFieldInsn(op, _owner, _name, _desc);
                    }
                }
            };
        }

        public String toString() {
            return Printer.OPCODES[this.opcode] + " " + this.owner + "." + this.name + " " + this.desc;
        }
    }

    public static class JumpInsnElement
    extends Element {
        private final int opcode;

        private JumpInsnElement(int opcode) {
            this.opcode = opcode;
        }

        @Override
        SpecialMethodVisitor apply(final SpecialMethodVisitor parent, final CheckedHook hook, final int type, final int at) {
            return new SpecialMethodVisitor(parent){
                private int n;
                {
                    super(mv);
                    this.n = 0;
                }

                public void visitJumpInsn(int opcode, Label label) {
                    if (type == 2) {
                        this.mv.visitJumpInsn(opcode, label);
                    }
                    if (opcode == opcode && (at == ++this.n || at == -1)) {
                        parent.pass = this.n;
                        hook.accept(parent);
                    } else if (type == 0) {
                        this.mv.visitJumpInsn(opcode, label);
                    }
                    if (type == 1) {
                        this.mv.visitJumpInsn(opcode, label);
                    }
                }
            };
        }

        public String toString() {
            return Printer.OPCODES[this.opcode];
        }
    }

    public static class VarInsnElement
    extends Element {
        private final int opcode;
        private final int var;

        private VarInsnElement(int opcode, int var) {
            this.opcode = opcode;
            this.var = var;
        }

        @Override
        SpecialMethodVisitor apply(final SpecialMethodVisitor parent, final CheckedHook hook, final int type, final int at) {
            return new SpecialMethodVisitor(parent){
                private int n;
                {
                    super(mv);
                    this.n = 0;
                }

                @Override
                public void visitVarInsn(int opcode, int var) {
                    if (type == 2) {
                        this.mv.visitVarInsn(opcode, var);
                    }
                    if (opcode == opcode && var == var && (at == ++this.n || at == -1)) {
                        parent.pass = this.n;
                        hook.accept(parent);
                    } else if (type == 0) {
                        this.mv.visitVarInsn(opcode, var);
                    }
                    if (type == 1) {
                        this.mv.visitVarInsn(opcode, var);
                    }
                }
            };
        }

        public String toString() {
            return Printer.OPCODES[this.opcode] + " " + this.var;
        }
    }

    public static class LdcInsnElement
    extends Element {
        private final Object cst;

        private LdcInsnElement(Object cst) {
            this.cst = cst;
        }

        @Override
        SpecialMethodVisitor apply(final SpecialMethodVisitor parent, final CheckedHook hook, final int type, final int at) {
            return new SpecialMethodVisitor(parent){
                private int n;
                {
                    super(mv);
                    this.n = 0;
                }

                public void visitLdcInsn(Object cst) {
                    if (type == 2) {
                        this.mv.visitLdcInsn(cst);
                    }
                    if (cst.equals(cst) && (at == ++this.n || at == -1)) {
                        parent.pass = this.n;
                        hook.accept(parent);
                    } else if (type == 0) {
                        this.mv.visitLdcInsn(cst);
                    }
                    if (type == 1) {
                        this.mv.visitLdcInsn(cst);
                    }
                }
            };
        }

        public String toString() {
            return "LDC " + this.cst;
        }
    }

    public static class InsnElement
    extends Element {
        private final int opcode;

        private InsnElement(int opcode) {
            this.opcode = opcode;
        }

        @Override
        SpecialMethodVisitor apply(final SpecialMethodVisitor parent, final CheckedHook code, final int type, final int at) {
            return new SpecialMethodVisitor(parent){
                private int n;
                {
                    super(mv);
                    this.n = 0;
                }

                public void visitInsn(int opcode) {
                    if (type == 2) {
                        this.mv.visitInsn(opcode);
                    }
                    if (opcode == opcode && (at == ++this.n || at == -1)) {
                        parent.pass = this.n;
                        code.accept(parent);
                    } else if (type == 0) {
                        this.mv.visitInsn(opcode);
                    }
                    if (type == 1) {
                        this.mv.visitInsn(opcode);
                    }
                }
            };
        }

        public String toString() {
            return Printer.OPCODES[this.opcode];
        }
    }

    public static class MethodBeginElement
    extends Element {
        private MethodBeginElement() {
        }

        @Override
        SpecialMethodVisitor apply(final SpecialMethodVisitor parent, final CheckedHook hook, final int type, int at) {
            return new SpecialMethodVisitor(parent){

                public void visitCode() {
                    if (type == 2) {
                        this.mv.visitCode();
                    }
                    hook.accept(parent);
                    if (type == 1) {
                        this.mv.visitCode();
                    }
                }
            };
        }

        public String toString() {
            return "method begin";
        }
    }

    private static abstract class Element {
        private Element() {
        }

        abstract SpecialMethodVisitor apply(SpecialMethodVisitor var1, CheckedHook var2, int var3, int var4);
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Transformer {
    }

    private static class CheckedHook {
        public final AsmMethodHook hook;
        private boolean once = false;

        public CheckedHook(AsmMethodHook hook) {
            this.hook = hook;
        }

        public void accept(SpecialMethodVisitor smv) {
            this.hook.accept(smv);
            this.once = true;
        }

        public boolean succededOnce() {
            return this.once;
        }
    }

    @FunctionalInterface
    static interface AsmMethodHook
    extends Consumer<SpecialMethodVisitor> {
    }

    public static class SpecialMethodVisitor
    extends MethodVisitor {
        private final Map<String, Integer> locals;
        private final LocalVariablesSorter lvs;
        private final MethodVisitor rootMV;
        public int pass = 1;

        public SpecialMethodVisitor(Map<String, Type> locals, int access, String desc, MethodVisitor mv) {
            super(327680, mv);
            this.locals = new HashMap<String, Integer>();
            if (!locals.isEmpty()) {
                this.lvs = new LocalVariablesSorter(access, desc, mv);
                locals.forEach((k, v) -> this.locals.put((String)k, this.lvs.newLocal(v)));
            } else {
                this.lvs = null;
            }
            this.rootMV = mv;
        }

        public SpecialMethodVisitor(SpecialMethodVisitor mv) {
            super(327680, (MethodVisitor)mv);
            this.locals = mv.locals;
            this.rootMV = mv.rootMV;
            this.lvs = null;
        }

        public void visitHook(AsmMethodHook hook) {
            hook.accept(this);
        }

        public void visitMethodInsn(int opcode, String owner, String mcpName, String srgName, String desc) {
            this.visitMethodInsn(opcode, owner, mcpName, srgName, desc, false);
        }

        public void visitMethodInsn(int opcode, String owner, String mcpName, String srgName, String desc, boolean isInterface) {
            this.visitMethodInsn(opcode, owner, ASM.resolve(mcpName, srgName), desc, isInterface);
        }

        public void visitFieldInsn(int opcode, String owner, String mcpName, String srgName, String desc) {
            this.visitFieldInsn(opcode, owner, ASM.resolve(mcpName, srgName), desc);
        }

        public void visitVarInsn(int opcode, String assocName) {
            Integer var = this.locals.get(assocName);
            if (var == null) {
                throw new IllegalArgumentException("Local with assoc name '" + assocName + "' was never created!");
            }
            this.rootMV.visitVarInsn(opcode, var.intValue());
        }

        public void visitIincInsn(String assocName, int increment) {
            Integer var = this.locals.get(assocName);
            if (var == null) {
                throw new IllegalArgumentException("Local with assoc name '" + assocName + "' was never created!");
            }
            this.rootMV.visitIincInsn(var.intValue(), increment);
        }

        public void visitVarInsn(int opcode, int var) {
            if (this.lvs != null) {
                this.lvs.visitVarInsn(opcode, var);
            } else {
                super.visitVarInsn(opcode, var);
            }
        }

        public void visitIincInsn(int var, int increment) {
            if (this.lvs != null) {
                this.lvs.visitIincInsn(var, increment);
            } else {
                super.visitIincInsn(var, increment);
            }
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            if (this.lvs != null) {
                this.lvs.visitMaxs(maxStack, maxLocals);
            } else {
                super.visitMaxs(maxStack, maxLocals);
            }
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (this.lvs != null) {
                this.lvs.visitLocalVariable(name, desc, signature, start, end, index);
            } else {
                super.visitLocalVariable(name, desc, signature, start, end, index);
            }
        }

        public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
            if (this.lvs != null) {
                return this.lvs.visitLocalVariableAnnotation(typeRef, typePath, start, end, index, desc, visible);
            }
            return super.visitLocalVariableAnnotation(typeRef, typePath, start, end, index, desc, visible);
        }

        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
            if (this.lvs != null) {
                this.lvs.visitFrame(type, nLocal, local, nStack, stack);
            } else {
                super.visitFrame(type, nLocal, local, nStack, stack);
            }
        }
    }

    public static class Modifier {
        public static final int REPLACE = 0;
        public static final int INSERT_BEFORE = 1;
        public static final int INSERT_AFTER = 2;
        private static final String[] TYPE_NAMES = new String[]{"replace", "insert before", "insert after"};
        private final int type;
        private final Patch parent;
        private final Element element;
        private CheckedHook code = null;
        private int at = 1;

        private Modifier(int type, Patch parent, Element element) {
            this.type = type;
            this.parent = parent;
            this.element = element;
        }

        public Patch code(AsmMethodHook code) {
            this.code = new CheckedHook(code);
            return this.parent;
        }

        public Modifier nth(int n) {
            this.at = n;
            return this;
        }

        private SpecialMethodVisitor apply(SpecialMethodVisitor parent) {
            parent.pass = 1;
            if (this.code != null) {
                return this.element.apply(parent, this.code, this.type, this.at);
            }
            throw new IllegalStateException("Modifier " + this.toString() + " has no 'code' block!");
        }

        public String toString() {
            return "<" + TYPE_NAMES[this.type] + (this.at == -1 ? " all" : "") + " " + this.element + (this.at > 1 ? " at " + this.at : "") + ">";
        }
    }

    public static class PatchWithLocals
    extends Patch {
        public PatchWithLocals addLocal(String assocName, Type type) {
            this.locals.put(assocName, type);
            return this;
        }
    }

    public static abstract class Patch {
        protected final List<Modifier> modifiers = new ArrayList<Modifier>();
        protected final Map<String, Type> locals = new HashMap<String, Type>();

        private Patch() {
        }

        public Modifier insertBefore(Element element) {
            Modifier mod = new Modifier(1, this, element);
            this.modifiers.add(mod);
            return mod;
        }

        public Modifier insertAfter(Element element) {
            Modifier mod = new Modifier(2, this, element);
            this.modifiers.add(mod);
            return mod;
        }

        public Modifier replace(Element element) {
            Modifier mod = new Modifier(0, this, element);
            this.modifiers.add(mod);
            return mod;
        }

        public Modifier insertBeforeAll(Element element) {
            return this.insertBefore(element).nth(-1);
        }

        public Modifier insertAfterAll(Element element) {
            return this.insertAfter(element).nth(-1);
        }

        public Modifier replaceAll(Element element) {
            return this.replace(element).nth(-1);
        }
    }

    public static class MethodPatcher {
        public final String transformer;
        private final List<Triple<String, String, String>> methods = new ArrayList<Triple<String, String, String>>();
        private final ClassPatcher parent;
        private final boolean optional;
        private Patch patch = new PatchWithLocals();

        private MethodPatcher(ClassPatcher parent, String transformer, String mcpName, String srgName, String desc, boolean optional) {
            this.parent = parent;
            this.transformer = transformer;
            this.optional = optional;
            this.methods.add((Triple<String, String, String>)Triple.of((Object)mcpName, (Object)srgName, (Object)desc));
        }

        public MethodPatcher and(String mcpName, String srgName, String desc) {
            this.methods.add((Triple<String, String, String>)Triple.of((Object)mcpName, (Object)srgName, (Object)desc));
            return this;
        }

        public ClassPatcher with(Patch patch) {
            this.patch = patch;
            return this.parent;
        }

        private String getMethodName(Triple<String, String, String> method) {
            return (String)method.getLeft() + (String)method.getRight();
        }

        public String getMethodNames() {
            if (this.methods.size() == 1) {
                return this.getMethodName(this.methods.get(0));
            }
            return this.methods.stream().map(this::getMethodName).collect(Collectors.joining(", ", "[ ", " ]"));
        }
    }

    public static class ClassPatcher {
        private final List<MethodPatcher> patches = new ArrayList<MethodPatcher>();
        private final List<Tuple4<Integer, String, String, String>> fields = new ArrayList<Tuple4<Integer, String, String, String>>();

        private ClassPatcher() {
        }

        public ClassPatcher addField(int acc, String name, String desc, String sign) {
            this.fields.add((Tuple4<Integer, String, String, String>)new Tuple4((Object)acc, (Object)name, (Object)desc, (Object)sign));
            return this;
        }

        public ClassPatcher addField(int acc, String name, String desc) {
            return this.addField(acc, name, desc, null);
        }

        public MethodPatcher patchConstructor(String desc) {
            return this.patchMethod("<init>", "<init>", desc);
        }

        public MethodPatcher patchMethod(String mcpName, String srgName, String desc) {
            MethodPatcher patch = new MethodPatcher(this, currentTransformer, mcpName, srgName, desc, false);
            this.patches.add(patch);
            return patch;
        }

        public MethodPatcher patchMethodOptionally(String mcpName, String srgName, String desc) {
            MethodPatcher patch = new MethodPatcher(this, currentTransformer, mcpName, srgName, desc, true);
            this.patches.add(patch);
            return patch;
        }
    }

    private static class ClassPatchVisitor
    extends ClassVisitor {
        public final Multimap<String, Modifier> modifiers = HashMultimap.create();
        public final List<MethodPatcher> unusedPatches;
        private final ClassPatcher patcher;

        public ClassPatchVisitor(ClassVisitor parent, ClassPatcher patcher) {
            super(327680, parent);
            this.patcher = patcher;
            this.unusedPatches = new ArrayList<MethodPatcher>(patcher.patches);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.patcher.fields.forEach(f -> this.cv.visitField(((Integer)f._1()).intValue(), (String)f._2(), (String)f._3(), (String)f._4(), null).visitEnd());
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            HashSet<String> transformers = new HashSet<String>();
            ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
            HashMap<String, Type> locals = new HashMap<String, Type>();
            block0: for (MethodPatcher patch : this.patcher.patches) {
                for (Triple md : patch.methods) {
                    String mcpName = (String)md.getLeft();
                    if (!name.equals(ASM.resolve(mcpName, (String)md.getMiddle())) || !desc.equals(md.getRight())) continue;
                    transformers.add(patch.transformer);
                    modifiers.addAll(((MethodPatcher)patch).patch.modifiers);
                    this.modifiers.putAll((Object)(mcpName + desc), ((MethodPatcher)patch).patch.modifiers);
                    locals.putAll(((MethodPatcher)patch).patch.locals);
                    this.unusedPatches.remove(patch);
                    continue block0;
                }
            }
            MethodVisitor parent = super.visitMethod(access, name, desc, signature, exceptions);
            if (!modifiers.isEmpty()) {
                SpecialMethodVisitor visitor = new SpecialMethodVisitor(locals, access, desc, parent);
                for (Modifier mod : modifiers) {
                    visitor = mod.apply(visitor);
                }
                return visitor;
            }
            return parent;
        }
    }
}

