/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.access;

import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Timer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LucraftTickrateHooks {
    public static float TICKS_PER_SECOND = 20.0f;
    public static long MILISECONDS_PER_TICK = 50L;
    public static float GAME_SPEED = 1.0f;
    public static final float DEFAULT_TICKS_PER_SECOND = 20.0f;
    public static final long DEFAULT_MILISECONDS_PER_TICK = 50L;
    public static final float DEFAULT_GAME_SPEED = 1.0f;
    private static Field clientTimer = null;

    @SideOnly(value=Side.CLIENT)
    public static void updateClientTickrate(float tickrate) {
        TICKS_PER_SECOND = tickrate;
        GAME_SPEED = tickrate / 20.0f;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null) {
            return;
        }
        try {
            if (clientTimer == null) {
                for (Field f : mc.getClass().getDeclaredFields()) {
                    if (f.getType() != Timer.class) continue;
                    clientTimer = f;
                    clientTimer.setAccessible(true);
                    break;
                }
            }
            clientTimer.set(mc, new Timer(TICKS_PER_SECOND));
            LucraftTickrateHooks.updateServerTickrate(tickrate);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isNormalTickrate() {
        return TICKS_PER_SECOND == 20.0f && MILISECONDS_PER_TICK == 50L;
    }

    public static void updateServerTickrate(float tickrate) {
        MILISECONDS_PER_TICK = (long)(1000.0f / tickrate);
    }

    public static long getTickrate() {
        return MILISECONDS_PER_TICK;
    }
}

