/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.client.render.abilitybar;

import lucraft.mods.lucraftcore.abilities.Ability;
import lucraft.mods.lucraftcore.client.LucraftCoreKeyBindings;
import lucraft.mods.lucraftcore.client.render.abilitybar.AbilityBarMainHandler;
import lucraft.mods.lucraftcore.client.render.abilitybar.IAbilityBar;
import lucraft.mods.lucraftcore.superpower.Superpower;
import lucraft.mods.lucraftcore.superpower.SuperpowerPlayerHandler;
import lucraft.mods.lucraftcore.util.LucraftKeys;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;

public class AbilityBarSuperpowerAbility
implements IAbilityBar {
    public Ability ability;

    public AbilityBarSuperpowerAbility(Ability ability) {
        this.ability = ability;
    }

    @Override
    public void render(Minecraft mc, int x, int y, EntityPlayer player, Superpower superpower, SuperpowerPlayerHandler handler) {
        LucraftKeys key;
        this.ability.drawIcon(mc, (Gui)mc.field_71456_v, x + 4, y + 4);
        if (this.ability.isEnabled() && (this.ability.getAbilityType() == Ability.AbilityType.TOGGLE || this.ability.getAbilityType() == Ability.AbilityType.HELD)) {
            mc.field_71446_o.func_110577_a(AbilityBarMainHandler.hudTex);
            mc.field_71456_v.func_73729_b(x + 16, y + 16, 24, 0, 6, 6);
        }
        if (this.ability.hasCooldown()) {
            mc.field_71446_o.func_110577_a(AbilityBarMainHandler.hudTex);
            float cooldown = 1.0f - (float)this.ability.getCooldown() / (float)this.ability.getMaxCooldown();
            mc.field_71456_v.func_73729_b(x + 3, y + 21, 0, 33, (int)(cooldown * 18.0f), 3);
        }
        if ((key = this.getKeyFromAbility(player, handler)) != null) {
            mc.field_71466_p.func_175065_a(GameSettings.func_74298_c((int)LucraftCoreKeyBindings.getKeyBindingFromKeyType(key).func_151463_i()), (float)(x + 25), (float)(y + 9), 0xFEFEFE, true);
        }
    }

    @Override
    public boolean isActive(Minecraft mc, EntityPlayer player, Superpower superpower, SuperpowerPlayerHandler handler) {
        return this.ability != null && this.ability.isUnlocked();
    }

    public LucraftKeys getKeyFromAbility(EntityPlayer player, SuperpowerPlayerHandler handler) {
        for (LucraftKeys keys : LucraftKeys.values()) {
            if (keys.type != LucraftKeys.LucraftKeyTypes.SUPERPOWER_ACTION || this.ability != handler.getAbilityForKey(keys)) continue;
            return keys;
        }
        return null;
    }
}

