/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.integration.jei.pulverizer;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class PulverizerCategory
extends BlankRecipeCategory {
    protected static final int inputSlot = 0;
    protected static final int fuelSlot = 1;
    protected static final int outputSlot = 2;
    protected final ResourceLocation backgroundLocation = new ResourceLocation("minecraft", "textures/gui/container/furnace.png");
    @Nonnull
    protected final IDrawableAnimated flame;
    @Nonnull
    protected final IDrawableAnimated arrow;
    @Nonnull
    private final IDrawable background;

    public PulverizerCategory(IGuiHelper guiHelper) {
        IDrawableStatic flameDrawable = guiHelper.createDrawable(this.backgroundLocation, 176, 0, 14, 14);
        this.flame = guiHelper.createAnimatedDrawable(flameDrawable, 300, IDrawableAnimated.StartDirection.TOP, true);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(this.backgroundLocation, 176, 14, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        ResourceLocation location = new ResourceLocation("minecraft", "textures/gui/container/furnace.png");
        this.background = guiHelper.createDrawable(location, 55, 16, 82, 54);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawAnimations(@Nonnull Minecraft minecraft) {
        this.flame.draw(minecraft, 2, 20);
        this.arrow.draw(minecraft, 24, 18);
    }

    @Nonnull
    public String getTitle() {
        return Translator.translateToLocal((String)"tile.machinePulverizer.name");
    }

    @Nonnull
    public String getUid() {
        return "lucraftcore.pulverizer";
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(2, false, 60, 18);
        List inputs = recipeWrapper.getInputs();
        guiItemStacks.set(0, (List)inputs.get(0));
        List outputs = recipeWrapper.getOutputs();
        guiItemStacks.set(2, (ItemStack)outputs.get(0));
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(2, false, 60, 18);
        guiItemStacks.set(ingredients);
    }
}

