/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.network;

import io.netty.buffer.ByteBuf;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.network.AbstractClientMessageHandler;
import lucraft.mods.lucraftcore.superpower.Superpower;
import lucraft.mods.lucraftcore.superpower.SuperpowerHandler;
import lucraft.mods.lucraftcore.superpower.SuperpowerPlayerHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSyncPlayerData
implements IMessage {
    private String playerName;
    private NBTTagCompound data;
    private NBTTagCompound superpowerData;

    public MessageSyncPlayerData() {
    }

    public MessageSyncPlayerData(EntityPlayer player) {
        this.playerName = player.func_70005_c_();
        this.data = (NBTTagCompound)LucraftCore.SUPERPOWER_CAP.getStorage().writeNBT(LucraftCore.SUPERPOWER_CAP, player.getCapability(LucraftCore.SUPERPOWER_CAP, null), null);
        NBTTagCompound currentSData = player.getEntityData().func_74775_l("Superpowers");
        Superpower power = SuperpowerHandler.getSuperpower(player);
        SuperpowerPlayerHandler handler = SuperpowerHandler.getSuperpowerPlayerHandler(player);
        if (handler != null) {
            NBTTagCompound handlerNBT = new NBTTagCompound();
            handlerNBT = handler.writeToNBT(handlerNBT);
            currentSData.func_74782_a(power.getUnlocalizedName(), (NBTBase)handlerNBT);
        }
        this.superpowerData = currentSData;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
        this.superpowerData = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerName);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.superpowerData);
    }

    public static class Handler
    extends AbstractClientMessageHandler<MessageSyncPlayerData> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, final MessageSyncPlayerData message, final MessageContext ctx) {
            LucraftCore.proxy.getThreadFromContext(ctx).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayer en;
                    if (message != null && ctx != null && (en = LucraftCore.proxy.getPlayerEntity((MessageContext)ctx).field_70170_p.func_72924_a(message.playerName)) != null) {
                        LucraftCore.SUPERPOWER_CAP.getStorage().readNBT(LucraftCore.SUPERPOWER_CAP, en.getCapability(LucraftCore.SUPERPOWER_CAP, null), null, (NBTBase)message.data);
                        en.getEntityData().func_74782_a("Superpowers", (NBTBase)message.superpowerData);
                        Superpower power = SuperpowerHandler.getSuperpower(en);
                        SuperpowerPlayerHandler handler = SuperpowerHandler.getSuperpowerPlayerHandler(en);
                        if (handler != null) {
                            handler.readFromNBT(en.getEntityData().func_74775_l("Superpowers").func_74775_l(power.getUnlocalizedName()));
                        }
                    }
                }
            });
            return null;
        }
    }
}

