/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.sizechange;

import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.network.MessageSyncSize;
import lucraft.mods.lucraftcore.network.PacketDispatcher;
import lucraft.mods.lucraftcore.sizechange.ISizeChangeCapability;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;

public class SizeChangeManager {
    public static final float LOWER_LIMIT = 2.4414062E-4f;
    public static final float UPPER_LIMIT = 16.0f;

    public static ISizeChangeCapability getData(Entity entity) {
        return (ISizeChangeCapability)entity.getCapability(LucraftCore.SIZECHANGE_CAP, null);
    }

    public static float getSize(Entity entity) {
        return SizeChangeManager.getData(entity).getSize();
    }

    public static void setBaseSize(Entity entity, float baseSize) {
        SizeChangeManager.getData(entity).setBaseSize(baseSize);
        SizeChangeManager.sendUpdatePacket(entity);
    }

    public static float getBaseSize(Entity entity) {
        return SizeChangeManager.getData(entity).getSize();
    }

    public static void sendUpdatePacket(Entity entity) {
        PacketDispatcher.sendToAll(new MessageSyncSize(entity));
    }

    public static void sendUpdatePacket(Entity entity, EntityPlayerMP receiver) {
        PacketDispatcher.sendTo(new MessageSyncSize(entity), receiver);
    }
}

