/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.suitset;

import java.util.HashMap;
import java.util.List;
import lucraft.mods.lucraftcore.suitset.SuitSet;
import lucraft.mods.lucraftcore.util.IFakePlayerEntity;
import lucraft.mods.lucraftcore.util.IOpenableHelmet;
import lucraft.mods.lucraftcore.util.IRenderFirstPersonHand;
import lucraft.mods.lucraftcore.util.IShiftableItemToolTip;
import lucraft.mods.lucraftcore.util.LucraftCoreClientUtil;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSuitSetArmor
extends ItemArmor
implements IRenderFirstPersonHand,
IOpenableHelmet,
IShiftableItemToolTip {
    private SuitSet suitSet;
    protected String itemName;

    public ItemSuitSetArmor(SuitSet suitSet, EntityEquipmentSlot armorSlot) {
        super(suitSet.getArmorMaterial(armorSlot), 0, armorSlot);
        this.itemName = suitSet.getUnlocalizedName() + this.getArmorSlotName(armorSlot);
        if (suitSet.showInCreativeTab()) {
            this.func_77637_a(suitSet.getCreativeTab());
        } else {
            this.func_77637_a(null);
        }
        this.suitSet = suitSet;
    }

    public SuitSet getSuitSet() {
        return this.suitSet;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (this.getSuitSet().hasExtraDescription(stack, player)) {
            tooltip.addAll(this.getSuitSet().getExtraDescription(stack, player));
        }
    }

    public String func_77653_i(ItemStack stack) {
        return this.getSuitSet().getDisplayNameForItem((Item)this, stack, this.field_77881_a);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return this.getSuitSet().getArmorTexturePath(stack, entity, slot, false, entity instanceof EntityPlayer ? LucraftCoreClientUtil.hasSmallArms((EntityPlayer)entity) : false, this.isHelmetOpen(entity, stack));
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelBiped armorModel = null;
        if (itemStack != null) {
            boolean smallArms = false;
            if (entityLiving instanceof IFakePlayerEntity) {
                smallArms = false;
            } else if (entityLiving instanceof EntityPlayer) {
                smallArms = LucraftCoreClientUtil.hasSmallArms((EntityPlayer)entityLiving);
            }
            armorModel = this.getSuitSet().getArmorModel(itemStack, (Entity)entityLiving, armorSlot, false, smallArms, this.isHelmetOpen((Entity)entityLiving, itemStack));
            if (armorModel != null) {
                armorModel.func_178686_a((ModelBase)_default);
                return armorModel;
            }
        }
        return super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
    }

    public String getArmorSlotName(EntityEquipmentSlot slot) {
        switch (slot) {
            case HEAD: {
                return "Helmet";
            }
            case CHEST: {
                return "Chestplate";
            }
            case LEGS: {
                return "Legs";
            }
            case FEET: {
                return "Boots";
            }
        }
        return "";
    }

    @Override
    public HashMap<ModelBiped, Object[]> getFirstPersonModels(ItemStack stack, EntityPlayer player, EntityEquipmentSlot armorSlot, boolean smallArms) {
        HashMap<ModelBiped, Object[]> map = new HashMap<ModelBiped, Object[]>();
        map.put(this.getSuitSet().getArmorModel(stack, (Entity)player, armorSlot, false, smallArms, false), new Object[]{this.getSuitSet().getArmorTexturePath(stack, (Entity)player, armorSlot, false, smallArms, false), false});
        if (this.getSuitSet().hasGlowyThings((EntityLivingBase)player, this.field_77881_a)) {
            map.put(this.getSuitSet().getArmorModel(stack, (Entity)player, armorSlot, false, smallArms, false), new Object[]{this.getSuitSet().getArmorTexturePath(stack, (Entity)player, armorSlot, true, smallArms, false), true});
        }
        return map;
    }

    @Override
    public void openCloseHelmet(Entity player, ItemStack stack) {
        if (this.field_77881_a == EntityEquipmentSlot.HEAD && this.getSuitSet().canOpenHelmet()) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (stack.func_77942_o()) {
                nbt = stack.func_77978_p();
            }
            nbt.func_74757_a("IsHelmetOpen", !nbt.func_74767_n("IsHelmetOpen"));
            this.onHelmetOpen(player, stack, nbt.func_74767_n("IsHelmetOpen"));
            stack.func_77982_d(nbt);
        }
    }

    @Override
    public boolean isHelmetOpen(Entity entity, ItemStack stack) {
        if (this.field_77881_a == EntityEquipmentSlot.HEAD && this.getSuitSet().canOpenHelmet() && stack.func_77942_o()) {
            return stack.func_77978_p().func_74767_n("IsHelmetOpen");
        }
        return false;
    }

    @Override
    public void onHelmetOpen(Entity entity, ItemStack stack, boolean open) {
        this.getSuitSet().onOpenHelmet(entity, stack, open);
    }

    @Override
    public boolean shouldRenderShiftableToolTip(ItemStack stack, EntityPlayer player) {
        return false;
    }

    @Override
    public List<String> getShiftableToolTip(ItemStack stack, EntityPlayer player) {
        return null;
    }

    @Override
    public boolean shouldRenderArmorAbilitiesToolTip(ItemStack stack, EntityPlayer player) {
        return true;
    }
}

