/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpower;

import java.util.ArrayList;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.abilities.Ability;
import lucraft.mods.lucraftcore.events.EntityKnockOutEvent;
import lucraft.mods.lucraftcore.network.MessageSyncDisabledAbilities;
import lucraft.mods.lucraftcore.network.MessageSyncPlayerData;
import lucraft.mods.lucraftcore.network.MessageSyncPotionEffects;
import lucraft.mods.lucraftcore.network.PacketDispatcher;
import lucraft.mods.lucraftcore.potions.PotionKnockOut;
import lucraft.mods.lucraftcore.superpower.ISuperpowerCapability;
import lucraft.mods.lucraftcore.util.KarmaHandler;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SuperpowerEventHandler {
    @SubscribeEvent
    public void onEntityConstruct(AttachCapabilitiesEvent.Entity evt) {
        if (LucraftCoreUtil.isRealPlayer(evt.getEntity())) {
            evt.addCapability(new ResourceLocation("lucraftcore", "ISuperpowerCapability"), (ICapabilityProvider)new ICapabilitySerializable<NBTBase>(){
                ISuperpowerCapability inst = (ISuperpowerCapability)LucraftCore.SUPERPOWER_CAP.getDefaultInstance();

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == this.inst;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == LucraftCore.SUPERPOWER_CAP ? LucraftCore.SUPERPOWER_CAP.cast((Object)this.inst) : null);
                }

                public NBTBase serializeNBT() {
                    return LucraftCore.SUPERPOWER_CAP.getStorage().writeNBT(LucraftCore.SUPERPOWER_CAP, (Object)this.inst, null);
                }

                public void deserializeNBT(NBTBase nbt) {
                    LucraftCore.SUPERPOWER_CAP.getStorage().readNBT(LucraftCore.SUPERPOWER_CAP, (Object)this.inst, null, nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public void worldJoin(EntityJoinWorldEvent e) {
        if (LucraftCoreUtil.isRealPlayer(e.getEntity())) {
            EntityPlayer player = (EntityPlayer)e.getEntity();
            ISuperpowerCapability superpowerdata = (ISuperpowerCapability)player.getCapability(LucraftCore.SUPERPOWER_CAP, null);
            superpowerdata.setCapabilityOwner(player);
            if (player instanceof EntityPlayerMP) {
                PacketDispatcher.sendTo(new MessageSyncPlayerData(player), (EntityPlayerMP)player);
                PacketDispatcher.sendTo(new MessageSyncDisabledAbilities(), (EntityPlayerMP)player);
            }
        }
    }

    @SubscribeEvent
    public void onUpdate(TickEvent.PlayerTickEvent e) {
        if (LucraftCoreUtil.isRealPlayer((Entity)e.player)) {
            ISuperpowerCapability superpowerdata = (ISuperpowerCapability)e.player.getCapability(LucraftCore.SUPERPOWER_CAP, null);
            superpowerdata.onUpdate(e.phase);
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent e) {
        if (LucraftCoreUtil.isRealPlayer((Entity)e.player)) {
            ISuperpowerCapability superpowerdata = (ISuperpowerCapability)e.player.getCapability(LucraftCore.SUPERPOWER_CAP, null);
            superpowerdata.setCapabilityOwner(e.player);
            superpowerdata.loadSuperpowerHandler();
            if (superpowerdata.getPlayerHandler() != null) {
                superpowerdata.getPlayerHandler().onRespawn();
            }
        }
    }

    @SubscribeEvent
    public void interact(PlayerInteractEvent e) {
    }

    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        NBTTagCompound superpowerData = event.getOriginal().getEntityData().func_74775_l("Superpowers");
        event.getEntityPlayer().getEntityData().func_74782_a("Superpowers", (NBTBase)superpowerData);
        NBTTagCompound compound = new NBTTagCompound();
        compound = (NBTTagCompound)LucraftCore.SUPERPOWER_CAP.getStorage().writeNBT(LucraftCore.SUPERPOWER_CAP, event.getOriginal().getCapability(LucraftCore.SUPERPOWER_CAP, null), null);
        LucraftCore.SUPERPOWER_CAP.getStorage().readNBT(LucraftCore.SUPERPOWER_CAP, event.getEntityPlayer().getCapability(LucraftCore.SUPERPOWER_CAP, null), null, (NBTBase)compound);
        LucraftCoreUtil.sendSuperpowerUpdatePacketToAllPlayers(event.getEntityPlayer());
    }

    @SubscribeEvent
    public void onLivingAttackEvent(LivingAttackEvent e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntityLiving();
            for (Ability ab : Ability.getCurrentPlayerAbilities(player)) {
                if (!ab.isUnlocked()) continue;
                ab.onAttacked(e);
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent e) {
        EntityPlayer player;
        if (e.getEntityLiving() instanceof EntityPlayer) {
            player = (EntityPlayer)e.getEntityLiving();
            for (Ability ab : Ability.getCurrentPlayerAbilities(player)) {
                if (!ab.isUnlocked()) continue;
                ab.onPlayerHurt(e);
            }
        }
        if (e.getSource() != null && e.getSource().func_76364_f() != null && e.getSource().func_76364_f() instanceof EntityPlayer) {
            player = (EntityPlayer)e.getSource().func_76364_f();
            for (Ability ab : Ability.getCurrentPlayerAbilities(player)) {
                if (!ab.isUnlocked()) continue;
                ab.onHurt(e);
            }
            if (((ISuperpowerCapability)player.getCapability(LucraftCore.SUPERPOWER_CAP, null)).isKnockOutModeEnabled()) {
                e.setAmount(e.getAmount() / 2.0f);
            }
        }
    }

    @SubscribeEvent
    public void onAttackEntityEvent(AttackEntityEvent e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntityLiving();
            for (Ability ab : Ability.getCurrentPlayerAbilities(player)) {
                if (!ab.isUnlocked()) continue;
                ab.onAttackEntity(e);
            }
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntityLiving();
            for (Ability ab : Ability.getCurrentPlayerAbilities(player)) {
                if (!ab.isUnlocked()) continue;
                ab.onBreakSpeed(e);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent e) {
        EntityPlayer player;
        if (e.getSource() != null && e.getSource().func_76364_f() != null && e.getSource().func_76364_f() instanceof EntityPlayer && !e.getEntityLiving().func_70644_a((Potion)PotionKnockOut.potion) && ((ISuperpowerCapability)(player = (EntityPlayer)e.getSource().func_76364_f()).getCapability(LucraftCore.SUPERPOWER_CAP, null)).isKnockOutModeEnabled()) {
            if (MinecraftForge.EVENT_BUS.post((Event)new EntityKnockOutEvent.Start(e.getEntityLiving(), player))) {
                return;
            }
            if (KarmaHandler.isEvilEntity(e.getEntityLiving())) {
                KarmaHandler.setHostileKnockOuts(player, KarmaHandler.getHostileKnockOuts(player) + 1);
            }
            e.setCanceled(true);
            e.getEntityLiving().func_70606_j(e.getEntityLiving().func_110138_aP());
            int duration = 1200;
            PotionEffect blindness = new PotionEffect(MobEffects.field_76440_q, duration, 0, false, false);
            blindness.setCurativeItems(new ArrayList());
            PotionEffect slowness = new PotionEffect(MobEffects.field_76421_d, duration, 255, false, false);
            slowness.setCurativeItems(new ArrayList());
            PotionEffect jumpboost = new PotionEffect(MobEffects.field_76430_j, duration, 128, false, false);
            jumpboost.setCurativeItems(new ArrayList());
            PotionEffect fatigue = new PotionEffect(MobEffects.field_76419_f, duration, 128, false, false);
            fatigue.setCurativeItems(new ArrayList());
            PotionEffect weakness = new PotionEffect(MobEffects.field_76437_t, duration, 128, false, false);
            weakness.setCurativeItems(new ArrayList());
            PotionEffect knockout = new PotionEffect((Potion)PotionKnockOut.potion, duration, 0, false, false);
            knockout.setCurativeItems(new ArrayList());
            e.getEntityLiving().func_70690_d(blindness);
            e.getEntityLiving().func_70690_d(slowness);
            e.getEntityLiving().func_70690_d(jumpboost);
            e.getEntityLiving().func_70690_d(fatigue);
            e.getEntityLiving().func_70690_d(weakness);
            e.getEntityLiving().func_70690_d(knockout);
            PacketDispatcher.sendToAll(new MessageSyncPotionEffects(e.getEntityLiving()));
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent e) {
        if (e.getEntityLiving().func_70644_a((Potion)PotionKnockOut.potion)) {
            e.getEntityLiving().field_70177_z = e.getEntityLiving().field_70126_B;
            e.getEntityLiving().field_70125_A = e.getEntityLiving().field_70127_C;
            e.getEntityLiving().field_70759_as = 0.0f;
            e.getEntityLiving().field_70143_R = 0.0f;
            if (e.getEntityLiving().func_70660_b((Potion)PotionKnockOut.potion).func_76459_b() == 0) {
                MinecraftForge.EVENT_BUS.post((Event)new EntityKnockOutEvent.WakeUp(e.getEntityLiving()));
                e.getEntityLiving().func_184589_d((Potion)PotionKnockOut.potion);
                if (e.getEntityLiving() instanceof EntityPlayer) {
                    BlockPos respawn = ((EntityPlayer)e.getEntityLiving()).func_180470_cg();
                    if (respawn != null) {
                        e.getEntityLiving().func_70634_a((double)respawn.func_177958_n(), (double)respawn.func_177956_o(), (double)respawn.func_177952_p());
                    }
                } else {
                    e.getEntityLiving().func_70106_y();
                }
                PacketDispatcher.sendToAll(new MessageSyncPotionEffects(e.getEntityLiving()));
            }
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent e) {
        if (e.getEntityLiving().func_70644_a((Potion)PotionKnockOut.potion)) {
            e.getEntityLiving().field_70159_w = 0.0;
            e.getEntityLiving().field_70181_x = 0.0;
            e.getEntityLiving().field_70179_y = 0.0;
        }
    }
}

