/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util;

import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.superpower.SPDefaultImplementation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class KarmaHandler {
    public static int getAmbientKills(EntityPlayer player) {
        return ((SPDefaultImplementation)player.getCapability(LucraftCore.SUPERPOWER_CAP, null)).ambientKills;
    }

    public static void setAmbientKills(EntityPlayer player, int i) {
        ((SPDefaultImplementation)player.getCapability(LucraftCore.SUPERPOWER_CAP, null)).ambientKills = i;
        ((SPDefaultImplementation)player.getCapability(LucraftCore.SUPERPOWER_CAP, null)).minutesSinceLastAmbientKill = 0;
    }

    public static int getMinutesSinceLastAmbientKill(EntityPlayer player) {
        return ((SPDefaultImplementation)player.getCapability(LucraftCore.SUPERPOWER_CAP, null)).minutesSinceLastAmbientKill;
    }

    public static int getHostileKills(EntityPlayer player) {
        return ((SPDefaultImplementation)player.getCapability(LucraftCore.SUPERPOWER_CAP, null)).hostileKills;
    }

    public static void setHostileKills(EntityPlayer player, int i) {
        ((SPDefaultImplementation)player.getCapability(LucraftCore.SUPERPOWER_CAP, null)).hostileKills = i;
    }

    public static int getHostileKnockOuts(EntityPlayer player) {
        return ((SPDefaultImplementation)player.getCapability(LucraftCore.SUPERPOWER_CAP, null)).hostileKnockOuts;
    }

    public static void setHostileKnockOuts(EntityPlayer player, int i) {
        ((SPDefaultImplementation)player.getCapability(LucraftCore.SUPERPOWER_CAP, null)).hostileKnockOuts = i;
    }

    public static int getTotalKills(EntityPlayer player) {
        return KarmaHandler.getAmbientKills(player) + KarmaHandler.getHostileKills(player);
    }

    public static boolean isEvilPlayer(EntityPlayer player) {
        return KarmaHandler.getMinutesSinceLastAmbientKill(player) < 10 || KarmaHandler.getAmbientKills(player) >= KarmaHandler.getHostileKills(player);
    }

    public static boolean isEvilEntity(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return KarmaHandler.isEvilPlayer((EntityPlayer)entity);
        }
        boolean isEvil = false;
        for (Biome.SpawnListEntry entry : entity.field_70170_p.func_180494_b(entity.func_180425_c()).func_76747_a(EnumCreatureType.MONSTER)) {
            if (entry.field_76300_b != entity.getClass()) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDeath(LivingDeathEvent e) {
        if (e.isCanceled()) {
            return;
        }
        if (e.getSource() != null && e.getSource().func_76364_f() != null) {
            EntityPlayer player = null;
            if (e.getSource().func_76364_f() instanceof EntityPlayer) {
                player = (EntityPlayer)e.getSource().func_76364_f();
            } else if (e.getSource().func_76364_f() instanceof EntityThrowable && ((EntityThrowable)e.getSource().func_76364_f()).func_85052_h() != null && ((EntityThrowable)e.getSource().func_76364_f()).func_85052_h() instanceof EntityPlayer) {
                player = (EntityPlayer)((EntityThrowable)e.getSource().func_76364_f()).func_85052_h();
            } else if (e.getSource().func_76364_f() instanceof EntityArrow && ((EntityArrow)e.getSource().func_76364_f()).field_70250_c != null && ((EntityArrow)e.getSource().func_76364_f()).field_70250_c instanceof EntityPlayer) {
                player = (EntityPlayer)((EntityArrow)e.getSource().func_76364_f()).field_70250_c;
            } else {
                return;
            }
            EntityLivingBase killed = e.getEntityLiving();
            if (KarmaHandler.isEvilEntity(killed)) {
                KarmaHandler.setHostileKills(player, KarmaHandler.getHostileKills(player) + 1);
            } else {
                KarmaHandler.setAmbientKills(player, KarmaHandler.getAmbientKills(player) + 1);
            }
        }
    }
}

