/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util;

import java.util.List;
import java.util.UUID;
import lucraft.mods.lucraftcore.abilities.Ability;
import lucraft.mods.lucraftcore.abilities.AbilityDamageResistance;
import lucraft.mods.lucraftcore.abilities.AbilityFallResistance;
import lucraft.mods.lucraftcore.abilities.AbilityFireResistance;
import lucraft.mods.lucraftcore.abilities.AbilityHealing;
import lucraft.mods.lucraftcore.abilities.AbilityJumpBoost;
import lucraft.mods.lucraftcore.abilities.AbilityPunch;
import lucraft.mods.lucraftcore.abilities.AbilitySprint;
import lucraft.mods.lucraftcore.abilities.AbilityStepAssist;
import lucraft.mods.lucraftcore.abilities.AbilityStrength;
import lucraft.mods.lucraftcore.client.gui.GuiAbilityTree;
import lucraft.mods.lucraftcore.superpower.ISuperpowerAbilityCoordinates;
import lucraft.mods.lucraftcore.superpower.Superpower;
import lucraft.mods.lucraftcore.superpower.SuperpowerPlayerHandler;
import lucraft.mods.lucraftcore.util.TestPowerPlayerHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec2f;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SuperpowerTest
extends Superpower
implements ISuperpowerAbilityCoordinates {
    public SuperpowerTest(String name) {
        super(name);
    }

    @Override
    public List<Ability> addDefaultAbilities(EntityPlayer player, List<Ability> list) {
        Ability dmgResistance = new AbilityDamageResistance(player, 0.75f).setUnlocked(true);
        list.add(new AbilityHealing(player, 40, 0.5f).setUnlocked(true));
        list.add(new AbilityStrength(player, UUID.fromString("3ce22eb8-41de-476c-b0b0-c0528a2abc0c"), 1.0f, 0).setUnlocked(true));
        list.add(new AbilityPunch(player, UUID.fromString("3ce22eb8-41de-476c-b0b0-c0528a2abc0c"), 3.0f, 0).setUnlocked(true));
        list.add(new AbilitySprint(player, UUID.fromString("3ce22eb8-41de-476c-b0b0-c0528a2abc0c"), 1.2f).setUnlocked(true));
        list.add(new AbilityJumpBoost(player, UUID.fromString("3ce22eb8-41de-476c-b0b0-c0528a2abc0c"), 1.2f, 1).setUnlocked(true));
        list.add(new AbilityStepAssist(player, UUID.fromString("3ce22eb8-41de-476c-b0b0-c0528a2abc0c"), 1.0f, 0).setUnlocked(true));
        list.add(dmgResistance);
        list.add(new AbilityFireResistance(player).setDependentAbility(dmgResistance));
        list.add(new AbilityFallResistance(player).setDependentAbility(dmgResistance));
        return list;
    }

    @Override
    public Vec2f getDisplayCoordinatesForAbility(Ability ability) {
        if (ability instanceof AbilityHealing) {
            return new Vec2f(0.0f, 0.0f);
        }
        if (ability instanceof AbilityStrength) {
            return new Vec2f(1.0f, 0.0f);
        }
        if (ability instanceof AbilityPunch) {
            return new Vec2f(-1.0f, 0.0f);
        }
        if (ability instanceof AbilitySprint) {
            return new Vec2f(2.0f, 0.0f);
        }
        if (ability instanceof AbilityJumpBoost) {
            return new Vec2f(-2.0f, 0.0f);
        }
        if (ability instanceof AbilityStepAssist) {
            return new Vec2f(3.0f, 0.0f);
        }
        if (ability instanceof AbilityDamageResistance) {
            return new Vec2f(0.0f, 2.0f);
        }
        if (ability instanceof AbilityFireResistance) {
            return new Vec2f(-1.0f, 3.0f);
        }
        if (ability instanceof AbilityFallResistance) {
            return new Vec2f(1.0f, 1.0f);
        }
        return null;
    }

    @Override
    public SuperpowerPlayerHandler getNewSuperpowerHandler(EntityPlayer player) {
        return new TestPowerPlayerHandler(player);
    }

    @Override
    public void renderIcon(Minecraft mc, int x, int y) {
    }

    @Override
    public boolean canLevelUp() {
        return true;
    }

    @Override
    public int getMaxLevel() {
        return 5;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getAbilityGui(EntityPlayer player) {
        return new GuiAbilityTree(player);
    }
}

