/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;

public class TileEntityEnergy
extends TileEntity
implements IEnergyReceiver,
IEnergyProvider,
ITickable {
    protected EnergyStorage storage;
    private int fuelTimer = 0;
    private int maxFuelTimer = 0;

    public TileEntityEnergy(int capacity, int maxTransfer) {
        this.storage = new EnergyStorage(capacity, maxTransfer);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.readFromNBT(nbt);
        this.fuelTimer = nbt.func_74762_e("FuelTimer");
        this.maxFuelTimer = nbt.func_74762_e("MaxFuelTimer");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.storage.writeToNBT(nbt);
        nbt.func_74768_a("FuelTimer", this.fuelTimer);
        nbt.func_74768_a("MaxFuelTimer", this.maxFuelTimer);
        return nbt;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        int i = this.storage.receiveEnergy(maxReceive, simulate);
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
        this.func_70296_d();
        return i;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        int i = this.storage.extractEnergy(maxExtract, simulate);
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
        this.func_70296_d();
        return i;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    public void func_73660_a() {
        if (this.getFuelStack() != null && TileEntityFurnace.func_145954_b((ItemStack)this.getFuelStack()) && this.fuelTimer == 0 && this.getEnergyStored(null) < this.getMaxEnergyStored(null)) {
            this.maxFuelTimer = this.fuelTimer = TileEntityFurnace.func_145952_a((ItemStack)this.getFuelStack()) * 10;
            this.removeFuel();
        }
        if (this.fuelTimer > 0) {
            this.receiveEnergy(null, this.fuelTimer, false);
            this.fuelTimer = MathHelper.func_76125_a((int)(this.fuelTimer - this.storage.getMaxReceive()), (int)0, (int)Integer.MAX_VALUE);
        }
    }

    public ItemStack getFuelStack() {
        return null;
    }

    public void removeFuel() {
    }

    public float getFuelProgress() {
        if (this.maxFuelTimer == 0) {
            return 0.0f;
        }
        return (float)this.fuelTimer / (float)this.maxFuelTimer;
    }
}

