/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.worldgen;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import lucraft.mods.lucraftcore.blocks.LCBlocks;
import lucraft.mods.lucraftcore.util.EnumMetalTypes;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class LCWorldGenerator
implements IWorldGenerator {
    public static HashMap<EnumMetalTypes, ArrayList<Integer>> oreSpawns = new HashMap();

    public static void init(FMLPreInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new LCWorldGenerator(), (int)0);
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        for (EnumMetalTypes type : EnumMetalTypes.values()) {
            if (type.isAlloy()) continue;
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(config.get("Ores." + type.func_176610_l(), "Min Vein Size", type.getMinVeinSize()).getInt());
            list.add(config.get("Ores." + type.func_176610_l(), "Max Vein Size", type.getMaxVeinSize()).getInt());
            list.add(config.get("Ores." + type.func_176610_l(), "Chance", type.getChance()).getInt());
            list.add(config.get("Ores." + type.func_176610_l(), "Min Y", type.getMinY()).getInt());
            list.add(config.get("Ores." + type.func_176610_l(), "Max Y", type.getMaxY()).getInt());
            oreSpawns.put(type, list);
        }
        config.save();
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            this.generateOverworld(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void generateOverworld(World world, Random random, int x, int y) {
        for (EnumMetalTypes type : oreSpawns.keySet()) {
            this.addOreSpawn(type.getId(), world, random, x, y, 16, 16, oreSpawns.get((Object)type).get(0) + random.nextInt(oreSpawns.get((Object)type).get(1) - oreSpawns.get((Object)type).get(0)), oreSpawns.get((Object)type).get(2), oreSpawns.get((Object)type).get(3), oreSpawns.get((Object)type).get(4));
        }
    }

    public void addOreSpawn(int meta, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chance, int minY, int maxY) {
        for (int i = 0; i < chance; ++i) {
            int posX = blockXPos + random.nextInt(maxX);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = blockZPos + random.nextInt(maxZ);
            WorldGenMinable wgm = new WorldGenMinable(LCBlocks.ore.func_176203_a(meta), maxVeinSize, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
            wgm.func_180709_b(world, random, new BlockPos(posX, posY, posZ));
            if (meta != 12) continue;
        }
    }
}

