/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.client.render;

import java.util.BitSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CustomBlockModelRenderer {
    public int brightness = 50;

    public boolean renderModel(IBlockAccess blockAccessIn, IBakedModel modelIn, IBlockState blockStateIn, BlockPos blockPosIn, WorldRenderer worldRendererIn) {
        Block block = blockStateIn.func_177230_c();
        block.func_180654_a(blockAccessIn, blockPosIn);
        return this.renderModel(blockAccessIn, modelIn, blockStateIn, blockPosIn, worldRendererIn, true);
    }

    public boolean renderModel(IBlockAccess blockAccessIn, IBakedModel modelIn, IBlockState blockStateIn, BlockPos blockPosIn, WorldRenderer worldRendererIn, boolean checkSides) {
        Block block = blockStateIn.func_177230_c();
        return this.renderModelStandard(blockAccessIn, modelIn, block, blockPosIn, worldRendererIn, checkSides);
    }

    public boolean renderModelAmbientOcclusion(IBlockAccess blockAccessIn, IBakedModel modelIn, Block blockIn, BlockPos blockPosIn, WorldRenderer worldRendererIn, boolean checkSides) {
        boolean flag = false;
        float[] afloat = new float[EnumFacing.values().length * 2];
        BitSet bitset = new BitSet(3);
        AmbientOcclusionFace blockmodelrenderer$ambientocclusionface = new AmbientOcclusionFace();
        for (EnumFacing enumfacing : EnumFacing.values()) {
            List list = modelIn.func_177551_a(enumfacing);
            if (list.isEmpty()) continue;
            BlockPos blockpos = blockPosIn.func_177972_a(enumfacing);
            if (checkSides && !blockIn.func_176225_a(blockAccessIn, blockpos, enumfacing)) continue;
            this.renderModelAmbientOcclusionQuads(blockAccessIn, blockIn, blockPosIn, worldRendererIn, list, afloat, bitset, blockmodelrenderer$ambientocclusionface);
            flag = true;
        }
        List list1 = modelIn.func_177550_a();
        if (list1.size() > 0) {
            this.renderModelAmbientOcclusionQuads(blockAccessIn, blockIn, blockPosIn, worldRendererIn, list1, afloat, bitset, blockmodelrenderer$ambientocclusionface);
            flag = true;
        }
        return flag;
    }

    public boolean renderModelStandard(IBlockAccess blockAccessIn, IBakedModel modelIn, Block blockIn, BlockPos blockPosIn, WorldRenderer worldRendererIn, boolean checkSides) {
        boolean flag = false;
        BitSet bitset = new BitSet(3);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            List list = modelIn.func_177551_a(enumfacing);
            if (list.isEmpty()) continue;
            BlockPos blockpos = blockPosIn.func_177972_a(enumfacing);
            if (checkSides && !blockIn.func_176225_a(blockAccessIn, blockpos, enumfacing)) continue;
            int i = blockIn.func_176207_c(blockAccessIn, blockpos);
            this.renderModelStandardQuads(blockAccessIn, blockIn, blockPosIn, enumfacing, i, false, worldRendererIn, list, bitset);
            flag = true;
        }
        List list1 = modelIn.func_177550_a();
        if (list1.size() > 0) {
            this.renderModelStandardQuads(blockAccessIn, blockIn, blockPosIn, null, -1, true, worldRendererIn, list1, bitset);
            flag = true;
        }
        return flag;
    }

    private void renderModelAmbientOcclusionQuads(IBlockAccess blockAccessIn, Block blockIn, BlockPos blockPosIn, WorldRenderer worldRendererIn, List<BakedQuad> listQuadsIn, float[] quadBounds, BitSet boundsFlags, AmbientOcclusionFace aoFaceIn) {
        double d0 = blockPosIn.func_177958_n();
        double d1 = blockPosIn.func_177956_o();
        double d2 = blockPosIn.func_177952_p();
        Block.EnumOffsetType block$enumoffsettype = blockIn.func_176218_Q();
        if (block$enumoffsettype != Block.EnumOffsetType.NONE) {
            long i = MathHelper.func_180186_a((Vec3i)blockPosIn);
            d0 += ((double)((float)(i >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
            d2 += ((double)((float)(i >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
            if (block$enumoffsettype == Block.EnumOffsetType.XYZ) {
                d1 += ((double)((float)(i >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
            }
        }
        for (BakedQuad bakedquad : listQuadsIn) {
            this.fillQuadBounds(blockIn, bakedquad.func_178209_a(), bakedquad.func_178210_d(), quadBounds, boundsFlags);
            aoFaceIn.updateVertexBrightness(blockAccessIn, blockIn, blockPosIn, bakedquad.func_178210_d(), quadBounds, boundsFlags);
            worldRendererIn.func_178981_a(bakedquad.func_178209_a());
            worldRendererIn.func_178962_a(aoFaceIn.vertexBrightness[0], aoFaceIn.vertexBrightness[1], aoFaceIn.vertexBrightness[2], aoFaceIn.vertexBrightness[3]);
            if (bakedquad.func_178212_b()) {
                int j = blockIn.func_180662_a(blockAccessIn, blockPosIn, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    j = TextureUtil.func_177054_c((int)j);
                }
                float f = (float)(j >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(j >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(j & 0xFF) / 255.0f;
                worldRendererIn.func_178978_a(aoFaceIn.vertexColorMultiplier[0] * f, aoFaceIn.vertexColorMultiplier[0] * f1, aoFaceIn.vertexColorMultiplier[0] * f2, 4);
                worldRendererIn.func_178978_a(aoFaceIn.vertexColorMultiplier[1] * f, aoFaceIn.vertexColorMultiplier[1] * f1, aoFaceIn.vertexColorMultiplier[1] * f2, 3);
                worldRendererIn.func_178978_a(aoFaceIn.vertexColorMultiplier[2] * f, aoFaceIn.vertexColorMultiplier[2] * f1, aoFaceIn.vertexColorMultiplier[2] * f2, 2);
                worldRendererIn.func_178978_a(aoFaceIn.vertexColorMultiplier[3] * f, aoFaceIn.vertexColorMultiplier[3] * f1, aoFaceIn.vertexColorMultiplier[3] * f2, 1);
            } else {
                worldRendererIn.func_178978_a(aoFaceIn.vertexColorMultiplier[0], aoFaceIn.vertexColorMultiplier[0], aoFaceIn.vertexColorMultiplier[0], 4);
                worldRendererIn.func_178978_a(aoFaceIn.vertexColorMultiplier[1], aoFaceIn.vertexColorMultiplier[1], aoFaceIn.vertexColorMultiplier[1], 3);
                worldRendererIn.func_178978_a(aoFaceIn.vertexColorMultiplier[2], aoFaceIn.vertexColorMultiplier[2], aoFaceIn.vertexColorMultiplier[2], 2);
                worldRendererIn.func_178978_a(aoFaceIn.vertexColorMultiplier[3], aoFaceIn.vertexColorMultiplier[3], aoFaceIn.vertexColorMultiplier[3], 1);
            }
            worldRendererIn.func_178987_a(d0, d1, d2);
        }
    }

    private void fillQuadBounds(Block blockIn, int[] vertexData, EnumFacing facingIn, float[] quadBounds, BitSet boundsFlags) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        for (int i = 0; i < 4; ++i) {
            float f6 = Float.intBitsToFloat(vertexData[i * 7]);
            float f7 = Float.intBitsToFloat(vertexData[i * 7 + 1]);
            float f8 = Float.intBitsToFloat(vertexData[i * 7 + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (quadBounds != null) {
            quadBounds[EnumFacing.WEST.func_176745_a()] = f;
            quadBounds[EnumFacing.EAST.func_176745_a()] = f3;
            quadBounds[EnumFacing.DOWN.func_176745_a()] = f1;
            quadBounds[EnumFacing.UP.func_176745_a()] = f4;
            quadBounds[EnumFacing.NORTH.func_176745_a()] = f2;
            quadBounds[EnumFacing.SOUTH.func_176745_a()] = f5;
            quadBounds[EnumFacing.WEST.func_176745_a() + EnumFacing.values().length] = 1.0f - f;
            quadBounds[EnumFacing.EAST.func_176745_a() + EnumFacing.values().length] = 1.0f - f3;
            quadBounds[EnumFacing.DOWN.func_176745_a() + EnumFacing.values().length] = 1.0f - f1;
            quadBounds[EnumFacing.UP.func_176745_a() + EnumFacing.values().length] = 1.0f - f4;
            quadBounds[EnumFacing.NORTH.func_176745_a() + EnumFacing.values().length] = 1.0f - f2;
            quadBounds[EnumFacing.SOUTH.func_176745_a() + EnumFacing.values().length] = 1.0f - f5;
        }
        switch (facingIn) {
            case DOWN: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f1 < 1.0E-4f || blockIn.func_149686_d()) && f1 == f4);
                break;
            }
            case UP: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f4 > 0.9999f || blockIn.func_149686_d()) && f1 == f4);
                break;
            }
            case NORTH: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, (f2 < 1.0E-4f || blockIn.func_149686_d()) && f2 == f5);
                break;
            }
            case SOUTH: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, (f5 > 0.9999f || blockIn.func_149686_d()) && f2 == f5);
                break;
            }
            case WEST: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f < 1.0E-4f || blockIn.func_149686_d()) && f == f3);
                break;
            }
            case EAST: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f3 > 0.9999f || blockIn.func_149686_d()) && f == f3);
            }
        }
    }

    private void renderModelStandardQuads(IBlockAccess blockAccessIn, Block blockIn, BlockPos blockPosIn, EnumFacing faceIn, int brightnessIn, boolean ownBrightness, WorldRenderer worldRendererIn, List<BakedQuad> listQuadsIn, BitSet boundsFlags) {
        double d0 = blockPosIn.func_177958_n();
        double d1 = blockPosIn.func_177956_o();
        double d2 = blockPosIn.func_177952_p();
        Block.EnumOffsetType block$enumoffsettype = blockIn.func_176218_Q();
        if (block$enumoffsettype != Block.EnumOffsetType.NONE) {
            int i = blockPosIn.func_177958_n();
            int j = blockPosIn.func_177952_p();
            long k = (long)(i * 3129871) ^ (long)j * 116129781L;
            k = k * k * 42317861L + k * 11L;
            d0 += ((double)((float)(k >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
            d2 += ((double)((float)(k >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
            if (block$enumoffsettype == Block.EnumOffsetType.XYZ) {
                d1 += ((double)((float)(k >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
            }
        }
        for (BakedQuad bakedquad : listQuadsIn) {
            if (ownBrightness) {
                this.fillQuadBounds(blockIn, bakedquad.func_178209_a(), bakedquad.func_178210_d(), null, boundsFlags);
                brightnessIn = boundsFlags.get(0) ? blockIn.func_176207_c(blockAccessIn, blockPosIn.func_177972_a(bakedquad.func_178210_d())) : blockIn.func_176207_c(blockAccessIn, blockPosIn);
            }
            brightnessIn = this.brightness;
            worldRendererIn.func_178981_a(bakedquad.func_178209_a());
            worldRendererIn.func_178962_a(brightnessIn, brightnessIn, brightnessIn, brightnessIn);
            if (bakedquad.func_178212_b()) {
                int l = blockIn.func_180662_a(blockAccessIn, blockPosIn, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    l = TextureUtil.func_177054_c((int)l);
                }
                float f = (float)(l >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(l & 0xFF) / 255.0f;
                worldRendererIn.func_178978_a(f, f1, f2, 4);
                worldRendererIn.func_178978_a(f, f1, f2, 3);
                worldRendererIn.func_178978_a(f, f1, f2, 2);
                worldRendererIn.func_178978_a(f, f1, f2, 1);
            }
            worldRendererIn.func_178987_a(d0, d1, d2);
        }
    }

    public void renderModelBrightnessColor(IBakedModel bakedModel, float p_178262_2_, float red, float green, float blue) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            this.renderModelBrightnessColorQuads(p_178262_2_, red, green, blue, bakedModel.func_177551_a(enumfacing));
        }
        this.renderModelBrightnessColorQuads(p_178262_2_, red, green, blue, bakedModel.func_177550_a());
    }

    public void renderModelBrightness(IBakedModel model, IBlockState p_178266_2_, float brightness, boolean p_178266_4_) {
        Block block = p_178266_2_.func_177230_c();
        block.func_149683_g();
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        int i = block.func_180644_h(block.func_176217_b(p_178266_2_));
        if (EntityRenderer.field_78517_a) {
            i = TextureUtil.func_177054_c((int)i);
        }
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        if (!p_178266_4_) {
            GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        }
        this.renderModelBrightnessColor(model, brightness, f, f1, f2);
    }

    private void renderModelBrightnessColorQuads(float brightness, float red, float green, float blue, List<BakedQuad> listQuads) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        for (BakedQuad bakedquad : listQuads) {
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            worldrenderer.func_178981_a(bakedquad.func_178209_a());
            if (bakedquad.func_178212_b()) {
                worldrenderer.func_178990_f(red * brightness, green * brightness, blue * brightness);
            } else {
                worldrenderer.func_178990_f(brightness, brightness, brightness);
            }
            Vec3i vec3i = bakedquad.func_178210_d().func_176730_m();
            worldrenderer.func_178975_e((float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p());
            tessellator.func_78381_a();
        }
    }

    @SideOnly(value=Side.CLIENT)
    static enum VertexTranslations {
        DOWN(0, 1, 2, 3),
        UP(2, 3, 0, 1),
        NORTH(3, 0, 1, 2),
        SOUTH(0, 1, 2, 3),
        WEST(3, 0, 1, 2),
        EAST(1, 2, 3, 0);

        private final int field_178191_g;
        private final int field_178200_h;
        private final int field_178201_i;
        private final int field_178198_j;
        private static final VertexTranslations[] VALUES;

        private VertexTranslations(int p_i46234_3_, int p_i46234_4_, int p_i46234_5_, int p_i46234_6_) {
            this.field_178191_g = p_i46234_3_;
            this.field_178200_h = p_i46234_4_;
            this.field_178201_i = p_i46234_5_;
            this.field_178198_j = p_i46234_6_;
        }

        public static VertexTranslations getVertexTranslations(EnumFacing p_178184_0_) {
            return VALUES[p_178184_0_.func_176745_a()];
        }

        static {
            VALUES = new VertexTranslations[6];
            VertexTranslations.VALUES[EnumFacing.DOWN.func_176745_a()] = DOWN;
            VertexTranslations.VALUES[EnumFacing.UP.func_176745_a()] = UP;
            VertexTranslations.VALUES[EnumFacing.NORTH.func_176745_a()] = NORTH;
            VertexTranslations.VALUES[EnumFacing.SOUTH.func_176745_a()] = SOUTH;
            VertexTranslations.VALUES[EnumFacing.WEST.func_176745_a()] = WEST;
            VertexTranslations.VALUES[EnumFacing.EAST.func_176745_a()] = EAST;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static enum Orientation {
        DOWN(EnumFacing.DOWN, false),
        UP(EnumFacing.UP, false),
        NORTH(EnumFacing.NORTH, false),
        SOUTH(EnumFacing.SOUTH, false),
        WEST(EnumFacing.WEST, false),
        EAST(EnumFacing.EAST, false),
        FLIP_DOWN(EnumFacing.DOWN, true),
        FLIP_UP(EnumFacing.UP, true),
        FLIP_NORTH(EnumFacing.NORTH, true),
        FLIP_SOUTH(EnumFacing.SOUTH, true),
        FLIP_WEST(EnumFacing.WEST, true),
        FLIP_EAST(EnumFacing.EAST, true);

        protected final int field_178229_m;

        private Orientation(EnumFacing p_i46233_3_, boolean p_i46233_4_) {
            this.field_178229_m = p_i46233_3_.func_176745_a() + (p_i46233_4_ ? EnumFacing.values().length : 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static enum EnumNeighborInfo {
        DOWN(new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.5f, true, new Orientation[]{Orientation.FLIP_WEST, Orientation.SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_WEST, Orientation.NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.SOUTH}),
        UP(new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH}, 1.0f, true, new Orientation[]{Orientation.EAST, Orientation.SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.SOUTH}, new Orientation[]{Orientation.EAST, Orientation.NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.SOUTH}),
        NORTH(new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST}),
        SOUTH(new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.UP}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.UP, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.DOWN, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.DOWN, Orientation.EAST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.UP, Orientation.EAST}),
        WEST(new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.6f, true, new Orientation[]{Orientation.UP, Orientation.SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.SOUTH}, new Orientation[]{Orientation.UP, Orientation.NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.SOUTH}),
        EAST(new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.6f, true, new Orientation[]{Orientation.FLIP_DOWN, Orientation.SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_DOWN, Orientation.NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.SOUTH});

        protected final EnumFacing[] field_178276_g;
        protected final float field_178288_h;
        protected final boolean field_178289_i;
        protected final Orientation[] field_178286_j;
        protected final Orientation[] field_178287_k;
        protected final Orientation[] field_178284_l;
        protected final Orientation[] field_178285_m;
        private static final EnumNeighborInfo[] VALUES;

        private EnumNeighborInfo(EnumFacing[] p_i46236_3_, float p_i46236_4_, boolean p_i46236_5_, Orientation[] p_i46236_6_, Orientation[] p_i46236_7_, Orientation[] p_i46236_8_, Orientation[] p_i46236_9_) {
            this.field_178276_g = p_i46236_3_;
            this.field_178288_h = p_i46236_4_;
            this.field_178289_i = p_i46236_5_;
            this.field_178286_j = p_i46236_6_;
            this.field_178287_k = p_i46236_7_;
            this.field_178284_l = p_i46236_8_;
            this.field_178285_m = p_i46236_9_;
        }

        public static EnumNeighborInfo getNeighbourInfo(EnumFacing p_178273_0_) {
            return VALUES[p_178273_0_.func_176745_a()];
        }

        static {
            VALUES = new EnumNeighborInfo[6];
            EnumNeighborInfo.VALUES[EnumFacing.DOWN.func_176745_a()] = DOWN;
            EnumNeighborInfo.VALUES[EnumFacing.UP.func_176745_a()] = UP;
            EnumNeighborInfo.VALUES[EnumFacing.NORTH.func_176745_a()] = NORTH;
            EnumNeighborInfo.VALUES[EnumFacing.SOUTH.func_176745_a()] = SOUTH;
            EnumNeighborInfo.VALUES[EnumFacing.WEST.func_176745_a()] = WEST;
            EnumNeighborInfo.VALUES[EnumFacing.EAST.func_176745_a()] = EAST;
        }
    }

    @SideOnly(value=Side.CLIENT)
    class AmbientOcclusionFace {
        private final float[] vertexColorMultiplier = new float[4];
        private final int[] vertexBrightness = new int[4];

        AmbientOcclusionFace() {
        }

        public void updateVertexBrightness(IBlockAccess blockAccessIn, Block blockIn, BlockPos blockPosIn, EnumFacing facingIn, float[] quadBounds, BitSet boundsFlags) {
            int l1;
            float f7;
            int k1;
            float f6;
            int j1;
            float f5;
            int i1;
            float f4;
            BlockPos blockpos = boundsFlags.get(0) ? blockPosIn.func_177972_a(facingIn) : blockPosIn;
            EnumNeighborInfo blockmodelrenderer$enumneighborinfo = EnumNeighborInfo.getNeighbourInfo(facingIn);
            BlockPos blockpos1 = blockpos.func_177972_a(blockmodelrenderer$enumneighborinfo.field_178276_g[0]);
            BlockPos blockpos2 = blockpos.func_177972_a(blockmodelrenderer$enumneighborinfo.field_178276_g[1]);
            BlockPos blockpos3 = blockpos.func_177972_a(blockmodelrenderer$enumneighborinfo.field_178276_g[2]);
            BlockPos blockpos4 = blockpos.func_177972_a(blockmodelrenderer$enumneighborinfo.field_178276_g[3]);
            int i = blockIn.func_176207_c(blockAccessIn, blockpos1);
            int j = blockIn.func_176207_c(blockAccessIn, blockpos2);
            int k = blockIn.func_176207_c(blockAccessIn, blockpos3);
            int l = blockIn.func_176207_c(blockAccessIn, blockpos4);
            float f = blockAccessIn.func_180495_p(blockpos1).func_177230_c().func_149685_I();
            float f1 = blockAccessIn.func_180495_p(blockpos2).func_177230_c().func_149685_I();
            float f2 = blockAccessIn.func_180495_p(blockpos3).func_177230_c().func_149685_I();
            float f3 = blockAccessIn.func_180495_p(blockpos4).func_177230_c().func_149685_I();
            boolean flag = blockAccessIn.func_180495_p(blockpos1.func_177972_a(facingIn)).func_177230_c().func_149751_l();
            boolean flag1 = blockAccessIn.func_180495_p(blockpos2.func_177972_a(facingIn)).func_177230_c().func_149751_l();
            boolean flag2 = blockAccessIn.func_180495_p(blockpos3.func_177972_a(facingIn)).func_177230_c().func_149751_l();
            boolean flag3 = blockAccessIn.func_180495_p(blockpos4.func_177972_a(facingIn)).func_177230_c().func_149751_l();
            if (!flag2 && !flag) {
                f4 = f;
                i1 = i;
            } else {
                BlockPos blockpos5 = blockpos1.func_177972_a(blockmodelrenderer$enumneighborinfo.field_178276_g[2]);
                f4 = blockAccessIn.func_180495_p(blockpos5).func_177230_c().func_149685_I();
                i1 = blockIn.func_176207_c(blockAccessIn, blockpos5);
            }
            if (!flag3 && !flag) {
                f5 = f;
                j1 = i;
            } else {
                BlockPos blockpos6 = blockpos1.func_177972_a(blockmodelrenderer$enumneighborinfo.field_178276_g[3]);
                f5 = blockAccessIn.func_180495_p(blockpos6).func_177230_c().func_149685_I();
                j1 = blockIn.func_176207_c(blockAccessIn, blockpos6);
            }
            if (!flag2 && !flag1) {
                f6 = f1;
                k1 = j;
            } else {
                BlockPos blockpos7 = blockpos2.func_177972_a(blockmodelrenderer$enumneighborinfo.field_178276_g[2]);
                f6 = blockAccessIn.func_180495_p(blockpos7).func_177230_c().func_149685_I();
                k1 = blockIn.func_176207_c(blockAccessIn, blockpos7);
            }
            if (!flag3 && !flag1) {
                f7 = f1;
                l1 = j;
            } else {
                BlockPos blockpos8 = blockpos2.func_177972_a(blockmodelrenderer$enumneighborinfo.field_178276_g[3]);
                f7 = blockAccessIn.func_180495_p(blockpos8).func_177230_c().func_149685_I();
                l1 = blockIn.func_176207_c(blockAccessIn, blockpos8);
            }
            int i3 = blockIn.func_176207_c(blockAccessIn, blockPosIn);
            if (boundsFlags.get(0) || !blockAccessIn.func_180495_p(blockPosIn.func_177972_a(facingIn)).func_177230_c().func_149662_c()) {
                i3 = blockIn.func_176207_c(blockAccessIn, blockPosIn.func_177972_a(facingIn));
            }
            float f8 = boundsFlags.get(0) ? blockAccessIn.func_180495_p(blockpos).func_177230_c().func_149685_I() : blockAccessIn.func_180495_p(blockPosIn).func_177230_c().func_149685_I();
            VertexTranslations blockmodelrenderer$vertextranslations = VertexTranslations.getVertexTranslations(facingIn);
            if (boundsFlags.get(1) && blockmodelrenderer$enumneighborinfo.field_178289_i) {
                float f29 = (f3 + f + f5 + f8) * 0.25f;
                float f30 = (f2 + f + f4 + f8) * 0.25f;
                float f31 = (f2 + f1 + f6 + f8) * 0.25f;
                float f32 = (f3 + f1 + f7 + f8) * 0.25f;
                float f13 = quadBounds[blockmodelrenderer$enumneighborinfo.field_178286_j[0].field_178229_m] * quadBounds[blockmodelrenderer$enumneighborinfo.field_178286_j[1].field_178229_m];
                float f14 = quadBounds[blockmodelrenderer$enumneighborinfo.field_178286_j[2].field_178229_m] * quadBounds[blockmodelrenderer$enumneighborinfo.field_178286_j[3].field_178229_m];
                float f15 = quadBounds[blockmodelrenderer$enumneighborinfo.field_178286_j[4].field_178229_m] * quadBounds[blockmodelrenderer$enumneighborinfo.field_178286_j[5].field_178229_m];
                float f16 = quadBounds[blockmodelrenderer$enumneighborinfo.field_178286_j[6].field_178229_m] * quadBounds[blockmodelrenderer$enumneighborinfo.field_178286_j[7].field_178229_m];
                float f17 = quadBounds[blockmodelrenderer$enumneighborinfo.field_178287_k[0].field_178229_m] * quadBounds[blockmodelrenderer$enumneighborinfo.field_178287_k[1].field_178229_m];
                float f18 = quadBounds[blockmodelrenderer$enumneighborinfo.field_178287_k[2].field_178229_m] * quadBounds[blockmodelrenderer$enumneighborinfo.field_178287_k[3].field_178229_m];
                float f19 = quadBounds[blockmodelrenderer$enumneighborinfo.field_178287_k[4].field_178229_m] * quadBounds[blockmodelrenderer$enumneighborinfo.field_178287_k[5].field_178229_m];
                float f20 = quadBounds[blockmodelrenderer$enumneighborinfo.field_178287_k[6].field_178229_m] * quadBounds[blockmodelrenderer$enumneighborinfo.field_178287_k[7].field_178229_m];
                float f21 = quadBounds[blockmodelrenderer$enumneighborinfo.field_178284_l[0].field_178229_m] * quadBounds[blockmodelrenderer$enumneighborinfo.field_178284_l[1].field_178229_m];
                float f22 = quadBounds[blockmodelrenderer$enumneighborinfo.field_178284_l[2].field_178229_m] * quadBounds[blockmodelrenderer$enumneighborinfo.field_178284_l[3].field_178229_m];
                float f23 = quadBounds[blockmodelrenderer$enumneighborinfo.field_178284_l[4].field_178229_m] * quadBounds[blockmodelrenderer$enumneighborinfo.field_178284_l[5].field_178229_m];
                float f24 = quadBounds[blockmodelrenderer$enumneighborinfo.field_178284_l[6].field_178229_m] * quadBounds[blockmodelrenderer$enumneighborinfo.field_178284_l[7].field_178229_m];
                float f25 = quadBounds[blockmodelrenderer$enumneighborinfo.field_178285_m[0].field_178229_m] * quadBounds[blockmodelrenderer$enumneighborinfo.field_178285_m[1].field_178229_m];
                float f26 = quadBounds[blockmodelrenderer$enumneighborinfo.field_178285_m[2].field_178229_m] * quadBounds[blockmodelrenderer$enumneighborinfo.field_178285_m[3].field_178229_m];
                float f27 = quadBounds[blockmodelrenderer$enumneighborinfo.field_178285_m[4].field_178229_m] * quadBounds[blockmodelrenderer$enumneighborinfo.field_178285_m[5].field_178229_m];
                float f28 = quadBounds[blockmodelrenderer$enumneighborinfo.field_178285_m[6].field_178229_m] * quadBounds[blockmodelrenderer$enumneighborinfo.field_178285_m[7].field_178229_m];
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = f29 * f13 + f30 * f14 + f31 * f15 + f32 * f16;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = f29 * f17 + f30 * f18 + f31 * f19 + f32 * f20;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = f29 * f21 + f30 * f22 + f31 * f23 + f32 * f24;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = f29 * f25 + f30 * f26 + f31 * f27 + f32 * f28;
                int i2 = this.getAoBrightness(l, i, j1, i3);
                int j2 = this.getAoBrightness(k, i, i1, i3);
                int k2 = this.getAoBrightness(k, j, k1, i3);
                int l2 = this.getAoBrightness(l, j, l1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = this.getVertexBrightness(i2, j2, k2, l2, f13, f14, f15, f16);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = this.getVertexBrightness(i2, j2, k2, l2, f17, f18, f19, f20);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = this.getVertexBrightness(i2, j2, k2, l2, f21, f22, f23, f24);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = this.getVertexBrightness(i2, j2, k2, l2, f25, f26, f27, f28);
            } else {
                float f9 = (f3 + f + f5 + f8) * 0.25f;
                float f10 = (f2 + f + f4 + f8) * 0.25f;
                float f11 = (f2 + f1 + f6 + f8) * 0.25f;
                float f12 = (f3 + f1 + f7 + f8) * 0.25f;
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = this.getAoBrightness(l, i, j1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = this.getAoBrightness(k, i, i1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = this.getAoBrightness(k, j, k1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = this.getAoBrightness(l, j, l1, i3);
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = f9;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = f10;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = f11;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = f12;
            }
        }

        private int getAoBrightness(int br1, int br2, int br3, int br4) {
            if (br1 == 0) {
                br1 = br4;
            }
            if (br2 == 0) {
                br2 = br4;
            }
            if (br3 == 0) {
                br3 = br4;
            }
            return br1 + br2 + br3 + br4 >> 2 & 0xFF00FF;
        }

        private int getVertexBrightness(int p_178203_1_, int p_178203_2_, int p_178203_3_, int p_178203_4_, float p_178203_5_, float p_178203_6_, float p_178203_7_, float p_178203_8_) {
            int i = (int)((float)(p_178203_1_ >> 16 & 0xFF) * p_178203_5_ + (float)(p_178203_2_ >> 16 & 0xFF) * p_178203_6_ + (float)(p_178203_3_ >> 16 & 0xFF) * p_178203_7_ + (float)(p_178203_4_ >> 16 & 0xFF) * p_178203_8_) & 0xFF;
            int j = (int)((float)(p_178203_1_ & 0xFF) * p_178203_5_ + (float)(p_178203_2_ & 0xFF) * p_178203_6_ + (float)(p_178203_3_ & 0xFF) * p_178203_7_ + (float)(p_178203_4_ & 0xFF) * p_178203_8_) & 0xFF;
            return i << 16 | j;
        }
    }
}

