/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.client.render;

import com.google.common.collect.Maps;
import java.util.Map;
import lucraft.mods.lucraftcore.client.render.RenderArmor;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerAlphaBipedArmor<T extends ModelBase>
implements LayerRenderer<EntityLivingBase> {
    protected static final ResourceLocation ENCHANTED_ITEM_GLINT_RES = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    protected T field_177189_c;
    protected T field_177186_d;
    private final RenderArmor renderer;
    private float colorR = 1.0f;
    private float colorG = 1.0f;
    private float colorB = 1.0f;
    private boolean field_177193_i;
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();

    public LayerAlphaBipedArmor(RenderArmor rendererIn) {
        this.renderer = rendererIn;
        this.initArmor();
    }

    protected void initArmor() {
        this.field_177189_c = new ModelBiped(0.5f);
        this.field_177186_d = new ModelBiped(1.0f);
    }

    protected void func_177179_a(ModelBiped p_177179_1_, int p_177179_2_) {
        this.func_177194_a(p_177179_1_);
        switch (p_177179_2_) {
            case 1: {
                p_177179_1_.field_178721_j.field_78806_j = true;
                p_177179_1_.field_178722_k.field_78806_j = true;
                break;
            }
            case 2: {
                p_177179_1_.field_78115_e.field_78806_j = true;
                p_177179_1_.field_178721_j.field_78806_j = true;
                p_177179_1_.field_178722_k.field_78806_j = true;
                break;
            }
            case 3: {
                p_177179_1_.field_78115_e.field_78806_j = true;
                p_177179_1_.field_178723_h.field_78806_j = true;
                p_177179_1_.field_178724_i.field_78806_j = true;
                break;
            }
            case 4: {
                p_177179_1_.field_78116_c.field_78806_j = true;
                p_177179_1_.field_178720_f.field_78806_j = true;
            }
        }
    }

    protected void func_177194_a(ModelBiped p_177194_1_) {
        p_177194_1_.func_178719_a(false);
    }

    protected ModelBiped getArmorModelHook(EntityLivingBase entity, ItemStack itemStack, int slot, ModelBiped model) {
        return ForgeHooksClient.getArmorModel((EntityLivingBase)entity, (ItemStack)itemStack, (int)slot, (ModelBiped)model);
    }

    public void func_177141_a(EntityLivingBase entitylivingbaseIn, float p_177141_2_, float p_177141_3_, float partialTicks, float p_177141_5_, float p_177141_6_, float p_177141_7_, float scale) {
        this.renderLayer(entitylivingbaseIn, p_177141_2_, p_177141_3_, partialTicks, p_177141_5_, p_177141_6_, p_177141_7_, scale, 4);
        this.renderLayer(entitylivingbaseIn, p_177141_2_, p_177141_3_, partialTicks, p_177141_5_, p_177141_6_, p_177141_7_, scale, 3);
        this.renderLayer(entitylivingbaseIn, p_177141_2_, p_177141_3_, partialTicks, p_177141_5_, p_177141_6_, p_177141_7_, scale, 2);
        this.renderLayer(entitylivingbaseIn, p_177141_2_, p_177141_3_, partialTicks, p_177141_5_, p_177141_6_, p_177141_7_, scale, 1);
    }

    public boolean func_177142_b() {
        return false;
    }

    private void renderLayer(EntityLivingBase entitylivingbaseIn, float p_177182_2_, float p_177182_3_, float p_177182_4_, float p_177182_5_, float p_177182_6_, float p_177182_7_, float p_177182_8_, int armorSlot) {
        ItemStack itemstack = this.getCurrentArmor(entitylivingbaseIn, armorSlot);
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemArmor) {
            ItemArmor itemarmor = (ItemArmor)itemstack.func_77973_b();
            Object t = this.func_177175_a(armorSlot);
            t.func_178686_a((ModelBase)this.renderer.getMainModel());
            t.func_78086_a(entitylivingbaseIn, p_177182_2_, p_177182_3_, p_177182_4_);
            t = this.getArmorModelHook(entitylivingbaseIn, itemstack, armorSlot, (ModelBiped)t);
            this.func_177179_a((ModelBiped)t, armorSlot);
            boolean flag = this.isSlotForLeggings(armorSlot);
            this.renderer.func_110776_a(this.getArmorResource((Entity)entitylivingbaseIn, itemstack, flag ? 2 : 1, null));
            int i = itemarmor.func_82814_b(itemstack);
            if (i != -1) {
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)(this.colorR * f), (float)(this.colorG * f1), (float)(this.colorB * f2), (float)this.renderer.alpha);
                t.func_78088_a((Entity)entitylivingbaseIn, p_177182_2_, p_177182_3_, p_177182_5_, p_177182_6_, p_177182_7_, p_177182_8_);
                this.renderer.func_110776_a(this.getArmorResource((Entity)entitylivingbaseIn, itemstack, flag ? 2 : 1, "overlay"));
            }
            GlStateManager.func_179131_c((float)this.colorR, (float)this.colorG, (float)this.colorB, (float)this.renderer.alpha);
            t.func_78088_a((Entity)entitylivingbaseIn, p_177182_2_, p_177182_3_, p_177182_5_, p_177182_6_, p_177182_7_, p_177182_8_);
            if (!this.field_177193_i && itemstack.func_77962_s()) {
                this.func_177183_a(entitylivingbaseIn, t, p_177182_2_, p_177182_3_, p_177182_4_, p_177182_5_, p_177182_6_, p_177182_7_, p_177182_8_);
            }
        }
    }

    public ItemStack getCurrentArmor(EntityLivingBase entitylivingbaseIn, int armorSlot) {
        return entitylivingbaseIn.func_82169_q(armorSlot - 1);
    }

    public T func_177175_a(int p_177175_1_) {
        return this.isSlotForLeggings(p_177175_1_) ? this.field_177189_c : this.field_177186_d;
    }

    private boolean isSlotForLeggings(int armorSlot) {
        return armorSlot == 2;
    }

    private void func_177183_a(EntityLivingBase entitylivingbaseIn, T modelbaseIn, float p_177183_3_, float p_177183_4_, float p_177183_5_, float p_177183_6_, float p_177183_7_, float p_177183_8_, float p_177183_9_) {
        float f = (float)entitylivingbaseIn.field_70173_aa + p_177183_5_;
        this.renderer.func_110776_a(ENCHANTED_ITEM_GLINT_RES);
        GlStateManager.func_179147_l();
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179132_a((boolean)false);
        float f1 = 0.5f;
        GlStateManager.func_179131_c((float)f1, (float)f1, (float)f1, (float)1.0f);
        for (int i = 0; i < 2; ++i) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179112_b((int)768, (int)1);
            float f2 = 0.76f;
            GlStateManager.func_179131_c((float)(0.5f * f2), (float)(0.25f * f2), (float)(0.8f * f2), (float)1.0f);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            float f3 = 0.33333334f;
            GlStateManager.func_179152_a((float)f3, (float)f3, (float)f3);
            GlStateManager.func_179114_b((float)(30.0f - (float)i * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(f * (0.001f + (float)i * 0.003f) * 20.0f), (float)0.0f);
            GlStateManager.func_179128_n((int)5888);
            modelbaseIn.func_78088_a((Entity)entitylivingbaseIn, p_177183_3_, p_177183_4_, p_177183_6_, p_177183_7_, p_177183_8_, p_177183_9_);
        }
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179145_e();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179084_k();
    }

    @Deprecated
    private ResourceLocation getArmorResource(ItemArmor p_177181_1_, boolean p_177181_2_) {
        return this.getArmorResource(p_177181_1_, p_177181_2_, null);
    }

    @Deprecated
    private ResourceLocation getArmorResource(ItemArmor p_177178_1_, boolean p_177178_2_, String p_177178_3_) {
        String s = String.format("textures/models/armor/%s_layer_%d%s.png", p_177178_1_.func_82812_d().func_179242_c(), p_177178_2_ ? 2 : 1, p_177178_3_ == null ? "" : String.format("_%s", p_177178_3_));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s);
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s);
            ARMOR_TEXTURE_RES_MAP.put(s, resourcelocation);
        }
        return resourcelocation;
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, int slot, String type) {
        ItemArmor item = (ItemArmor)stack.func_77973_b();
        String texture = item.func_82812_d().func_179242_c();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, slot == 2 ? 2 : 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (int)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

