/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.entity;

import lucraft.mods.lucraftcore.network.MessageSyncPlayerData;
import lucraft.mods.lucraftcore.network.PacketDispatcher;
import lucraft.mods.lucraftcore.superpower.Superpower;
import lucraft.mods.lucraftcore.superpower.SuperpowerHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SuperpowerPlayerData
implements IExtendedEntityProperties {
    public static final String EXT_PROP_NAME = "LucraftCore";
    public final EntityPlayer player;
    private Superpower superpower;
    public int updateCooldown = 20;

    public SuperpowerPlayerData(EntityPlayer player) {
        this.player = player;
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new SuperpowerPlayerData(player));
    }

    public static final SuperpowerPlayerData get(EntityPlayer player) {
        return (SuperpowerPlayerData)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public void saveNBTData(NBTTagCompound compound) {
        String sp = "";
        if (this.superpower != null) {
            sp = this.superpower.getUnlocalizedName();
        }
        compound.func_74778_a("superpower", sp);
    }

    public void loadNBTData(NBTTagCompound compound) {
        String sp = compound.func_74779_i("superpower");
        this.superpower = SuperpowerHandler.getSuperpowerFromName(sp);
    }

    public Superpower getSuperpower() {
        return this.superpower;
    }

    public boolean hasSuperpower() {
        return this.superpower != null;
    }

    public void removeSuperpower() {
        if (this.superpower != null) {
            this.superpower.removePower(this.player);
            this.superpower = null;
            this.sendDataToPlayer();
        }
    }

    public void setSuperpower(Superpower power) {
        if (this.superpower != null) {
            this.superpower.removePower(this.player);
        }
        this.superpower = power;
        this.superpower.applyPower(this.player);
        this.sendDataToPlayer();
    }

    public void onUpdate(TickEvent.Phase phase) {
        if (phase == TickEvent.Phase.END && this.updateCooldown > 0) {
            this.sendDataToAllPlayers();
            --this.updateCooldown;
        }
    }

    public void init(Entity entity, World world) {
    }

    public void sendDataToPlayer() {
        this.sendDataToPlayer(this.player);
    }

    public void sendDataToPlayer(EntityPlayer toPlayer) {
        if (toPlayer instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new MessageSyncPlayerData(this.player), (EntityPlayerMP)toPlayer);
        }
    }

    public void sendDataToAllPlayers() {
        PacketDispatcher.sendToAllAround(new MessageSyncPlayerData(this.player), this.player, 100.0);
    }
}

