/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.recipes;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import lucraft.mods.lucraftcore.EnumMetalTypes;
import lucraft.mods.lucraftcore.blocks.LCBlocks;
import lucraft.mods.lucraftcore.items.LCItems;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class LucraftCoreRecipes {
    private static Map<ItemStack, ItemStack> pulverizerList = Maps.newHashMap();
    private static Map<ItemStack, Float> pulverizerExperienceList = Maps.newHashMap();
    private static Map<ItemStack, ItemStack> compressorList = Maps.newHashMap();
    private static Map<ItemStack, Float> compressorExperienceList = Maps.newHashMap();

    public static void init() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(LCItems.hammer, new Object[]{" XX", "SSX", " XX", Character.valueOf('X'), "ingotIron", Character.valueOf('S'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(LCBlocks.pulverizer, new Object[]{"XXX", "XFX", "XXX", Character.valueOf('X'), "plateIron", Character.valueOf('F'), Items.field_151145_ak}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(LCBlocks.compressor, new Object[]{"XXX", "PIP", "XXX", Character.valueOf('X'), "plateIron", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('I'), "ingotIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(LCBlocks.suitMaker, new Object[]{"PP ", "IAR", "PPP", Character.valueOf('P'), "plateOsmium", Character.valueOf('A'), Items.field_179565_cj, Character.valueOf('I'), "ingotOsmium", Character.valueOf('R'), "blockRedstone"}));
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(LCItems.heroGuide), (Object[])new Object[]{new ItemStack(LCItems.hammer, 1, Short.MAX_VALUE), Items.field_151122_aG});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(LCItems.syringe, new Object[]{"  N", "IP ", "PI ", Character.valueOf('P'), "plateTin", Character.valueOf('N'), "nuggetSilver", Character.valueOf('I'), "ingotIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(LCItems.antiSuperpowerSerum, new Object[]{LCItems.syringe, new ItemStack((Item)Items.field_151068_bn, 1, 8197), Items.field_151073_bk, new ItemStack(Items.field_151100_aR, 1, 15)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(LCItems.superpowerCapsule, new Object[]{" DS", "DGO", "GO ", Character.valueOf('D'), "plateDwarfStarAlloy", Character.valueOf('S'), LCItems.syringe, Character.valueOf('G'), "blockGlass", Character.valueOf('O'), "plateOsmium"}));
        for (int i = 0; i < 16; ++i) {
            String s = EnumDyeColor.func_176764_b((int)(15 - i)).func_176610_l();
            String dye = "dye" + s.substring(0, 1).toUpperCase() + s.substring(1);
            if (dye.toLowerCase().contains("light_blue")) {
                dye = "dyeLightBlue";
            }
            if (dye.toLowerCase().contains("silver")) {
                dye = "dyeLightGray";
            }
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(LCItems.triPolymer, 2, i), new Object[]{"plateIron", dye, Items.field_151116_aA}));
        }
        for (EnumMetalTypes type : EnumMetalTypes.values()) {
            LucraftCoreUtil.addOreDictionaryMetalFurnaceRecipe(type, 1.0f);
            LucraftCoreUtil.registerStorageBlockRecipe(type);
            LucraftCoreUtil.registerNuggetRecipe(type);
            LucraftCoreUtil.addOreDictionaryMetalPulverizerRecipe(type, 1.0f);
            LucraftCoreUtil.addMetalPlateRecipe(type);
        }
        LucraftCoreUtil.addOreDictionaryMetalPulverizerRecipe("Aluminum", false, 1.0f);
        LucraftCoreUtil.addMetalPlateRecipe("Aluminum", 10.0f);
        LucraftCoreUtil.addOreDictionaryMetalPulverizerRecipe("Uranium", false, 1.0f);
        LucraftCoreUtil.addMetalPlateRecipe("Uranium", 10.0f);
        LucraftCoreUtil.addOreDictionaryMetalPulverizerRecipe("Constantan", false, 1.0f);
        LucraftCoreUtil.addMetalPlateRecipe("Constantan", 10.0f);
        LucraftCoreUtil.addOreDictionaryMetalPulverizerRecipe("Electrum", true, 1.0f);
        LucraftCoreUtil.addMetalPlateRecipe("Electrum", 10.0f);
        LucraftCoreUtil.addOreDictionaryMetalPulverizerRecipe("Steel", true, 1.0f);
        LucraftCoreUtil.addMetalPlateRecipe("Steel", 14.0f);
        LucraftCoreUtil.addOreDictionaryMetalPulverizerRecipe("Cobalt", false, 1.0f);
        LucraftCoreUtil.addMetalPlateRecipe("Cobalt", 10.0f);
        LucraftCoreUtil.addOreDictionaryMetalPulverizerRecipe("Ardite", false, 1.0f);
        LucraftCoreUtil.addMetalPlateRecipe("Ardite", 10.0f);
        LucraftCoreUtil.addOreDictionaryMetalPulverizerRecipe("Manyullyn", true, 1.0f);
        LucraftCoreUtil.addMetalPlateRecipe("Manyullyn", 10.0f);
        LucraftCoreUtil.addOreDictionaryMetalFurnaceRecipe("Iron", false, 1.0f);
        LucraftCoreUtil.registerNuggetRecipe("Iron");
        LucraftCoreUtil.addOreDictionaryMetalPulverizerRecipe("Iron", false, 1.0f);
        LucraftCoreUtil.addMetalPlateRecipe("Iron", 10.0f);
        LucraftCoreUtil.addOreDictionaryMetalFurnaceRecipe("Gold", false, 1.0f);
        LucraftCoreUtil.addOreDictionaryMetalPulverizerRecipe("Gold", false, 1.0f);
        LucraftCoreUtil.addMetalPlateRecipe("Gold", 8.0f);
        LucraftCoreRecipes.initAlloyRecipes();
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Blocks.field_150369_x), new ItemStack(Items.field_151100_aR, 9, 4), 1.0f);
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Blocks.field_150482_ag), new ItemStack(Items.field_151045_i, 2), 1.0f);
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Blocks.field_150450_ax), new ItemStack(Items.field_151137_ax, 6), 1.0f);
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Blocks.field_150412_bA), new ItemStack(Items.field_151166_bC, 2), 1.0f);
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Blocks.field_150449_bY), new ItemStack(Items.field_151128_bU, 3), 1.0f);
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Blocks.field_150365_q), new ItemStack(Items.field_151044_h, 4), 1.0f);
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Items.field_179562_cC), new ItemStack(Items.field_179563_cD), 1.0f);
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Blocks.field_150482_ag), new ItemStack(Items.field_151045_i, 2), 1.0f);
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Blocks.field_150347_e), new ItemStack((Block)Blocks.field_150354_m), 1.0f);
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Blocks.field_150351_n), new ItemStack((Block)Blocks.field_150354_m), 1.0f);
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Blocks.field_150359_w), new ItemStack((Block)Blocks.field_150354_m), 1.0f);
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Blocks.field_150417_aV, 1, 0), new ItemStack(Blocks.field_150417_aV, 1, 2), 1.0f);
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Blocks.field_150322_A), new ItemStack((Block)Blocks.field_150354_m, 2), 1.0f);
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Blocks.field_180395_cM), new ItemStack((Block)Blocks.field_150354_m, 2, 1), 1.0f);
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE), new ItemStack(Items.field_151007_F, 4), 1.0f);
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151100_aR, 6, 15), 1.0f);
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Blocks.field_150426_aN), new ItemStack(Items.field_151114_aO, 4), 1.0f);
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Blocks.field_150371_ca), new ItemStack(Items.field_151128_bU, 4), 1.0f);
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Items.field_151120_aE), new ItemStack(Items.field_151102_aT, 4), 1.0f);
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(Items.field_151072_bj), new ItemStack(Items.field_151065_br, 4), 1.0f);
        LucraftCoreRecipes.addCompressorRecipe(new ItemStack((Block)Blocks.field_150354_m, 2), new ItemStack(Blocks.field_150322_A), 1.0f);
        LucraftCoreRecipes.addCompressorRecipe(new ItemStack((Block)Blocks.field_150354_m, 2, 1), new ItemStack(Blocks.field_180395_cM), 1.0f);
        LucraftCoreRecipes.addCompressorRecipe(new ItemStack(Items.field_151126_ay, 4), new ItemStack(Blocks.field_150432_aD), 1.0f);
        LucraftCoreRecipes.addCompressorRecipe(new ItemStack(Blocks.field_150432_aD, 2), new ItemStack(Blocks.field_150403_cj), 1.0f);
        for (ItemStack dust : OreDictionary.getOres((String)"dustCoke")) {
            for (ItemStack ingot : OreDictionary.getOres((String)"fuelCoke")) {
                LucraftCoreRecipes.addPulverizerRecipe(ingot, dust, 1.0f);
            }
        }
    }

    public static void initAlloyRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(LucraftCoreUtil.getLCItems("dust", 3, EnumMetalTypes.INTERTIUM), new Object[]{"dustIron", "dustIron", "dustOsmium"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(LucraftCoreUtil.getLCItems("dust", 2, EnumMetalTypes.BRONZE), new Object[]{"dustCopper", "dustCopper", "dustCopper", "dustTin"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(LucraftCoreUtil.getLCItems("dust", 3, EnumMetalTypes.GOLDTITANIUM), new Object[]{"dustGold", "dustTitanium", "dustTitanium"}));
    }

    public static void addPulverizerRecipeForBlock(Block input, ItemStack stack, float experience) {
        LucraftCoreRecipes.addPulverizer(Item.func_150898_a((Block)input), stack, experience);
    }

    public static void addPulverizer(Item input, ItemStack stack, float experience) {
        LucraftCoreRecipes.addPulverizerRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack, experience);
    }

    public static void addPulverizerRecipe(ItemStack input, ItemStack stack, float experience) {
        if (LucraftCoreRecipes.getPulverizerResult(input) != null) {
            FMLLog.info((String)("Ignored pulverizer recipe with conflicting input: " + input + " = " + stack), (Object[])new Object[0]);
            return;
        }
        pulverizerList.put(input, stack);
        pulverizerExperienceList.put(stack, Float.valueOf(experience));
    }

    public static ItemStack getPulverizerResult(ItemStack stack) {
        Map.Entry<ItemStack, ItemStack> entry;
        Iterator<Map.Entry<ItemStack, ItemStack>> iterator = pulverizerList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!LucraftCoreRecipes.compareItemStacks(stack, (entry = iterator.next()).getKey()));
        return entry.getValue();
    }

    private static boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public static Map getPulverizerList() {
        return pulverizerList;
    }

    public static float getPulverizerExperience(ItemStack stack) {
        Map.Entry<ItemStack, Float> entry;
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        Iterator<Map.Entry<ItemStack, Float>> iterator = pulverizerExperienceList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 0.0f;
        } while (!LucraftCoreRecipes.compareItemStacks(stack, (entry = iterator.next()).getKey()));
        return entry.getValue().floatValue();
    }

    public static void addCompressorRecipeForBlock(Block input, ItemStack stack, float experience) {
        LucraftCoreRecipes.addCompressor(Item.func_150898_a((Block)input), stack, experience);
    }

    public static void addCompressor(Item input, ItemStack stack, float experience) {
        LucraftCoreRecipes.addCompressorRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack, experience);
    }

    public static void addCompressorRecipe(ItemStack input, ItemStack stack, float experience) {
        if (LucraftCoreRecipes.getCompressorResult(input) != null) {
            FMLLog.info((String)("Ignored compressor recipe with conflicting input: " + input + " = " + stack), (Object[])new Object[0]);
            return;
        }
        compressorList.put(input, stack);
        compressorExperienceList.put(stack, Float.valueOf(experience));
    }

    public static ItemStack getCompressorResult(ItemStack stack) {
        Map.Entry<ItemStack, ItemStack> entry;
        Iterator<Map.Entry<ItemStack, ItemStack>> iterator = compressorList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!LucraftCoreRecipes.compareItemStacks(stack, (entry = iterator.next()).getKey()));
        return entry.getValue();
    }

    public static Map getCompressorList() {
        return compressorList;
    }

    public static float getCompressorExperience(ItemStack stack) {
        Map.Entry<ItemStack, Float> entry;
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        Iterator<Map.Entry<ItemStack, Float>> iterator = compressorExperienceList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 0.0f;
        } while (!LucraftCoreRecipes.compareItemStacks(stack, (entry = iterator.next()).getKey()));
        return entry.getValue().floatValue();
    }
}

