/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util;

import java.text.SimpleDateFormat;
import lucraft.mods.lucraftcore.EnumMetalTypes;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.entity.EntityMountableBlock;
import lucraft.mods.lucraftcore.items.LCItems;
import lucraft.mods.lucraftcore.recipes.LucraftCoreRecipes;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class LucraftCoreUtil {
    public static void registerItemModel(Item item, String resource) {
        LucraftCore.proxy.registerItemModel(item, resource);
    }

    public static void registerItemModel(Item item, int meta, String resource) {
        LucraftCore.proxy.registerItemModel(item, meta, resource);
    }

    public static void registerBlockModel(Block block, String resource) {
        LucraftCore.proxy.registerBlockModel(block, resource);
    }

    public static void registerBlockModel(Block block, int meta, String resource) {
        LucraftCore.proxy.registerBlockModel(block, meta, resource);
    }

    public static ItemStack getLCItems(String type, int amount, EnumMetalTypes metal) {
        Object item = type.equalsIgnoreCase("ingot") ? LCItems.ingot : (type.equalsIgnoreCase("dust") ? LCItems.dust : (type.equalsIgnoreCase("nugget") ? LCItems.nugget : (type.equalsIgnoreCase("plate") ? LCItems.plate : null)));
        return new ItemStack(item, amount, metal.getId());
    }

    public static void addOreDictionaryMetalFurnaceRecipe(EnumMetalTypes type, float xp) {
        LucraftCoreUtil.addOreDictionaryMetalFurnaceRecipe(type.getMetalName(), type.isAlloy(), xp);
    }

    public static void addOreDictionaryMetalFurnaceRecipe(String name, boolean isAlloy, float xp) {
        for (ItemStack dust : OreDictionary.getOres((String)("dust" + name))) {
            for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + name))) {
                GameRegistry.addSmelting((ItemStack)dust, (ItemStack)ingot, (float)xp);
            }
        }
        if (!isAlloy) {
            for (ItemStack ore : OreDictionary.getOres((String)("ore" + name))) {
                for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + name))) {
                    GameRegistry.addSmelting((ItemStack)ore, (ItemStack)ingot, (float)xp);
                }
            }
        }
    }

    public static void registerStorageBlockRecipe(EnumMetalTypes type) {
        LucraftCoreUtil.registerStorageBlockRecipe(type.getMetalName());
    }

    public static void registerStorageBlockRecipe(String name) {
        for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + name))) {
            ItemStack ingots = ingot.func_77946_l();
            ingots.field_77994_a = 9;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ingots, new Object[]{"X", Character.valueOf('X'), "block" + name}));
        }
        for (ItemStack block : OreDictionary.getOres((String)("block" + name))) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(block, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), "ingot" + name}));
        }
    }

    public static void registerNuggetRecipe(EnumMetalTypes type) {
        LucraftCoreUtil.registerNuggetRecipe(type.getMetalName());
    }

    public static void registerNuggetRecipe(String name) {
        for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + name))) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ingot, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), "nugget" + name}));
        }
        for (ItemStack nugget : OreDictionary.getOres((String)("nugget" + name))) {
            ItemStack nuggets = nugget.func_77946_l();
            nuggets.field_77994_a = 9;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(nuggets, new Object[]{"X", Character.valueOf('X'), "ingot" + name}));
        }
    }

    public static void addOreDictionaryMetalPulverizerRecipe(EnumMetalTypes type, float xp) {
        LucraftCoreUtil.addOreDictionaryMetalPulverizerRecipe(type.getMetalName(), type.isAlloy(), xp);
    }

    public static void addOreDictionaryMetalPulverizerRecipe(String name, boolean isAlloy, float xp) {
        for (ItemStack dust : OreDictionary.getOres((String)("dust" + name))) {
            for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + name))) {
                LucraftCoreRecipes.addPulverizerRecipe(ingot, dust, 1.0f);
            }
        }
        if (!isAlloy) {
            for (ItemStack ore : OreDictionary.getOres((String)("ore" + name))) {
                for (ItemStack dust : OreDictionary.getOres((String)("dust" + name))) {
                    ItemStack dusts = dust.func_77946_l();
                    dusts.field_77994_a = 2;
                    LucraftCoreRecipes.addPulverizerRecipe(ore, dusts, 1.0f);
                }
            }
        }
    }

    public static void addMetalPlateRecipe(EnumMetalTypes type) {
        LucraftCoreUtil.addMetalPlateRecipe(type.getMetalName(), type.getResistance());
    }

    public static void addMetalPlateRecipe(String name, float resistance) {
        for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + name))) {
            for (ItemStack plate : OreDictionary.getOres((String)("plate" + name))) {
                if (resistance < 13.0f) {
                    GameRegistry.addShapelessRecipe((ItemStack)plate, (Object[])new Object[]{new ItemStack(LCItems.hammer, 1, Short.MAX_VALUE), ingot, ingot});
                }
                LucraftCoreRecipes.addCompressorRecipe(ingot, plate, 2.0f);
            }
        }
    }

    public static String intToTime(int time) {
        SimpleDateFormat df = new SimpleDateFormat("mm:ss");
        String formatted = df.format(time * 1000);
        return formatted;
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static boolean letPlayerSitOnBlock(EntityPlayer player, double x, double y, double z, double offset, boolean shouldRenderSit, String info) {
        EntityMountableBlock entity = new EntityMountableBlock(player.field_70170_p, x, y, z, offset, shouldRenderSit, info);
        player.field_70170_p.func_72838_d((Entity)entity);
        player.func_70078_a((Entity)entity);
        return true;
    }
}

