/*
 * Decompiled with CFR 0.152.
 */
package mapwriter;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import mapwriter.CircularHashMap;
import mapwriter.Mw;
import mapwriter.config.Config;
import mapwriter.region.MwChunk;
import mapwriter.tasks.SaveChunkTask;
import mapwriter.tasks.UpdateSurfaceChunksTask;
import mapwriter.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class ChunkManager {
    public Mw mw;
    private boolean closed = false;
    private CircularHashMap<Chunk, Integer> chunkMap = new CircularHashMap();
    private static final int VISIBLE_FLAG = 1;
    private static final int VIEWED_FLAG = 2;

    public ChunkManager(Mw mw) {
        this.mw = mw;
    }

    public synchronized void close() {
        this.closed = true;
        this.saveChunks();
        this.chunkMap.clear();
    }

    public static MwChunk copyToMwChunk(Chunk chunk) {
        Map<Object, Object> TileEntityMap = Maps.newHashMap();
        TileEntityMap = Utils.checkedMapByCopy(chunk.func_177434_r(), BlockPos.class, TileEntity.class, false);
        byte[] biomeArray = Arrays.copyOf(chunk.func_76605_m(), chunk.func_76605_m().length);
        ExtendedBlockStorage[] dataArray = Arrays.copyOf(chunk.func_76587_i(), chunk.func_76587_i().length);
        return new MwChunk(chunk.field_76635_g, chunk.field_76647_h, chunk.func_177412_p().field_73011_w.func_186058_p().func_186068_a(), dataArray, biomeArray, TileEntityMap);
    }

    public synchronized void addChunk(Chunk chunk) {
        if (!this.closed && chunk != null) {
            this.chunkMap.put(chunk, 0);
        }
    }

    public synchronized void removeChunk(Chunk chunk) {
        if (!this.closed && chunk != null) {
            if (!this.chunkMap.containsKey(chunk)) {
                return;
            }
            int flags = this.chunkMap.get(chunk);
            if ((flags & 2) != 0) {
                this.addSaveChunkTask(chunk);
            }
            this.chunkMap.remove(chunk);
        }
    }

    public synchronized void saveChunks() {
        for (Map.Entry<Chunk, Integer> entry : this.chunkMap.entrySet()) {
            int flags = entry.getValue();
            if ((flags & 2) == 0) continue;
            this.addSaveChunkTask(entry.getKey());
        }
    }

    public void updateUndergroundChunks() {
        int chunkArrayX = (this.mw.playerXInt >> 4) - 1;
        int chunkArrayZ = (this.mw.playerZInt >> 4) - 1;
        MwChunk[] chunkArray = new MwChunk[9];
        for (int z = 0; z < 3; ++z) {
            for (int x = 0; x < 3; ++x) {
                Chunk chunk = this.mw.mc.field_71441_e.func_72964_e(chunkArrayX + x, chunkArrayZ + z);
                if (chunk.func_76621_g()) continue;
                chunkArray[z * 3 + x] = ChunkManager.copyToMwChunk(chunk);
            }
        }
    }

    public void updateSurfaceChunks() {
        int chunksToUpdate = Math.min(this.chunkMap.size(), Config.chunksPerTick);
        MwChunk[] chunkArray = new MwChunk[chunksToUpdate];
        for (int i = 0; i < chunksToUpdate; ++i) {
            Map.Entry<Chunk, Integer> entry = this.chunkMap.getNextEntry();
            if (entry == null) continue;
            Chunk chunk = entry.getKey();
            int flags = entry.getValue();
            flags = Utils.distToChunkSq(this.mw.playerXInt, this.mw.playerZInt, chunk) <= Config.maxChunkSaveDistSq ? (flags |= 3) : (flags &= 0xFFFFFFFE);
            entry.setValue(flags);
            if ((flags & 1) != 0) {
                chunkArray[i] = ChunkManager.copyToMwChunk(chunk);
                this.mw.executor.addTask(new UpdateSurfaceChunksTask(this.mw, chunkArray[i]));
                continue;
            }
            chunkArray[i] = null;
        }
    }

    public void onTick() {
        if (!this.closed) {
            if ((this.mw.tickCounter & 0xF) == 0) {
                this.updateUndergroundChunks();
            } else {
                this.updateSurfaceChunks();
            }
        }
    }

    private void addSaveChunkTask(Chunk chunk) {
        if ((Minecraft.func_71410_x().func_71356_B() && Config.regionFileOutputEnabledMP || !Minecraft.func_71410_x().func_71356_B() && Config.regionFileOutputEnabledSP) && !chunk.func_76621_g()) {
            this.mw.executor.addTask(new SaveChunkTask(ChunkManager.copyToMwChunk(chunk), this.mw.regionManager));
        }
    }
}

