/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.gui;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import mapwriter.Mw;
import mapwriter.api.ILabelInfo;
import mapwriter.api.IMwDataProvider;
import mapwriter.api.MwAPI;
import mapwriter.config.Config;
import mapwriter.config.WorldConfig;
import mapwriter.forge.MwKeyHandler;
import mapwriter.gui.ModGuiConfig;
import mapwriter.gui.MwGuiDimensionDialog;
import mapwriter.gui.MwGuiLabel;
import mapwriter.gui.MwGuiMarkerDialog;
import mapwriter.gui.MwGuiMarkerDialogNew;
import mapwriter.gui.MwGuiMarkerListOverlay;
import mapwriter.gui.MwGuiTeleportDialog;
import mapwriter.map.MapRenderer;
import mapwriter.map.MapView;
import mapwriter.map.Marker;
import mapwriter.map.mapmode.MapMode;
import mapwriter.tasks.MergeTask;
import mapwriter.tasks.RebuildRegionsTask;
import mapwriter.util.Logging;
import mapwriter.util.Reference;
import mapwriter.util.Utils;
import mapwriter.util.VersionCheck;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class MwGui
extends GuiScreen {
    private Mw mw;
    public MapMode mapMode;
    private MapView mapView;
    private MapRenderer map;
    private String[] HelpText1 = new String[]{"mw.gui.mwgui.keys", "", "  Space", "  Delete", "  C", "  Home", "  End", "  N", "  T", "  P", "  R", "  U", "  L", "", "mw.gui.mwgui.helptext.1", "mw.gui.mwgui.helptext.2", "mw.gui.mwgui.helptext.3", "mw.gui.mwgui.helptext.4", "mw.gui.mwgui.helptext.5", "mw.gui.mwgui.helptext.6", "", "mw.gui.mwgui.helptext.7", "mw.gui.mwgui.helptext.8", "mw.gui.mwgui.helptext.9"};
    private String[] HelpText2 = new String[]{"", "", "mw.gui.mwgui.helptext.nextmarkergroup", "mw.gui.mwgui.helptext.deletemarker", "mw.gui.mwgui.helptext.cyclecolour", "mw.gui.mwgui.helptext.centermap", "mw.gui.mwgui.helptext.centermapplayer", "mw.gui.mwgui.helptext.selectnextmarker", "mw.gui.mwgui.helptext.teleport", "mw.gui.mwgui.helptext.savepng", "mw.gui.mwgui.helptext.regenerate", "mw.gui.mwgui.helptext.undergroundmap", "mw.gui.mwgui.helptext.markerlist"};
    private static final double PAN_FACTOR = 0.3;
    private static final int menuY = 5;
    private static final int menuX = 5;
    private int mouseLeftHeld = 0;
    private int mouseLeftDragStartX = 0;
    private int mouseLeftDragStartY = 0;
    private double viewXStart;
    private double viewZStart;
    private Marker movingMarker = null;
    private int movingMarkerXStart = 0;
    private int movingMarkerZStart = 0;
    private int mouseBlockX = 0;
    private int mouseBlockY = 0;
    private int mouseBlockZ = 0;
    private MwGuiLabel helpLabel;
    private MwGuiLabel optionsLabel;
    private MwGuiLabel dimensionLabel;
    private MwGuiLabel groupLabel;
    private MwGuiLabel overlayLabel;
    private MwGuiLabel updateLabel;
    private MwGuiMarkerListOverlay MarkerOverlay;
    private MwGuiLabel helpTooltipLabel;
    private MwGuiLabel updateTooltipLabel;
    private MwGuiLabel statusLabel;
    private MwGuiLabel markerLabel;
    public static MwGui instance;
    private URI clickedLinkURI;

    public MwGui(Mw mw) {
        this.mw = mw;
        this.mapMode = new MapMode(Config.fullScreenMap);
        this.mapView = new MapView(this.mw, true);
        this.map = new MapRenderer(this.mw, this.mapMode, this.mapView);
        this.mapView.setDimension(this.mw.miniMap.view.getDimension());
        this.mapView.setViewCentreScaled(this.mw.playerX, this.mw.playerZ, this.mw.playerDimension);
        this.mapView.setZoomLevel(Config.fullScreenZoomLevel);
        this.initLabels();
        this.MarkerOverlay = new MwGuiMarkerListOverlay(this, this.mw.markerManager);
        instance = this;
    }

    public MwGui(Mw mw, int dim, int x, int z) {
        this(mw);
        this.mapView.setDimension(dim);
        this.mapView.setViewCentreScaled(x, z, dim);
        this.mapView.setZoomLevel(Config.fullScreenZoomLevel);
    }

    public void func_73866_w_() {
        this.helpLabel.setParentWidthAndHeight(this.field_146294_l, this.field_146295_m);
        this.optionsLabel.setParentWidthAndHeight(this.field_146294_l, this.field_146295_m);
        this.dimensionLabel.setParentWidthAndHeight(this.field_146294_l, this.field_146295_m);
        this.groupLabel.setParentWidthAndHeight(this.field_146294_l, this.field_146295_m);
        this.overlayLabel.setParentWidthAndHeight(this.field_146294_l, this.field_146295_m);
        this.updateLabel.setParentWidthAndHeight(this.field_146294_l, this.field_146295_m);
        this.helpTooltipLabel.setParentWidthAndHeight(this.field_146294_l, this.field_146295_m);
        this.updateTooltipLabel.setParentWidthAndHeight(this.field_146294_l, this.field_146295_m);
        this.statusLabel.setParentWidthAndHeight(this.field_146294_l, this.field_146295_m);
        this.markerLabel.setParentWidthAndHeight(this.field_146294_l, this.field_146295_m);
        this.MarkerOverlay.setDimensions(MwGuiMarkerListOverlay.listWidth, this.field_146295_m - 20, MwGuiMarkerListOverlay.ListY, 10 + this.field_146295_m - 20, this.field_146294_l - 110);
    }

    public void initLabels() {
        this.helpLabel = new MwGuiLabel(new String[]{"[" + I18n.func_135052_a((String)"mw.gui.mwgui.help", (Object[])new Object[0]) + "]"}, null, 5, 5, true, false, this.field_146294_l, this.field_146295_m);
        this.optionsLabel = new MwGuiLabel(new String[]{"[" + I18n.func_135052_a((String)"mw.gui.mwgui.options", (Object[])new Object[0]) + "]"}, null, 0, 0, true, false, this.field_146294_l, this.field_146295_m);
        this.dimensionLabel = new MwGuiLabel(null, null, 0, 0, true, false, this.field_146294_l, this.field_146295_m);
        this.groupLabel = new MwGuiLabel(null, null, 0, 0, true, false, this.field_146294_l, this.field_146295_m);
        this.overlayLabel = new MwGuiLabel(null, null, 0, 0, true, false, this.field_146294_l, this.field_146295_m);
        String updateString = "[" + I18n.func_135052_a((String)"mw.gui.mwgui.newversion", (Object[])new Object[]{VersionCheck.getLatestVersion()}) + "]";
        this.updateLabel = new MwGuiLabel(new String[]{updateString}, null, 0, 0, true, false, this.field_146294_l, this.field_146295_m);
        this.helpTooltipLabel = new MwGuiLabel(this.HelpText1, this.HelpText2, 0, 0, true, false, this.field_146294_l, this.field_146295_m);
        this.updateTooltipLabel = new MwGuiLabel(new String[]{VersionCheck.getUpdateURL()}, null, 0, 0, true, false, this.field_146294_l, this.field_146295_m);
        this.statusLabel = new MwGuiLabel(null, null, 0, 0, true, false, this.field_146294_l, this.field_146295_m);
        this.markerLabel = new MwGuiLabel(null, null, 0, 0, true, true, this.field_146294_l, this.field_146295_m);
        this.optionsLabel.drawToRightOf(this.helpLabel);
        this.dimensionLabel.drawToRightOf(this.optionsLabel);
        this.groupLabel.drawToRightOf(this.dimensionLabel);
        this.overlayLabel.drawToRightOf(this.groupLabel);
        this.updateLabel.drawToRightOf(this.overlayLabel);
        this.helpTooltipLabel.drawToBelowOf(this.helpLabel);
        this.updateTooltipLabel.drawToBelowOf(this.helpLabel);
    }

    protected void func_146284_a(GuiButton button) {
    }

    public Marker getMarkerNearScreenPos(int x, int y) {
        Marker nearMarker = null;
        for (Marker marker : this.mw.markerManager.visibleMarkerList) {
            if (marker.screenPos == null || !(marker.screenPos.distanceSq(x, y) < 6.0)) continue;
            nearMarker = marker;
        }
        return nearMarker;
    }

    public int getHeightAtBlockPos(int bX, int bZ) {
        int bY = 0;
        int worldDimension = this.mw.mc.field_71441_e.field_73011_w.func_186058_p().func_186068_a();
        if (worldDimension == this.mapView.getDimension() && worldDimension != -1) {
            bY = this.mw.mc.field_71441_e.func_175645_m(new BlockPos(bX, 0, bZ)).func_177956_o();
        }
        return bY;
    }

    public boolean isPlayerNearScreenPos(int x, int y) {
        Point2D.Double p = this.map.playerArrowScreenPos;
        return p.distanceSq(x, y) < 9.0;
    }

    public void deleteSelectedMarker() {
        if (this.mw.markerManager.selectedMarker != null) {
            this.mw.markerManager.delMarker(this.mw.markerManager.selectedMarker);
            this.mw.markerManager.update();
            this.mw.markerManager.selectedMarker = null;
        }
    }

    public void mergeMapViewToImage() {
        this.mw.chunkManager.saveChunks();
        this.mw.executor.addTask(new MergeTask(this.mw.regionManager, (int)this.mapView.getX(), (int)this.mapView.getZ(), (int)this.mapView.getWidth(), (int)this.mapView.getHeight(), this.mapView.getDimension(), this.mw.worldDir, this.mw.worldDir.getName()));
        Utils.printBoth(I18n.func_135052_a((String)"mw.gui.mwgui.chatmsg.merge", (Object[])new Object[]{this.mw.worldDir.getAbsolutePath()}));
    }

    public void regenerateView() {
        Utils.printBoth(I18n.func_135052_a((String)"mw.gui.mwgui.chatmsg.regenmap", (Object[])new Object[]{(int)this.mapView.getWidth(), (int)this.mapView.getHeight(), (int)this.mapView.getMinX(), (int)this.mapView.getMinZ()}));
        this.mw.executor.addTask(new RebuildRegionsTask(this.mw, (int)this.mapView.getMinX(), (int)this.mapView.getMinZ(), (int)this.mapView.getWidth(), (int)this.mapView.getHeight(), this.mapView.getDimension()));
    }

    protected void func_73869_a(char c, int key) {
        switch (key) {
            case 1: {
                this.exitGui();
                break;
            }
            case 211: {
                this.deleteSelectedMarker();
                break;
            }
            case 57: {
                this.mw.markerManager.nextGroup();
                this.mw.markerManager.update();
                break;
            }
            case 46: {
                if (this.mw.markerManager.selectedMarker == null) break;
                this.mw.markerManager.selectedMarker.colourNext();
                break;
            }
            case 49: {
                this.mw.markerManager.selectNextMarker();
                break;
            }
            case 199: {
                this.mapView.setViewCentreScaled(this.mw.playerX, this.mw.playerZ, this.mw.playerDimension);
                break;
            }
            case 207: {
                this.centerOnSelectedMarker();
                break;
            }
            case 25: {
                this.mergeMapViewToImage();
                this.exitGui();
                break;
            }
            case 20: {
                if (this.mw.markerManager.selectedMarker != null) {
                    this.mw.teleportToMarker(this.mw.markerManager.selectedMarker);
                    this.exitGui();
                    break;
                }
                this.field_146297_k.func_147108_a((GuiScreen)new MwGuiTeleportDialog(this, this.mw, this.mapView, this.mouseBlockX, Config.defaultTeleportHeight, this.mouseBlockZ));
                break;
            }
            case 203: {
                this.mapView.panView(-0.3, 0.0);
                break;
            }
            case 205: {
                this.mapView.panView(0.3, 0.0);
                break;
            }
            case 200: {
                this.mapView.panView(0.0, -0.3);
                break;
            }
            case 208: {
                this.mapView.panView(0.0, 0.3);
                break;
            }
            case 19: {
                this.regenerateView();
                this.exitGui();
                break;
            }
            case 38: {
                this.MarkerOverlay.setEnabled(!this.MarkerOverlay.getEnabled());
                break;
            }
            default: {
                if (key == MwKeyHandler.keyMapGui.func_151463_i()) {
                    this.exitGui();
                    break;
                }
                if (key == MwKeyHandler.keyZoomIn.func_151463_i()) {
                    this.mapView.adjustZoomLevel(-1);
                    break;
                }
                if (key == MwKeyHandler.keyZoomOut.func_151463_i()) {
                    this.mapView.adjustZoomLevel(1);
                    break;
                }
                if (key == MwKeyHandler.keyNextGroup.func_151463_i()) {
                    this.mw.markerManager.nextGroup();
                    this.mw.markerManager.update();
                    break;
                }
                if (key != MwKeyHandler.keyUndergroundMode.func_151463_i()) break;
                this.mw.toggleUndergroundMode();
            }
        }
    }

    public void func_146274_d() throws IOException {
        if (this.MarkerOverlay.isMouseInField() && this.mouseLeftHeld == 0) {
            this.MarkerOverlay.handleMouseInput();
        } else {
            if (MwAPI.getCurrentDataProvider() != null && MwAPI.getCurrentDataProvider().onMouseInput(this.mapView, this.mapMode)) {
                return;
            }
            int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            int direction = Mouse.getEventDWheel();
            if (direction != 0) {
                this.mouseDWheelScrolled(x, y, direction);
            }
        }
        super.func_146274_d();
    }

    protected void func_73864_a(int x, int y, int button) {
        Marker marker = this.getMarkerNearScreenPos(x, y);
        Marker prevMarker = this.mw.markerManager.selectedMarker;
        if (this.MarkerOverlay.isMouseInField() && this.mouseLeftHeld == 0) {
            this.MarkerOverlay.handleMouseInput();
        } else {
            block22: {
                if (button == 0) {
                    if (this.dimensionLabel.posWithin(x, y)) {
                        this.field_146297_k.func_147108_a((GuiScreen)new MwGuiDimensionDialog((GuiScreen)this, this.mw, this.mapView, this.mapView.getDimension()));
                    } else if (this.optionsLabel.posWithin(x, y)) {
                        try {
                            GuiScreen newScreen = (GuiScreen)ModGuiConfig.class.getConstructor(GuiScreen.class).newInstance(new Object[]{this});
                            this.field_146297_k.func_147108_a(newScreen);
                        }
                        catch (Exception e) {
                            Logging.logError("There was a critical issue trying to build the config GUI for %s", "MapWriter");
                        }
                    } else if (this.updateLabel.posWithin(x, y)) {
                        if (!this.field_146297_k.field_71474_y.field_74359_p) {
                            return;
                        }
                        try {
                            URI uri = new URI(VersionCheck.getUpdateURL());
                            if (!Reference.PROTOCOLS.contains(uri.getScheme().toLowerCase())) {
                                throw new URISyntaxException(uri.toString(), "Unsupported protocol: " + uri.getScheme().toLowerCase());
                            }
                            if (this.field_146297_k.field_71474_y.field_74358_q) {
                                this.clickedLinkURI = uri;
                                this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, uri.toString(), 31102009, false));
                                break block22;
                            }
                            Utils.openWebLink(uri);
                        }
                        catch (URISyntaxException urisyntaxexception) {
                            Logging.logError("Can't open url for %s", urisyntaxexception);
                        }
                    } else {
                        this.mouseLeftHeld = 1;
                        this.mouseLeftDragStartX = x;
                        this.mouseLeftDragStartY = y;
                        this.mw.markerManager.selectedMarker = marker;
                        if (marker != null && prevMarker == marker) {
                            this.movingMarker = marker;
                            this.movingMarkerXStart = marker.x;
                            this.movingMarkerZStart = marker.z;
                        }
                    }
                } else if (button == 1) {
                    this.openMarkerGui(marker, x, y);
                } else if (button == 2) {
                    Point blockPoint = this.mapMode.screenXYtoBlockXZ(this.mapView, x, y);
                    IMwDataProvider provider = MwAPI.getCurrentDataProvider();
                    if (provider != null) {
                        provider.onMiddleClick(this.mapView.getDimension(), blockPoint.x, blockPoint.y, this.mapView);
                    }
                }
            }
            this.viewXStart = this.mapView.getX();
            this.viewZStart = this.mapView.getZ();
        }
    }

    protected void func_146286_b(int x, int y, int button) {
        if (button == 0) {
            this.mouseLeftHeld = 0;
            this.movingMarker = null;
        } else if (button == 1) {
            // empty if block
        }
    }

    public void mouseDWheelScrolled(int x, int y, int direction) {
        Marker marker = this.getMarkerNearScreenPos(x, y);
        if (marker != null && marker == this.mw.markerManager.selectedMarker) {
            if (direction > 0) {
                marker.colourNext();
            } else {
                marker.colourPrev();
            }
        } else if (this.dimensionLabel.posWithin(x, y)) {
            int n = direction > 0 ? 1 : -1;
            this.mapView.nextDimension(WorldConfig.getInstance().dimensionList, n);
        } else if (this.groupLabel.posWithin(x, y)) {
            int n = direction > 0 ? 1 : -1;
            this.mw.markerManager.nextGroup(n);
            this.mw.markerManager.update();
        } else if (this.overlayLabel.posWithin(x, y)) {
            int n;
            int n2 = n = direction > 0 ? 1 : -1;
            if (MwAPI.getCurrentDataProvider() != null) {
                MwAPI.getCurrentDataProvider().onOverlayDeactivated(this.mapView);
            }
            if (n == 1) {
                MwAPI.setNextProvider();
            } else {
                MwAPI.setPrevProvider();
            }
            if (MwAPI.getCurrentDataProvider() != null) {
                MwAPI.getCurrentDataProvider().onOverlayActivated(this.mapView);
            }
        } else {
            int zF = direction > 0 ? -1 : 1;
            this.mapView.zoomToPoint(this.mapView.getZoomLevel() + zF, this.mouseBlockX, this.mouseBlockZ);
            Config.fullScreenZoomLevel = this.mapView.getZoomLevel();
        }
    }

    public void exitGui() {
        this.field_146297_k.func_147108_a((GuiScreen)null);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.mw.miniMap.view.setDimension(this.mapView.getDimension());
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
    }

    public void drawStatus(int bX, int bY, int bZ) {
        IMwDataProvider provider;
        StringBuilder builder = new StringBuilder();
        if (bY != 0) {
            builder.append(I18n.func_135052_a((String)"mw.gui.mwgui.status.cursor", (Object[])new Object[]{bX, bY, bZ}));
        } else {
            builder.append(I18n.func_135052_a((String)"mw.gui.mwgui.status.cursorNoY", (Object[])new Object[]{bX, bZ}));
        }
        if (this.field_146297_k.field_71441_e != null && !this.field_146297_k.field_71441_e.func_175726_f(new BlockPos(bX, 0, bZ)).func_76621_g()) {
            builder.append(", ");
            builder.append(I18n.func_135052_a((String)"mw.gui.mwgui.status.biome", (Object[])new Object[]{this.field_146297_k.field_71441_e.getBiomeForCoordsBody(new BlockPos(bX, 0, bZ)).func_185359_l()}));
        }
        if ((provider = MwAPI.getCurrentDataProvider()) != null) {
            builder.append(provider.getStatusString(this.mapView.getDimension(), bX, bY, bZ));
        }
        String s = builder.toString();
        int x = this.field_146294_l / 2 - 10 - this.field_146289_q.func_78256_a(s) / 2;
        this.statusLabel.setCoords(x, this.field_146295_m - 21);
        this.statusLabel.setText(new String[]{builder.toString()}, null);
        this.statusLabel.draw();
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.mapView.setUndergroundMode(Config.undergroundMode);
        this.func_146276_q_();
        double xOffset = 0.0;
        double yOffset = 0.0;
        if (this.mouseLeftHeld > 2) {
            xOffset = (double)(this.mouseLeftDragStartX - mouseX) * this.mapView.getWidth() / (double)this.mapMode.getW();
            yOffset = (double)(this.mouseLeftDragStartY - mouseY) * this.mapView.getHeight() / (double)this.mapMode.getH();
            if (this.movingMarker != null) {
                double scale = this.mapView.getDimensionScaling(this.movingMarker.dimension);
                this.movingMarker.x = this.movingMarkerXStart - (int)(xOffset / scale);
                this.movingMarker.z = this.movingMarkerZStart - (int)(yOffset / scale);
            } else {
                this.mapView.setViewCentre(this.viewXStart + xOffset, this.viewZStart + yOffset);
            }
        }
        if (this.mouseLeftHeld > 0) {
            ++this.mouseLeftHeld;
        }
        this.map.draw();
        Point p = this.mapMode.screenXYtoBlockXZ(this.mapView, mouseX, mouseY);
        this.mouseBlockX = p.x;
        this.mouseBlockZ = p.y;
        this.mouseBlockY = this.getHeightAtBlockPos(this.mouseBlockX, this.mouseBlockZ);
        this.drawMarkerLabel(mouseX, mouseY, f);
        this.drawStatus(this.mouseBlockX, this.mouseBlockY, this.mouseBlockZ);
        this.drawLabel(mouseX, mouseY, f);
        this.MarkerOverlay.drawScreen(mouseX, mouseY, f);
        super.func_73863_a(mouseX, mouseY, f);
    }

    private void drawMarkerLabel(int mouseX, int mouseY, float f) {
        ILabelInfo info;
        Marker marker = this.getMarkerNearScreenPos(mouseX, mouseY);
        if (marker != null) {
            this.markerLabel.setText(new String[]{marker.name, String.format("(%d, %d, %d)", marker.x, marker.y, marker.z)}, null);
            this.markerLabel.setCoords(mouseX + 8, mouseY);
            this.markerLabel.draw();
            return;
        }
        if (this.isPlayerNearScreenPos(mouseX, mouseY)) {
            this.markerLabel.setText(new String[]{this.field_146297_k.field_71439_g.getDisplayNameString(), String.format("(%d, %d, %d)", this.mw.playerXInt, this.mw.playerYInt, this.mw.playerZInt)}, null);
            this.markerLabel.setCoords(mouseX + 8, mouseY);
            this.markerLabel.draw();
            return;
        }
        IMwDataProvider provider = MwAPI.getCurrentDataProvider();
        if (provider != null && (info = provider.getLabelInfo(mouseX, mouseY)) != null) {
            this.markerLabel.setText(info.getInfoText(), null);
            this.markerLabel.setCoords(mouseX + 8, mouseY);
            this.markerLabel.draw();
            return;
        }
    }

    private void drawLabel(int mouseX, int mouseY, float f) {
        this.helpLabel.draw();
        this.optionsLabel.draw();
        String dimString = "[" + I18n.func_135052_a((String)"mw.gui.mwgui.dimension", (Object[])new Object[]{this.mapView.getDimension()}) + "]";
        this.dimensionLabel.setText(new String[]{dimString}, null);
        this.dimensionLabel.draw();
        String groupString = "[" + I18n.func_135052_a((String)"mw.gui.mwgui.group.1", (Object[])new Object[]{this.mw.markerManager.getVisibleGroupName()}) + "]";
        this.groupLabel.setText(new String[]{groupString}, null);
        this.groupLabel.draw();
        String overlayString = "[" + I18n.func_135052_a((String)"mw.gui.mwgui.overlay", (Object[])new Object[]{MwAPI.getCurrentProviderName()}) + "]";
        this.overlayLabel.setText(new String[]{overlayString}, null);
        this.overlayLabel.draw();
        if (!VersionCheck.isLatestVersion()) {
            this.updateLabel.draw();
        }
        if (this.helpLabel.posWithin(mouseX, mouseY)) {
            this.helpTooltipLabel.draw();
        }
        if (this.updateLabel.posWithin(mouseX, mouseY)) {
            this.updateTooltipLabel.draw();
        }
    }

    public void func_73878_a(boolean result, int id) {
        if (id == 31102009) {
            if (result) {
                Utils.openWebLink(this.clickedLinkURI);
            }
            this.clickedLinkURI = null;
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }
    }

    public void centerOnSelectedMarker() {
        if (this.mw.markerManager.selectedMarker != null) {
            this.mapView.setViewCentreScaled(this.mw.markerManager.selectedMarker.x, this.mw.markerManager.selectedMarker.z, 0);
        }
    }

    public void openMarkerGui(Marker m, int mouseX, int mouseY) {
        if (m != null && this.mw.markerManager.selectedMarker == m) {
            if (Config.newMarkerDialog) {
                this.field_146297_k.func_147108_a((GuiScreen)new MwGuiMarkerDialogNew(this, this.mw.markerManager, m));
            } else {
                this.field_146297_k.func_147108_a((GuiScreen)new MwGuiMarkerDialog(this, this.mw.markerManager, m));
            }
        } else if (m == null) {
            int mz;
            int my;
            int mx;
            String group = this.mw.markerManager.getVisibleGroupName();
            if (group.equals("none")) {
                group = I18n.func_135052_a((String)"mw.gui.mwgui.group.2", (Object[])new Object[0]);
            }
            if (this.isPlayerNearScreenPos(mouseX, mouseY)) {
                mx = this.mw.playerXInt;
                my = this.mw.playerYInt;
                mz = this.mw.playerZInt;
            } else {
                mx = this.mouseBlockX;
                my = this.mouseBlockY > 0 ? this.mouseBlockY : Config.defaultTeleportHeight;
                mz = this.mouseBlockZ;
            }
            if (Config.newMarkerDialog) {
                this.field_146297_k.func_147108_a((GuiScreen)new MwGuiMarkerDialogNew(this, this.mw.markerManager, "", group, mx, my, mz, this.mapView.getDimension()));
            } else {
                this.field_146297_k.func_147108_a((GuiScreen)new MwGuiMarkerDialog(this, this.mw.markerManager, "", group, mx, my, mz, this.mapView.getDimension()));
            }
        }
    }
}

